package com.sd.cavphmi.viewmodels

import android.content.Context
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.viewModelScope
import com.google.gson.Gson
import com.sd.cavphmi.base.MyBaseViewModel
import com.sd.cavphmi.bean.AvpStatuBean
import com.sd.cavphmi.bean.CarVehicle
import com.sd.cavphmi.bean.PerceptionBean
import com.sd.cavphmi.bean.SpaceInfoBean
import com.sd.cavphmi.bean.V2xStartBean
import com.sd.cavphmi.bean.VToXImgBean
import com.sd.cavphmi.bean.VehDetailBean
import com.sd.cavphmi.bean.VehicleStats
import com.sd.cavphmi.highmap.HighMapApi
import com.sd.cavphmi.net.MyResult
import com.sd.cavphmi.repositorys.AvpDataRepo
import com.sd.cavphmi.utils.FileIoUtils
import com.sd.cavphmi.utils.MyContants
import com.sd.cavphmi.utils.ToastHelper
import com.sd.cavphmi.websockets.FeelTargetWSClient
import com.sd.cavphmi.websockets.V2xWSClient
import com.sd.cavphmi.websockets.VecLocWSClient
import dagger.hilt.android.lifecycle.HiltViewModel
import dagger.hilt.android.qualifiers.ApplicationContext
import kotlinx.coroutines.launch
import java.net.URI
import javax.inject.Inject


@HiltViewModel
class MainVm @Inject constructor(
    @ApplicationContext private var context: Context,
    private var avpDataRepo: AvpDataRepo
) : MyBaseViewModel() {

//    private var client: MyWebSocketClient? = null

    private val TAG = "MainVm"

    //网联车辆位姿socket
    private var vecLocWSClient = VecLocWSClient(URI(MyContants.WS_VEH_LOC))

    //感知物socket
    private var feelTargetWSClient = FeelTargetWSClient(URI(MyContants.WS_FEEL_TARGET))

    //v2x预警socket
    private var v2xWSClient = V2xWSClient(URI(MyContants.WS_V2X))

    //网联车辆状态
//    private var vehStatuWSClient = VehStatuWSClient(URI(MyContants.WS_VEH_STATU))

    //socket 管理
    private var sockets = listOf(vecLocWSClient, feelTargetWSClient, v2xWSClient)


    //感知延时
//    private var preDelayWSClient: PreDelayWSClient? = null

    //交通感知事件
//    private var trafficPreWSClient: TrafficPreWSClient? = null

    //交通信号灯
//    private var trafficLightWSClient: TrafficLightWSClient? = null

    private var gson = Gson()

    //模拟操作
    lateinit var mockVM: MockVM

    //是否需要模拟
    var isMock = false

    //车辆位姿数据
    var carVehicle = MutableLiveData<CarVehicle>()

    //车辆详情
    var vehDetail = MutableLiveData<VehDetailBean>()

    //感知目标物
    var targetPre = MutableLiveData<PerceptionBean>()

    //v2x 预警
    var v2xStartBean = MutableLiveData<V2xStartBean>()

    //联网车辆状态数据
    var vehicleStat = MutableLiveData<VehicleStats>()

    //avp状态数据
    var avpStatu = MutableLiveData<AvpStatuBean>()
    //车位占用情况
    var spaceInfo = MutableLiveData<SpaceInfoBean>()

    //交通感知
//    var trafficPerBean = MutableLiveData<TrafficPerBean>()

    //交通信号灯
//    var trafficLightBean = MutableLiveData<TrafficLightBean>()


    // 订单详情
//    private var orderTimer = Timer()


//    fun startWS() {
//        val httpHeaders = mutableMapOf<String, String>()
//        httpHeaders.put("Cookie", "username=nemo")
//        try {
//            client = MyWebSocketClient(URI(MyContants.WS_HOST))
//            client?.onSocketCb = onSocketCb
//            client?.onDataCb = onDataCb
//            client?.connect()
//        } catch (e: Exception) {
//
//        }
//    }

    /***清理资源***/
    fun cleanRes() {
        sockets.forEach {
            it.close()
        }
    }


    //获取车辆详情 传{}就行，正常应该是传场地ID，但是亦庄这个和太和桥车是一样的,用于拿到车内视频
    fun getVehDetail(id: String = ""): LiveData<VehDetailBean> {
        viewModelScope.launch {
            var result = avpDataRepo.getVehDetail(id)
            when (result) {
                is MyResult.Success<VehDetailBean> -> {
                    vehDetail.postValue(result.data)
                }

                else -> {
                }
            }
        }
        return vehDetail
    }


   /* HTTP获取车位占用情况
    通过车位号传给四维高精地图*/
    fun getSpaceInfo(): LiveData<SpaceInfoBean> {
        viewModelScope.launch {
            var result = avpDataRepo.getSpaceInfo()
            when (result) {
                is MyResult.Success<SpaceInfoBean> -> {
                    var str = gson.toJson(result)
                    FileIoUtils.writeToFile(str, "space_info.txt")
                    spaceInfo.postValue(result.data)
                }

                else -> {
                }
            }
        }
        return spaceInfo
    }

    //HTTP获取AVP状态
    fun getAvpStatus() : LiveData<AvpStatuBean>{
        viewModelScope.launch {
            var result = avpDataRepo.getAvpStatus()
            when (result) {
                is MyResult.Success<AvpStatuBean> -> {
                    var str = gson.toJson(result)
                    FileIoUtils.writeToFile(str, "avp_status.txt")
                    avpStatu.postValue(result.data)
                }

                else -> {
                }
            }
        }
        return avpStatu
    }


    /**
     * 联网车辆位姿数据
     * 传入vehicleId 和url拼接代表某辆车的预警
     * 用来控制主车移动
     */
    fun subVehicle(): LiveData<CarVehicle> {
        if (isMock) {
            mockVM.onVehicleMock(carVehicle)
        } else {
            try {
                vecLocWSClient.onDataCb = object : VecLocWSClient.OnDataCb {
                    override fun onMsg(str: String) {
                        viewModelScope.launch {
                            //下载到sd卡下面的DownLoad文件夹下面
//                            FileIoUtils.writeToFile(str, "CarVehicle.txt")
                            var carBean = gson.fromJson(str, CarVehicle::class.java)
//                            carVehicle.postValue(carBean)
                            //更新主车位置
                            var car=carBean.first()
                            HighMapApi.setCarPosition(car.heading, car.latitude, car.longitude, 20.80189)
                        }
                    }
                }
                if (!vecLocWSClient.isOpen){
                    vecLocWSClient.connect()
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
        return carVehicle
    }


    /**感知目标物数据
     *传入intersectionCode=17 拼接 代表获取某区域的感知物，目前没有数据
     */
    fun subTarget(): LiveData<PerceptionBean> {
        if (isMock) {
            mockVM.onSubTargetMock(targetPre)
        } else {
            try {
                feelTargetWSClient.onDataCb = object : FeelTargetWSClient.OnDataCb {
                    override fun onMsg(str: String) {
                        viewModelScope.launch {
//                            FileIoUtils.writeToFile(str, "PerTarget.txt")
                            var bean = gson.fromJson(str, PerceptionBean::class.java)
                            targetPre.postValue(bean)
                        }
                    }
                }
                if (!feelTargetWSClient.isOpen){
                    feelTargetWSClient.connect()
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
        return targetPre
    }

    /**
     * V2X预警开始
     * 传入vehicleId 和url拼接代表某辆车的预警
     * 某个预警id要和感知物的ptcid对上
     */
    fun subStartV2x(): LiveData<V2xStartBean> {
        if (isMock) {
            mockVM.onV2xMock(v2xStartBean)
        } else {
            try {
                v2xWSClient.onDataCb = object : V2xWSClient.OnDataCb {
                    override fun onMsg(str: String) {
                        viewModelScope.launch {
//                            FileIoUtils.writeToFile(str, "onStartV2x.txt")
                            var bean = gson.fromJson(str, V2xStartBean::class.java)
                            v2xStartBean.postValue(bean)
                        }
                    }
                }
                if (v2xWSClient.isOpen == false){
                    v2xWSClient.connect()
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
        return v2xStartBean
    }


    /**
     * 网联车辆状态
     **/
 /*   fun subVehicleStatus(): LiveData<VehicleStats> {
        if (isMock) {

        } else {
            try {
                vehStatuWSClient.onDataCb = object : VehStatuWSClient.OnDataCb {
                    override fun onMsg(str: String) {
                        viewModelScope.launch {
                            FileIoUtils.writeToFile(str, "vehicleS.txt")
                            var bean = gson.fromJson(str, VehicleStats::class.java)
                            vehicleStat.postValue(bean)
                        }
                    }
                }
                if (vehStatuWSClient.isOpen == false) {
                    vehStatuWSClient.connect()
                } else {
                    vehStatuWSClient.reconnect()
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
        return vehicleStat
    }*/


//暂时用不到---------------------------------------------


    /*** 交通（感知）事件**//*
    fun subTrafficPre(): LiveData<TrafficPerBean> {
        try {
            if (trafficPreWSClient == null) {
                trafficPreWSClient = TrafficPreWSClient(URI(MyContants.WS_TRAFFIC_PER))
                trafficPreWSClient?.connect()

                trafficPreWSClient?.onDataCb = object : TrafficPreWSClient.OnDataCb {
                    override fun onMsg(str: String) {
                        viewModelScope.launch {
                            FileIoUtils.writeToFile(str, "pre_traff.txt")
                            var bean = gson.fromJson(str, TrafficPerBean::class.java)
                            trafficPerBean.postValue(bean)
                        }
                    }
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return trafficPerBean
    }


    */
    /*** 交通信号灯**//*
    fun subTrafficLight(): LiveData<TrafficLightBean> {
        try {
            if (trafficLightWSClient == null) {
                trafficLightWSClient = TrafficLightWSClient(URI(MyContants.WS_TRAFFIC_LIGHT))
                trafficLightWSClient?.connect()

                trafficLightWSClient?.onDataCb = object : TrafficLightWSClient.OnDataCb {
                    override fun onMsg(str: String) {
                        viewModelScope.launch {
                            FileIoUtils.writeToFile(str, "traff_light.txt")
                            var bean = gson.fromJson(str, TrafficLightBean::class.java)
                            trafficLightBean.postValue(bean)
                        }
                    }
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return trafficLightBean
    }*/


//显示气泡
    fun showVToTip() {
        var imgs = VToXImgBean.imgs
        ToastHelper.showCustViewShort(context, imgs.get("2")!!)
    }


}