package com.sd.cavphmi.ui

import android.Manifest
import android.content.Intent
import android.os.Build
import androidx.lifecycle.ViewModelProvider
import com.permissionx.guolindev.PermissionX
import com.sd.cavphmi.BR
import com.sd.cavphmi.R
import com.sd.cavphmi.base.BaseActivity
import com.sd.cavphmi.base.MyBaseViewModel
import com.sd.cavphmi.databinding.ActivityBootBinding
import com.sd.cavphmi.utils.ToastHelper
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class BootActivity : BaseActivity<ActivityBootBinding, MyBaseViewModel>() {

//    private val tcpUpVM: TcpUpVM by viewModels()

    override fun getStatuBarColor(): Int {
        return -1
    }

    override fun initContentView(): Int {
        return R.layout.activity_boot
    }

    override fun initViewModel(): MyBaseViewModel {
        return ViewModelProvider(this).get(MyBaseViewModel::class.java)
    }

    override fun initVariableId(): Int {
        return BR.vm
    }

    override fun initView() {
        requestPers()
    }

    private fun starMain() {
//        requestPers()
//        binding.imageView.postDelayed({
            var jump = Intent(this, LoginActivity::class.java)
            startActivity(jump)
            finish()
//        }, 100)
    }


    fun requestPers() {
        var pers = mutableListOf<String>(
            Manifest.permission.ACCESS_BACKGROUND_LOCATION,
            Manifest.permission.ACCESS_FINE_LOCATION,
            Manifest.permission.ACCESS_COARSE_LOCATION,
            Manifest.permission.READ_PHONE_STATE
        )
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R){
            pers.add(Manifest.permission.READ_EXTERNAL_STORAGE)
            pers.add(Manifest.permission.MANAGE_EXTERNAL_STORAGE)
        }else{
            pers.add(Manifest.permission.READ_EXTERNAL_STORAGE)
        }
        PermissionX.init(this)
            .permissions(pers.toList())
            .onExplainRequestReason { scope, deniedList ->
                scope.showRequestReasonDialog(
                    deniedList,
                    "AVP 需要同意以下授权才能正常使用",
                    "好的",
                    "取消"
                )
            }
//            .onForwardToSettings { scope, deniedList ->
//                scope.showForwardToSettingsDialog(deniedList, "您需要手动在‘设置’中允许必要的权限", "OK", "Cancel")
//            }
            .request { allGranted, grantedList, deniedList ->
                if (allGranted) {
//                    ToastHelper.showShort(this, "All permissions are granted")
                    starMain()
                } else {
                    ToastHelper.showShort(this, "权限被拒")
                    binding.root.postDelayed({
                        finish()
                    }, 500)
                }
            }

    }


}