package com.sd.cavphmi.bindadapters

import android.graphics.Color
import android.view.View
import android.widget.FrameLayout
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.ProgressBar
import android.widget.TextView
import androidx.core.graphics.toColorInt
import androidx.databinding.BindingAdapter
import com.sd.cavphmi.R
import com.sd.cavphmi.bean.GearStatus
import com.sd.cavphmi.ui.view.HeadAngelView


object ShowCarPanelObject {

    @JvmStatic
    @BindingAdapter(value = ["showSpeed", "spdExp"], requireAll = false)
    fun showSpeed(tv: TextView, speed: Int, spdExp: Int) {
        tv.setText(speed.toString())
    }

    /***档位*
     * **/
    @JvmStatic
    @BindingAdapter("showTapPos")
    fun showTapPos(tv: TextView, @GearStatus gear: Int) {
        var tag = tv.tag.toString().toInt()
//        println("--------tag = ${tag}  gear = ${gear}")
        if (tag == gear) {
            tv.setTextColor(Color.BLUE)
        } else {
//            tv.setTextColor(Color.GRAY)
            tv.setTextColor("#A59C9C".toColorInt())
        }
    }

    /***剩余油或者电***/
    @JvmStatic
    @BindingAdapter("showProTv")
    fun showProTv(tv: TextView, pro: Int) {
        tv.text = "${pro}%"
    }

    /***剩余油或者电***/
    @JvmStatic
    @BindingAdapter("showProgress")
    fun showProgress(bar: ProgressBar, pro: Int) {
        bar.setProgress(pro)
    }

    /***汽车转向灯 32769  0x8009=右转 ***/
    @JvmStatic
    @BindingAdapter("showTurnLight")
    fun showTurnLight(ll: LinearLayout, lights: Int) {
        if (lights == -1)
            return
        var temp = lights
        //0：有效；1：车灯状态字段全部无效（或未获取数据）
        var valid = temp.shr(15)
        //取第3-4位 bit3=左转灯   bit4=右转灯  2个都开deng=12
        val turn = lights.and(0xC)

        var count = ll.childCount
        for (i in 0..count - 1) {
            var iv = ll.getChildAt(i) as ImageView
            var tag = iv.tag
            if (tag.equals("left")) {
                if (turn == 4) {
                    iv.setImageResource(R.drawable.trun_left_blue)
                } else {
                    iv.setImageResource(R.drawable.trun_left_grey)
                }
            } else if (tag.equals("right")) {
                if (turn == 8) {
                    iv.setImageResource(R.drawable.trun_right_blue)
                } else {
                    iv.setImageResource(R.drawable.trun_right_grey)
                }
            }

//            if (turn == 4) {
//                if (tag.equals("left")) {
//                    iv.setImageResource(R.drawable.trun_left_blue)
//                } else {
//                    iv.setImageResource(R.drawable.trun_right_grey)
//                }
//            } else if (turn == 8) {
//                if (tag.equals("right")) {
//                    iv.setImageResource(R.drawable.trun_right_blue)
//                } else {
//                    iv.setImageResource(R.drawable.trun_left_grey)
//                }
//            }
        }
    }


    /***是否自动驾驶***/
    @JvmStatic
    @BindingAdapter("showAutoDri")
    fun showAutoDri(tv: TextView, auto: Int) {
        when (auto) {
            2, 6 -> {
                tv.text = "自动驾驶"
            }

            1, 3 -> {
                tv.text = "人工驾驶"
            }
        }
    }


    /***航向角***/
    @JvmStatic
    @BindingAdapter("showHeading")
    fun showHeading(iv: HeadAngelView, heading: Float) {
//        println("---------showHeading = ${heading}")
        iv.setHeadAngel(heading)
    }



    /***高精地图里的车辆仪表界面***/
    @JvmStatic
    @BindingAdapter(value = ["showMapCarPan", "isStartNai"], requireAll = false)
    fun showMapCarPan(fl: FrameLayout, isHighMap: Boolean,isStartNai: Boolean) {
//        println("---------showHeading = ${heading}")
        if (isHighMap){
//            if (isStartNai){
                fl.visibility= View.VISIBLE
//                var params=fl.layoutParams as RelativeLayout.LayoutParams
//                params.height= DisplayUtil.dp2px(106f)
//                fl.layoutParams=params
//            }
        } else {
            fl.visibility= View.GONE
        }

    }

}