package com.sd.cavphmi.viewmodels

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.sd.cavphmi.bean.CarVehicle
import com.sd.cavphmi.net.MyResult
import com.sd.cavphmi.repositorys.AvpDataRepo
import com.sd.cavphmi.utils.MyContants
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.launch
import javax.inject.Inject

@HiltViewModel
class LoginVm @Inject constructor(private var avpDataRepo: AvpDataRepo) : ViewModel() {

    //1= 登录成功 0 = 登录失败
    var lLogin = MutableLiveData(-1)
    var loginData = MutableLiveData<String>()
        get() = field
        set(value) {
            field = value
        }

    /****
     * 登录
     * 用户名： xiaop001
     * 密码：E@H^@Lxom7v@VY@x
     * 验证码：285369(固定)
     *以上账号用于 https://172.24.124.201:19443/itg-test-portal/full/login
     * 拿到token以后放到请求头里
     * ***/
    fun login(
        user: String,
        pwd: String,
        verifyCode: Int = 276135
    ): LiveData<Int> {
        viewModelScope.launch {
            var result = avpDataRepo.login(user, pwd, verifyCode)
            when (result) {
                is MyResult.Success<String> -> {
                    MyContants.HTTP_TOKEN = result.data
                    loginData.postValue("true")
                    lLogin.value=1
                }
                else -> {
                    lLogin.value=0
                }
            }
        }
        return lLogin
    }
}