package com.sd.cavphmi.repositorys

import com.google.gson.Gson
import com.sd.cavphmi.bean.ParkLinePlan
import com.sd.cavphmi.bean.SpaceNoBean
import com.sd.cavphmi.bean.VehDetailBean
import com.sd.cavphmi.net.MyResult
import com.sd.cavphmi.net.RequestBodyUtil
import com.sd.cavphmi.net.httpmothod.ClientRetrofitMethod
import com.sd.cavphmi.utils.MyContants
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import retrofit2.HttpException
import javax.inject.Inject

class ParseSocketRepo @Inject constructor(private var clientRetrofitMethod: ClientRetrofitMethod) {

    private var gson = Gson()

//    private var orderCalled = AtomicBoolean(false)

    /**解析网络数据***/
    suspend fun <T> parseDataBean(str: String, clazz: Class<T>): T {
        return withContext(Dispatchers.Default) {
            gson.fromJson(str, clazz)
        }
    }


//
//    /**测试网络超时***/
//    suspend fun getTimeOut(): MyResult<Int> {
//        try {
//            var star = System.currentTimeMillis()
//            clientRetrofitMethod.getTimeOut()
//            var end = System.currentTimeMillis()
//            return MyResult.Success(end.minus(star).toInt())
//        } catch (e: HttpException) {
//            return MyResult.Error(e.code(), e.message() ?: "error")
//        } catch (e: Exception) {
//            return MyResult.Error(MyContants.HTTP_ERROR, e.message ?: "error")
//        }
//    }
//
//    /***查询车位信息
//     * 苏州hmi用的这个接口判断空闲车位
//     * ***/
//    suspend fun getSpaceData(): MyResult<SpaceNoBean> {
//        var map = mutableMapOf("pageNo" to 20, "pageSize" to 1000)
//        var body = RequestBodyUtil.toRequestBody(map)
//        try {
//            var bean = clientRetrofitMethod.getSpaceData(body)
//            return MyResult.Success(bean.data)
//        } catch (e: HttpException) {
////            println("e.message = ${e.message}")
//            return MyResult.Error(e.code(), e.message() ?: "error")
//        } catch (e: Exception) {
//            return MyResult.Error(MyContants.HTTP_ERROR, e.message ?: "error")
//        }
//    }
//
//    /***获取路径规划***/
//    suspend fun getLinePlaning(vehiclePlate: String = "吉AC242"): MyResult<ParkLinePlan> {
//        var map = mutableMapOf("vehiclePlate" to vehiclePlate)
//        var body = RequestBodyUtil.toRequestBody(map)
//        try {
//            var bean = clientRetrofitMethod.getLinePlaning(body)
//            return MyResult.Success(bean)
//        } catch (e: HttpException) {
//            println("e.message = ${e.message}")
//            return MyResult.Error(e.code(), e.message() ?: "error")
//        } catch (e: Exception) {
//            return MyResult.Error(MyContants.HTTP_ERROR, e.message ?: "error")
//        }
//    }


//    /**联网车辆状态数据***/
//    suspend fun<T> genVehStatus():T {
//
//    }
}