package com.sd.cavphmi.bean

/**
 * Avp 状态信息
 * {"code":1,"msg":"操作成功","result":[{"vehicleId":1694264612474306561,"vehiclePlate":"苏EAVP001","businessType":"NIL","businessTypeCode":0,"businessStatus":"NIL","businessStatusCode":0,"lines":null},{"vehicleId":1826545465602543618,"vehiclePlate":"皖BDJ1106","businessType":"NIL","businessTypeCode":0,"businessStatus":"NIL","businessStatusCode":0,"lines":null}],"success":true}
 *
 *
 *
 */
 data class AvpStatuBean(
    val businessType: String,
    val businessStatus: String,
    val drivenDecision: DrivenDecision,
//    val exceptionCode: Any,
//    val exceptionMessage: Any,
    val haulingNo: String,
//    val haulingStageState: String,
    val space: Space,
    val spaceId: String,
    val vehicleContext: VehicleContext,
    val vin: String
)

data class DrivenDecision(
    val endPoint: EndPoint,
    val progress: Any,
    val routing: Any,
    val startPoint: StartPoint,
    val trajectory: Trajectory// 全局路径
)

data class Space(
    val centerLatitude: Double,// 车位中心的纬度 02坐标系
    val centerLongitude: Double,// 车位中心的经度 02坐标系
    val code: String, // 目标车位编号
//    val createdAt: Long,
//    val elevation: Any,
    val entranceLatitude: Double,//目标车位倒车点的纬度 02坐标系
    val entranceLongitude: Double, // 目标车位倒车点的经度 02坐标系
    val id: Int, // 目标车位id
//    val line: Any,
    val name: String,
//    val occupySource: Any,
//    val occupyTime: Any,
    val placeId: Int,
    val spaceType: String,
    val state: String,
//    val surface: Any,
//    val updatedAt: Long
)

data class VehicleContext(
    val online: Boolean,
//    val perceptionContext: Any,
//    val vehicleBasic: VehicleBasic,
//    val vehicleBusinessType: Any,
    val vehicleDynamic: VehicleDynamic,
    val vin: String
)

data class EndPoint(
    val acceleration: Double,
    val altitude: Double,
    val area: Any,
    val curvature: Double,
    val curvatureRate: Double,
    val heading: Double,
    val id: String,
    val latitude: Double,
    val longitude: Double,
    val longitudinalAcce: Any,
    val longitudinalDis: Any,
    val longitudinalSpeed: Any,
    val targetSpeed: Double,
    val timestamp: Double,
    val transverseAcce: Any,
    val transverseDis: Any,
    val transverseSpeed: Any,
    val verticalAcce: Any
)

data class StartPoint(
    val acceleration: Double,
    val altitude: Double,
    val area: Any,
    val curvature: Double,
    val curvatureRate: Double,
    val heading: Double,
    val id: String,
    val latitude: Double,
    val longitude: Double,
    val longitudinalAcce: Any,
    val longitudinalDis: Any,
    val longitudinalSpeed: Any,
    val targetSpeed: Double,
    val timestamp: Double,
    val transverseAcce: Any,
    val transverseDis: Any,
    val transverseSpeed: Any,
    val verticalAcce: Any
)

data class Trajectory(
    val arrived: Boolean,
    val endPoint: EndPointX,
    val length: Double,
//    val pathArray: Any,
    val pathLine: String,
    val points: List<APoint>,  // 全局路径 02坐标系
    val startPoint: StartPointX,
    val time: Int
)

data class EndPointX(
    val acceleration: Double,
    val altitude: Double,
    val area: Any,
    val curvature: Double,
    val curvatureRate: Double,
    val heading: Double,
    val id: Any,
    val latitude: Double,
    val longitude: Double,
    val longitudinalAcce: Any,
    val longitudinalDis: Any,
    val longitudinalSpeed: Any,
    val targetSpeed: Double,
    val timestamp: Double,
    val transverseAcce: Any,
    val transverseDis: Any,
    val transverseSpeed: Any,
    val verticalAcce: Any
)

data class APoint(
    val acceleration: Double,
    val altitude: Double,
    val area: Any,
    val curvature: Double,
    val curvatureRate: Double,
    val heading: Double,
    val id: Any,
    val latitude: Double,//  全局路径的经度 02坐标系
    val longitude: Double,//  全局路径的纬度 02坐标系
    val longitudinalAcce: Any,
    val longitudinalDis: Any,
    val longitudinalSpeed: Any,
    val targetSpeed: Double,
    val timestamp: Double,
    val transverseAcce: Any,
    val transverseDis: Any,
    val transverseSpeed: Any,
    val verticalAcce: Any
)

data class StartPointX(
    val acceleration: Double,
    val altitude: Double,
    val area: Any,
    val curvature: Double,
    val curvatureRate: Double,
    val heading: Double,
    val id: Any,
    val latitude: Double,
    val longitude: Double,
    val longitudinalAcce: Any,
    val longitudinalDis: Any,
    val longitudinalSpeed: Any,
    val targetSpeed: Double,
    val timestamp: Double,
    val transverseAcce: Any,
    val transverseDis: Any,
    val transverseSpeed: Any,
    val verticalAcce: Any
)

data class VehicleBasic(
    val deviceId: String,
    val id: Int,
    val maxSpeed: Any,
    val minTurnRadius: Any,
    val vehicleLength: Any,
    val vehicleWidth: Any
)

data class VehicleDynamic(
    val accSpeed: Double,
    val doorStatus: String,
    val drivingMode: String,
    val elevation: Double,
    val gearType: String, // 档位类型
    val heading: Double,
    val latitude: Double,
    val light: Any,
    val longitude: Double,
    val power: Any,
    val speed: Double,
    val wiper: Any
)