package com.sd.cavphmi.websockets

import com.sd.cavphmi.utils.MyContants
import org.java_websocket.client.WebSocketClient
import org.java_websocket.drafts.Draft
import java.net.Socket
import java.net.URI
import java.security.SecureRandom
import java.security.cert.X509Certificate
import javax.net.ssl.SSLContext
import javax.net.ssl.SSLEngine
import javax.net.ssl.SSLSocketFactory
import javax.net.ssl.TrustManager
import javax.net.ssl.X509ExtendedTrustManager

 abstract class BaseWsClient : WebSocketClient {

    constructor(serverUri: URI) : super(serverUri) {
        if (serverUri.toString().contains("wss://")) {
            trustAllHosts()
        }
//        if (MyContants.HTTP_TOKEN.isNotEmpty()){
//            serverUri.
//        }
    }

    constructor(serverUri: URI?, protocolDraft: Draft?) : super(serverUri, protocolDraft)

    constructor(serverUri: URI?, httpHeaders: MutableMap<String, String>?) : super(
        serverUri,
        httpHeaders
    )


    private fun trustAllHosts() {
        val trustAllCerts =
            arrayOf<TrustManager>(object : X509ExtendedTrustManager() {
                override fun checkClientTrusted(
                    chain: Array<out X509Certificate?>?,
                    authType: String?,
                    socket: Socket?
                ) {
                }

                override fun checkServerTrusted(
                    chain: Array<out X509Certificate?>?,
                    authType: String?,
                    socket: Socket?
                ) {
                }

                override fun checkClientTrusted(
                    chain: Array<out X509Certificate?>?,
                    authType: String?,
                    engine: SSLEngine?
                ) {
                }

                override fun checkServerTrusted(
                    chain: Array<out X509Certificate?>?,
                    authType: String?,
                    engine: SSLEngine?
                ) {
                }

                override fun checkClientTrusted(
                    chain: Array<out X509Certificate?>?,
                    authType: String?
                ) {
                }

                override fun checkServerTrusted(
                    chain: Array<out X509Certificate?>?,
                    authType: String?
                ) {
                }

                override fun getAcceptedIssuers(): Array<out X509Certificate?>? {
                    return null
                }
            })

        try {
            val ssl = SSLContext.getInstance("SSL")
            ssl.init(null, trustAllCerts, SecureRandom())

            val socketFactory: SSLSocketFactory? = ssl.getSocketFactory()
            this.setSocketFactory(socketFactory)
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }

    }

}