package com.sd.cavphmi.viewmodels

import android.content.Context
import androidx.lifecycle.ViewModel
import com.sd.cavphmi.highmap.HighMapApi
import com.sd.cavphmi.highmap.TileJsonBean
import dagger.hilt.android.lifecycle.HiltViewModel
import dagger.hilt.android.qualifiers.ApplicationContext
import javax.inject.Inject

@HiltViewModel
class UnityMapVm @Inject constructor(
    @ApplicationContext var context: Context
) : ViewModel() {


    /**给unity读取3d tile json配置***/
    fun loadTileJson() {
        var tileJsonBean = TileJsonBean()
        HighMapApi.setTileInit(tileJsonBean)
    }


}