package com.sd.cavphmi.viewmodels

import android.content.Context
import android.graphics.BitmapFactory
import android.graphics.Point
import android.graphics.Rect
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.google.gson.Gson
import com.google.gson.JsonSyntaxException
import com.minedata.minenavi.map.Marker
import com.minedata.minenavi.map.MarkerOptions
import com.minedata.minenavi.map.MineMap
import com.minedata.minenavi.map.MyLocationStyle
import com.minedata.minenavi.map.Overlay
import com.minedata.minenavi.map.Polyline
import com.minedata.minenavi.mapdal.LatLng
import com.minedata.minenavi.mapdal.NativeEnv
import com.minedata.minenavi.mapdal.NdsPoint
import com.minedata.minenavi.util.Tools
import com.sd.cavphmi.R
import com.sd.cavphmi.bean.AvpStatuBean
import com.sd.cavphmi.bean.CarPanelBean
import com.sd.cavphmi.bean.CarVehicle
import com.sd.cavphmi.bean.PerceptionBean
import com.sd.cavphmi.bean.V2xStartBean
import com.sd.cavphmi.bean.mock.MRoutes
import com.sd.cavphmi.bean.mock.ParkPath
import com.sd.cavphmi.highmap.AllLine
import com.sd.cavphmi.highmap.HighMapApi
import com.sd.cavphmi.highmap.ParkStatu
import com.sd.cavphmi.highmap.ReverCar
import com.sd.cavphmi.highmap.Spinfo
import com.sd.cavphmi.utils.FileIoUtils
import com.sd.cavphmi.utils.MyMapUtils
import com.sd.cavphmi.utils.ToastHelper
import dagger.hilt.android.lifecycle.HiltViewModel
import dagger.hilt.android.qualifiers.ApplicationContext
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import javax.inject.Inject
import kotlin.math.absoluteValue
import kotlin.random.Random
import kotlin.random.nextInt


@HiltViewModel
class MockVM @Inject constructor(
    @ApplicationContext private var context: Context,
) : ViewModel() {

    var mMineMap: MineMap? = null

    private var gson = Gson()

    /**解析网络数据***/
    suspend fun <T> parseDataBean(str: String, clazz: Class<T>): T? {
        return withContext(Dispatchers.Default) {
            try {
                return@withContext gson.fromJson(str, clazz)
            } catch (e: JsonSyntaxException) {
                e.printStackTrace()
                return@withContext null
            }
        }
    }

    /******
     * 模拟车辆位姿 泊车
     * @param binding 里的航向角
     * @param binding 里的速度
     * **/
    fun onVehicleMockPark(
        carVehicle: MutableStateFlow<CarVehicle>
    ) {
//        HighMapApi.setCameraAngle(30f)
        viewModelScope.launch {
            var cCar: CarVehicle? = null

            var gson = Gson()
            var str =
                FileIoUtils.getAsset(context, "mock/Car_fangzhen_park.txt")   //Qgis里取的点和四维取得点混合
            val mRoutes = gson.fromJson<MRoutes>(str, MRoutes::class.java)
            //画局部图小车
            drawNavingCar(Tools.latLngToPoint(LatLng(39.81014469509955, 116.50238005214746)))
            //画局部图路径
            smallLineMock(mRoutes)
            //画终点
            addEndMarker(LatLng(39.809039362307594, 116.50254394816011))
            //用矩形框柱
            drawEndArea(
                39.81014469509955,
                116.50238005214746,
                39.809039362307594,
                116.50254394816011,
            )
            //画出全局路径
            var lines = mRoutes.rs.map {
                AllLine(it[1], it[0])
            }
            HighMapApi.setCarNavPath(lines, showdistance = 200)
            //开启流光效果
            HighMapApi.parkRoundLight("B017")
            //2旁车辆占用
            var spinfos = listOf(Spinfo().apply {
                code = "B016"
                state = true
            }, Spinfo().apply {
                code = "B018"
                state = true
            })
            HighMapApi.setParkStatu(ParkStatu(spinfos))
            //模拟车辆移动
            var head = 0.0
            var oldHead = 0.0
            var bearing = 0f
            val random = Random
            mRoutes.rs.forEachIndexed { index, it ->
                //变速
                CarPanelBean.instance.speed.set(random.nextInt(10..15))

                if (index > 0 && index < mRoutes.rs.count()) {
                    var p1 = mRoutes.rs.get(index - 1)
                    var pc = mRoutes.rs.get(index)
                    head = MyMapUtils.calculateBearing(
                        LatLng(p1[1], p1[0]),
                        LatLng(pc[1], pc[0])
                    )
                }
                cCar = CarVehicle().apply {
                    this.vehiclePos = listOf(it[0], it[1], head)
                }
                oldHead = head

                //更新主车位置
                carVehicle.value = cCar
                //更新小地图小车
                showNavingCarPosition(
                    Tools.latLngToNdsPoint(
                        LatLng(
                            cCar.vehiclePos!!.get(1),
                            cCar.vehiclePos!!.get(0)
                        )
                    ),
                    cCar.vehiclePos!!.get(2).toFloat()
                )
                //更新小地图路径
                upSmallLine(index, mRoutes)
                delay(300)
            }
            //消除全局路径
            HighMapApi.setCarNavPath(listOf())
            //删除终点mark
            deleteEndMarker()
            //删除导航小地图小车
//            deleteNavingCar()
            //地锁绘制(升起)
//            var lockStatu = LockStatu().apply {
//                code = "B017"
//                up = false
//            }
//            HighMapApi.setLockStatus(lockStatu)
            //开始泊车
            var parkStr = FileIoUtils.getAsset(context, "mock/parkpath.txt")
            val parkPath = gson.fromJson<ParkPath>(parkStr, ParkPath::class.java)
            //改变镜头角度
            HighMapApi.setCameraAngle(60f)
            HighMapApi.setCameraDistance(30f)

            //从停车点再前进一点
            var forword = parkPath.result.routes.find { it.gear == 3 }
            forword?.polyline?.forEach { poly ->
                CarPanelBean.instance.speed.set(5)//减速
                cCar = CarVehicle().apply {
                    this.vehiclePos = listOf(poly.get(0), poly.get(1), poly.get(3))
                }
                //更新主车位置
                carVehicle.value = cCar
                //更新小地图小车
                showNavingCarPosition(
                    Tools.latLngToNdsPoint(
                        LatLng(
                            cCar.vehiclePos!!.get(1),
                            cCar.vehiclePos!!.get(0)
                        )
                    ),
                    cCar.vehiclePos!!.get(2).toFloat()
                )
                delay(300)
            }
            //绘制倒车路径
            var reverCar = ReverCar().apply {
                this.cenLat = 39.80903159
                this.cenLng = 116.50246079
                this.code = "B017"
            }
            HighMapApi.setParkRever(reverCar)
            //改变镜头角度
            HighMapApi.setCameraAngle(90f)
            HighMapApi.setCameraDistance(20f)
            //挂倒挡
            CarPanelBean.instance.tapPos.set(3)
            //开始后退
            var fBack = parkPath.result.routes.find { it.gear == 1 }
            fBack?.polyline?.forEach { poly ->
                CarPanelBean.instance.speed.set(random.nextInt(1..5))//减速变速
                cCar = CarVehicle().apply {
                    this.vehiclePos = listOf(poly.get(0), poly.get(1), poly.get(3))
                }
                //更新主车位置
                carVehicle.value = cCar
                //更新小地图小车
                showNavingCarPosition(
                    Tools.latLngToNdsPoint(
                        LatLng(
                            cCar.vehiclePos!!.get(1),
                            cCar.vehiclePos!!.get(0)
                        )
                    ),
                    cCar.vehiclePos!!.get(1).toFloat()
                )
                delay(300)
            }
            //结束泊车
            HighMapApi.setParkComplete(true)
            //删除导航小地图小车
            deleteNavingCar()
            //关闭流光效果
            HighMapApi.parkRoundLight("")
            //挂P档
            CarPanelBean.instance.tapPos.set(1)
            CarPanelBean.instance.speed.set(0)
            //给个提示
            ToastHelper.showShort(context, "泊车完成")
//            delay(3000)
            //降地锁
//            lockStatu.up = false
//            HighMapApi.setLockStatus(lockStatu)
        }
    }

    fun drawEndArea(lat1: Double, lon1: Double, lat2: Double, lon2: Double) {
        val MU = 100000

        var minLat = Math.min(lat1, lat2).times(MU).toInt() - 100
        var maxLat = Math.max(lat1, lat2).times(MU).toInt() + 100
        var minLon = Math.min(lon1, lon2).times(MU).toInt() - 10
        var maxLon = Math.max(lon1, lon2).times(MU).toInt() + 10

        var rect = Rect(
            minLon, minLat, maxLon, maxLat
        )
        mMineMap?.fitWorldArea(rect)
    }

    //召车  航向角 238.38134765625
    fun onVehicleMockCall(
        carVehicle: MutableStateFlow<CarVehicle>,
        targetPre: MutableLiveData<PerceptionBean>?
    ) {
        viewModelScope.launch {
            //初始镜头角度
            HighMapApi.setCameraAngle(90f)
            HighMapApi.setCameraDistance(20f)

            delay(3000)

            //2旁车辆占用
            var spinfos = listOf(Spinfo().apply {
                code = "B016"
                state = true
            }, Spinfo().apply {
                code = "B018"
                state = true
            })
            HighMapApi.setParkStatu(ParkStatu(spinfos))

            var cCar: CarVehicle
            var gson = Gson()
            //画局部图小车
            drawNavingCar(Tools.latLngToPoint(LatLng(39.8090317, 116.5024625)))
            //画终点
            addEndMarker(LatLng(39.809955271, 116.50204936))
            //用矩形框柱
            drawEndArea(
                39.8090317,
                116.5024625,
                39.809955271625505,
                116.50204936866068
            )
            //挂前进挡
            CarPanelBean.instance.tapPos.set(2)
            var str =
                FileIoUtils.getAsset(context, "mock/Car_fangzhen_call.txt")
            val mRoutes = gson.fromJson<MRoutes>(str, MRoutes::class.java)
            //生成局部图路径
            smallLineMock(mRoutes)
            //画出全局路径
            var lines = mRoutes.rs.map {
                AllLine(it[1], it[0])
            }
            HighMapApi.setCarNavPath(lines, showdistance = 200)
            //模拟车辆移动
            var head = 0.0
            var oldHead = 0.0
            var bearing = 0.0
            val random = Random
            mRoutes.rs.forEachIndexed { index, it ->
                if (index == 1) {
                    delay(5000)
                    //开始跟车
                    HighMapApi.setCameraAngle(30f)
                    HighMapApi.setCameraDistance(8f)
                }
                if (index <= 139) {
                    //正在小心翼翼的出库
                    CarPanelBean.instance.speed.set(random.nextInt(1..5))
                }else {
                    //开起来了
                    CarPanelBean.instance.speed.set(random.nextInt(10..16))
                }
                if (index > 0 && index < mRoutes.rs.count()) {
                    var p1 = mRoutes.rs.get(index - 1)
                    var pc = mRoutes.rs.get(index)
//                    head = BasicTools.calculateBearing(p1[0],p1[1], pc[1], pc[0])
                    head = MyMapUtils.calculateBearing(
                        LatLng(p1[1], p1[0]),
                        LatLng(pc[1], pc[0])
                    )
//                    bearing = head
//                    println("-------- head = ${head}  oldHead = ${oldHead}  ${(head - oldHead).absoluteValue.toInt()}")
                    if (oldHead != 0.0 && (head - oldHead).absoluteValue.toInt() < 45) {
                        bearing = head
                    }
                    cCar = CarVehicle().apply {
                        this.vehiclePos = listOf(it[0], it[1], bearing)
                    }
                    oldHead = head
                    //更新主车位置
                    carVehicle.value = cCar
                    //更新小地图小车
                    showNavingCarPosition(
                        Tools.latLngToNdsPoint(
                            LatLng(
                                cCar.vehiclePos!!.get(1),
                                cCar.vehiclePos!!.get(0)
                            )
                        ),
                        cCar.vehiclePos!!.get(2).toFloat()
                    )
                    //更新小地图路径
                    upSmallLine(index, mRoutes)
                }
                //用矩形框柱
//                drawEndArea(
//                    it[1], it[0],
//                    39.809955271,
//                    116.50204936
//                )
                delay(200)
            }
            //消除全局路径
            HighMapApi.setCarNavPath(listOf())
            //删除终点mark
            deleteEndMarker()
            //挂N档等人
            CarPanelBean.instance.tapPos.set(0)
            CarPanelBean.instance.speed.set(0)
            ToastHelper.showShort(context, "召车完成")
            //上人
            /*      val parts = mutableListOf<String>()
                  FileIoUtils.getAssetMock(context, "mock/call_shangren.txt", parts)
                  parts.forEach { str ->
                      if (str.isNotEmpty()) {
                          var bean = parseDataBean(str, PerceptionBean::class.java)
                          if (bean != null) {
                              targetPre?.value = bean
                              delay(500)
                          }
                      }
                  }
                  HighMapApi.clearPtcData()*/
        }
    }


    /***跑服务器的模拟数据**/
    fun subVehicle(
        carLiveData: MutableStateFlow<CarVehicle>
    ) {
        viewModelScope.launch {
            var gson = Gson()
            var datas = mutableListOf<String>()
            FileIoUtils.getAssetMock(context, "mock/shiche/CarVehicle_park.txt", datas)
            var temp = ""
            datas.forEach { str ->
                try {
                    temp = str
                    val cCar = gson.fromJson<CarVehicle>(str, CarVehicle::class.java)
                    if (cCar != null || cCar?.vehiclePos != null) {
//                        carLiveData.postValue(cCar)
                        carLiveData.value = cCar
                        delay(100)
                    }
                } catch (e: JsonSyntaxException) {
                    e.printStackTrace()
                }
            }
        }
    }


    var sPolyline: Polyline? = null

    //点坐标集合
    var sLatLngs: List<LatLng>? = null

    //模拟小地图路径
    private fun smallLineMock(mRoutes: MRoutes) {
        sLatLngs = mRoutes.rs.map {
            LatLng(it[1], it[0])
        }
    }

    //更新小地图路径
    private fun upSmallLine(index: Int, mRoutes: MRoutes) {
        if (sPolyline != null) {
            mMineMap?.removeOverlay(sPolyline)
            sPolyline?.release()
        }
        var temps = sLatLngs?.subList(index, sLatLngs!!.count())
        var nPoints = temps?.map {
            Tools.latLngToNdsPoint(it)
        }?.toTypedArray()
        synchronized(NativeEnv.SyncObject) {
            sPolyline = Polyline(nPoints, false)
            sPolyline?.setStrokeStyle(Overlay.StrokeStyle.solidWithButt)
            sPolyline?.setWidth(8f)
            sPolyline?.setColor(0xFF00B578.toInt())
            mMineMap?.addOverlay(sPolyline)
        }
    }

    //路径规划终点
    private var pEndMarker: Marker? = null

    /**画路径起终点***/
    fun addEndMarker(
        mEndPoint: LatLng
    ) {
        //删除终点marker
        deleteEndMarker()
        val end_icon = BitmapFactory.decodeResource(context.resources, R.drawable.plan_end)
//        var endlatLng = Tools.pointToLatLng(mEndPoint)
        pEndMarker = mMineMap?.addMarker(
            MarkerOptions().zLevel(7).position(mEndPoint).bitmap(end_icon)
        )
    }


    private var mSmallMapCar: MyLocationStyle? = null

    //画小地图小车
    fun drawNavingCar(point: Point) {
        if (mSmallMapCar == null) {
//            mSmallMapCar = MyLocationStyle(R.drawable.angle_blue, true)
            mSmallMapCar = MyLocationStyle("res/icons/carIconInSmallMap.png", true)
            mSmallMapCar?.myLocationType(MyLocationStyle.LOCATION_TYPE_EXTERNAL)
            val scaleFactor = -
            Math.round(((10 * NativeEnv.getDpi() * 2) * 10 / (160 * 48)).toFloat())
                .toFloat() / 10
            mSmallMapCar?.scaleFactor(scaleFactor)
            mSmallMapCar?.anchor(0.5f, 0.5f)
            mSmallMapCar?.setPosition(point)
            mMineMap?.setMyLocationStyle(mSmallMapCar)
        }
    }

    /**
     * 刷新导航中的自车位置
     */
    fun showNavingCarPosition(ndsPoint: NdsPoint?, heading: Float) {
        synchronized(NativeEnv.SyncObject) {
            if (ndsPoint == null) {
                return
            }
            //刷新小地图自车位置
            if (mSmallMapCar != null) {
                var cHeading = 0f - 180f - heading

                mSmallMapCar!!.orientAngle(cHeading)
//                mSmallMapCar!!.orientAngle(heading)
                mSmallMapCar!!.setPositionNds(Tools.ndsPointToLatLng(ndsPoint))
            }
        }
    }

    /**
     * 移除导航小车
     */
    fun deleteNavingCar() {
        if (mMineMap != null && mSmallMapCar != null) {
            mMineMap?.removeOverlay(mSmallMapCar)
            mSmallMapCar!!.release()
            mSmallMapCar = null
        }
    }


    private fun deleteEndMarker() {
        if (pEndMarker != null) {
            mMineMap?.removeMarker(pEndMarker)
            pEndMarker = null
        }
    }


    //感知目标物
    fun onSubTargetMock(targetPre: MutableLiveData<PerceptionBean>) {
        viewModelScope.launch {
            val parts = mutableListOf<String>()
            FileIoUtils.getAssetMock(context, "mock/PerTarget.txt", parts)
            var temp = ""
            parts.forEach { str ->
                if (!str.isNullOrEmpty()) {
                    temp = str
                    var bean = parseDataBean(str, PerceptionBean::class.java)
//                    var bean = gson.fromJson<PerceptionBean>(str, PerceptionBean::class.java)
                    if (bean != null) {
                        targetPre.value = bean
                        delay(4500)
                    }
                }
            }
        }
    }

    //v2预警
    fun onV2xMock(targetPre: MutableLiveData<V2xStartBean>) {
        viewModelScope.launch {
            val parts = mutableListOf<String>()
            FileIoUtils.getAssetMock(context, "mock/avp_v2x.txt", parts)
            parts.forEach { str ->
                var bean = parseDataBean(str, V2xStartBean::class.java)
                if (bean != null) {
                    targetPre.value = bean
                    delay(2000)
                }
            }
        }
    }

    //全局路径发生切换
    fun onSubLinePlaningMock() {
//        viewModelScope.launch {
//            val alls = mutableListOf<String>()
//            FileIoUtils.getAssetMock(context, "mock/all_line.txt", alls)
//            alls.forEach { str ->
//                delay(1000)
//                var bean = parseSocketRepo.parseDataBean(str, AllLinePlaningBean::class.java)
//                allLine.value = bean
//            }
//        }
    }

    //模拟Http获取全局路径
    /*  suspend fun getLinePlaningMock(vehiclePlate: String): MyResult<ParkLinePlan> {
          return withContext(Dispatchers.IO) {
              val str = FileIoUtils.getAssetContent(context, "find_line.txt")
              val bean =gson.fromJson(str,ParkLinePlan::class.java)
              return@withContext MyResult.Success(bean)
          }
      }*/

    //局部路径
    fun onSubPartLineMock() {
//        viewModelScope.launch {
//            val lines = mutableListOf<String>()
//            lines.forEach { str ->
//                delay(1000)
//                var bean = parseSocketRepo.parseDataBean(str, PartLineBean::class.java)
//                allLine.value = bean
//            }
//        }
    }

    //更新停车位
    fun onPointsMock() {
//        viewModelScope.launch {
//            val points = mutableListOf<String>()
//            FileIoUtils.getAssetMock(context, "mock/change_park.txt", points)
//            points.forEach { str ->
//                delay(1000)
//                var bean = parseSocketRepo.parseDataBean(str, ParkBean::class.java)
//                println("------模拟停车位变更 = ${bean}")
//                parkBean.value = bean
//            }
//        }
    }

    fun subAvpStatus(avp: MutableSharedFlow<AvpStatuBean>) {
        viewModelScope.launch {
            var gson = Gson()
            var datas = mutableListOf<String>()
            FileIoUtils.getAssetMock(context, "mock/shiche/avp_status_park.txt", datas)
            datas.forEach {
                val statu = gson.fromJson<AvpStatuBean>(it, AvpStatuBean::class.java)
                if (statu != null) {
                    avp.emit(statu)
                    delay(2000)
                }
            }

            /*     var str = datas.first()
                 val statu = gson.fromJson<AvpStatuBean>(str, AvpStatuBean::class.java)
                 for (i in 0..10000) {
                     flow.postValue(statu)
                     delay(3000)
                 }*/
        }
    }


}