package com.sd.cavphmi.ui.fragment

import android.animation.Animator
import android.animation.Animator.AnimatorListener
import android.animation.ObjectAnimator
import android.util.Log
import android.view.View
import android.view.animation.LinearInterpolator
import androidx.core.content.ContextCompat
import androidx.fragment.app.activityViewModels
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.DividerItemDecoration
import com.sd.cavphmi.BR
import com.sd.cavphmi.R
import com.sd.cavphmi.adapter.WarnAdapter
import com.sd.cavphmi.base.BaseFragment
import com.sd.cavphmi.base.MyBaseViewModel
import com.sd.cavphmi.bean.V2xStartBean
import com.sd.cavphmi.bean.WarningBean
import com.sd.cavphmi.databinding.FragmentWarnBinding
import com.sd.cavphmi.viewmodels.MainVm
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import javax.inject.Inject


// the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
//private const val ARG_PARAM1 = "param1"
//private const val ARG_PARAM2 = "param2"

/**
 * 预警气泡
 */
@AndroidEntryPoint
class WarnFragment : BaseFragment<FragmentWarnBinding, MyBaseViewModel>() {
//
//    private var param1: String? = null
//    private var param2: String? = null
//
//    override fun onCreate(savedInstanceState: Bundle?) {
//        super.onCreate(savedInstanceState)
//        arguments?.let {
//            param1 = it.getString(ARG_PARAM1)
//            param2 = it.getString(ARG_PARAM2)
//        }
//    }

    private val mainVm: MainVm by activityViewModels()

    override fun getStatuBarColor(): Int {
        return -1
    }

    override fun isAutoStatusBarDarkModeEnable(): Boolean {
        return false
    }


    override fun initContentView(): Int {
        return R.layout.fragment_warn
    }

    override fun initViewModel(): MyBaseViewModel {
        return ViewModelProvider(this).get(MyBaseViewModel::class.java)
    }

    override fun initVariableId(): Int {
        return BR.vm
    }


    @Inject
    lateinit var warnAdapter: WarnAdapter

    override fun initView() {
        warnAdapter.animationEnable = true
        //初始化预警列表
        binding.warnList.adapter = warnAdapter
        //分割线
        val divider = DividerItemDecoration(requireContext(), DividerItemDecoration.VERTICAL)
        val drawable = ContextCompat.getDrawable(requireContext(), R.drawable.hor_divider_drawable)
        if (drawable != null) {
            divider.setDrawable(drawable)
        }
        binding.warnList.addItemDecoration(divider)

//        var temp =
//            mutableListOf(
//                WarningBean(),
//                WarningBean.instance.apply { tipStr = "222222" },
//                WarningBean().apply { tipStr = "333333333" })
//        warnAdapter.submitList(temp)

    }

    override fun initListener() {
        mainVm.v2xStartBean.observe(this) {
            Log.e("V2x", "-------------typeName--" + it?.typeName)
            var wb = showEarlyDetail(it)
            addWarnBean(wb)
        }
    }

    fun addWarnBean(wb: WarningBean) {
        if (wb.tipStr.equals("")) {
            return
        }
        synchronized(this) {
            var temp = warnAdapter.items
            var total = warnAdapter.itemCount

            if (temp.find { it.tipStr == wb.tipStr } != null) {//q去重
                return
            }
            if (total > 3) {
                var list = temp.slice(1..warnAdapter.itemCount - 1).toMutableList()
                list.add(0, wb)
                warnAdapter.submitList(list)
            } else {
                warnAdapter.add(0, wb)
            }
            lifecycleScope.launch {
                delay(5000)
                if (warnAdapter.itemCount > 0) {
                    //消除动画
                    var view = binding.warnList.getChildAt(warnAdapter.itemCount - 1)
                    fadeOutView(view)
                }
            }
        }
    }

    // 淡出效果
    private fun fadeOutView(view: View) {
        val fadeOut = ObjectAnimator.ofFloat(view, "alpha", 1f, 0f)
        fadeOut.setDuration(300) // 0.3秒
//        fadeOut.setInterpolator(LinearInterpolator())
        fadeOut.addListener(animatorListener)
        fadeOut.start()
    }

    private var animatorListener = object : AnimatorListener {
        override fun onAnimationStart(animation: Animator) {
        }

        override fun onAnimationEnd(animation: Animator) {
            warnAdapter.removeAt(warnAdapter.itemCount - 1)
        }

        override fun onAnimationCancel(animation: Animator) {
        }

        override fun onAnimationRepeat(animation: Animator) {
        }
    }

    //显示预警气泡
    private fun showEarlyDetail(v2xStartBean: V2xStartBean): WarningBean {
        var warningBean = WarningBean()
        warningBean.img = R.drawable.chao_su
        when (v2xStartBean.type) {
            1 -> {//前向碰撞
                warningBean.img = R.drawable.zhuyi_car
                warningBean.tipStr = "注意前方车辆"
            }

            4 -> {//盲区预警
                warningBean.tipStr = "左侧/右侧盲区有车辆，请注意！"
            }

            3 -> {//左转辅助
                warningBean.tipStr = "注意对向来车"
            }

            12 -> {//弱势交通参与者
                warningBean.img = R.drawable.zhuyi_xingren
                warningBean.tipStr = "注意行人"
            }

            6 -> {//紧急制动预警
                warningBean.tipStr = "前方车辆紧急制动，请减速！"
            }

            13 -> {//绿波

            }

            else -> {

            }
        }
        return warningBean
    }


    companion object {
        @JvmStatic
        fun newInstance() = WarnFragment()
    }
}