package com.sd.cavphmi.ui.dialog

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import androidx.fragment.app.DialogFragment
import com.sd.cavphmi.R
import com.sd.cavphmi.adapter.BindCarAdapter
import com.sd.cavphmi.databinding.SeleBindCarBinding
import com.sd.cavphmi.utils.DisplayUtil
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject


//private const val ARG_PARAM1 = "cars"

/***选择绑定车牌*/
class SeleBindCarDialog : DialogFragment() {

    private lateinit var binding: SeleBindCarBinding

    interface OnItemClickListener {
        //        fun onItemClick(position: Int, selectedItem: String)
        fun onItemClick(position: Int)
    }

    var itemClickListener: OnItemClickListener? = null


    private var bindCarAdapter: BindCarAdapter = BindCarAdapter()

    //车牌号
    private var plates: List<String>? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

//        window?.setDimAmount(0.5f)  override fun onCreate(savedInstanceState: Bundle?) {
//        arguments?.let {
//            plates = it.getStringArrayList(ARG_PARAM1)
//        }
//        var dialogWidth = DisplayUtil.getScreenWidthPx().times(0.8).toInt()
//        dialog?.window?.setLayout(dialogWidth, ViewGroup.LayoutParams.WRAP_CONTENT)

    }

    override fun onStart() {
        super.onStart()
        var window = dialog?.window
        window?.setBackgroundDrawableResource(R.color.transparent)

        var dialogWidth = DisplayUtil.getScreenWidthPx().times(0.6).toInt()
        dialog?.window?.setLayout(
            dialogWidth,
            LinearLayout.LayoutParams.WRAP_CONTENT
        )
    }


    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = SeleBindCarBinding.inflate(inflater, container, false)
        return binding.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        binding.recyclerView.adapter = bindCarAdapter

        bindCarAdapter.setOnItemClickListener { adapter, view, position ->
            itemClickListener?.onItemClick(position)
            dismissNow()
        }
    }

    //设置车牌号
    fun setPlates(plates: List<String>) {
        this.plates = plates
        bindCarAdapter.submitList(plates)
    }

    companion object {
        @JvmStatic
        fun newInstance() = SeleBindCarDialog()
//        @JvmStatic
//        fun newInstance(plates: ArrayList<String>) = SeleBindCarDialog().apply {
//            arguments = Bundle().apply {
//                putStringArrayList(ARG_PARAM1, plates)
//            }
//        }
    }

}