package com.sd.cavphmi.net

import com.google.gson.GsonBuilder

import com.sd.cavphmi.MyAppcation
import com.sd.cavphmi.utils.MyContants
import okhttp3.Cache
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.converter.scalars.ScalarsConverterFactory
import java.io.File


object RetrofitApi {

//    val CLIENT_BASIC = Credentials.basic("river-chief-server", "123456")
    var retrofitBuild: Retrofit.Builder
    var cache: Cache

    init {
        //设置缓存路径
        val httpCacheDirectory =
            File(
                MyAppcation.instance().applicationContext.externalCacheDir,
                "okhttp"
            )
        //设置缓存
        cache = Cache(httpCacheDirectory, 50 * 1024 * 1024)

        val mGson = GsonBuilder()
//            .registerTypeAdapter(HttpErrorBean::class.java, HttpErrorTypeAdapter())
//            .setLenient() // 设置GSON的非严格模式setLenient()
            .create()

        retrofitBuild = Retrofit.Builder()
            .baseUrl(MyContants.HOST)
            .addConverterFactory(ScalarsConverterFactory.create())
            .addConverterFactory(GsonConverterFactory.create(mGson))
//            .addCallAdapterFactory(RxJava3CallAdapterFactory.create())
    }


//    fun getSSlSocketFactory(): SslData {
//        val trustManagerFactory: TrustManagerFactory = TrustManagerFactory.getInstance(
//            TrustManagerFactory.getDefaultAlgorithm()
//        )
//        trustManagerFactory.init(null as KeyStore?)
//        val trustManagers: Array<TrustManager> = trustManagerFactory.getTrustManagers()
//        check(!(trustManagers.size != 1 || trustManagers[0] !is X509TrustManager)) {
//            ("Unexpected default trust managers:"
//                    + Arrays.toString(trustManagers))
//        }
//        val trustManager = trustManagers[0] as X509TrustManager
//
//
//        val sslContext = SSLContext.getInstance("TLS")
//        sslContext.init(null, arrayOf<TrustManager>(trustManager), null)
//        val sslSocketFactory = sslContext.socketFactory
//
//        return SslData(sslSocketFactory, trustManager)
//    }
//
//    data class SslData(val sslSocketFactory: SSLSocketFactory, var trustManager: X509TrustManager)


}