plugins {
    alias(libs.plugins.android.application)
    alias(libs.plugins.kotlin.android)
    id("dagger.hilt.android.plugin")
    id("kotlin-kapt")
//    id("com.google.protobuf")
//    alias(libs.plugins.proto.google)
}

android {
    namespace = "com.sd.cavphmi"
    compileSdk = 35

    defaultConfig {
        applicationId = "com.sd.cavphmi"
        minSdk = 31
        targetSdk = 35
        versionCode = 1
        versionName = "1.0"

        ndk {
//            abiFilters.addAll(listOf("x86_64", "arm64-v8a"))
            abiFilters.addAll(listOf("arm64-v8a","x86_64"))
        }

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
    }

    buildTypes {
        release {
            isMinifyEnabled = false
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }
    kotlinOptions {
        jvmTarget = "11"
    }
    buildFeatures {
        dataBinding = true
        viewBinding = true
    }
    lint {
        abortOnError = false
        checkReleaseBuilds = false
    }
    packaging {
        jniLibs {
            excludes.add("META-INF/*******")
            excludes.add("plugin.xml")
        }
        resources {
            excludes.addAll(
                listOf(
                    "META-INF/*******",
                    "META-INF/INDEX.LIST",
                    "META-INF/io.netty.versions.properties"
                )
            )
        }
    }
    applicationVariants.all {
        outputs.all {
            if (this is com.android.build.gradle.internal.api.ApkVariantOutputImpl) {
                val config = project.android.defaultConfig
                val versionName = config.versionName
//               val formatter = DateTimeFormatter.ofPattern("yyyy_MM_dd_HHmm")
//               val createTime = LocalDateTime.now().format(formatter)
                outputFileName = "avp_${versionName}.apk"
            }
        }
    }
}


dependencies {
    implementation(fileTree(mapOf("dir" to "libs", "include" to listOf("*.jar", "*.aar"))))
    implementation(libs.androidx.core.ktx)
    implementation(libs.androidx.appcompat)
    implementation(libs.material)
    implementation(libs.androidx.activity)
    implementation(libs.androidx.constraintlayout)
//    implementation(libs.androidx.navigation.fragment.ktx)
//    implementation(libs.androidx.navigation.ui.ktx)
    androidTestImplementation("org.jetbrains.kotlinx:kotlinx-coroutines-test:1.10.2")
    testImplementation(libs.junit)
    androidTestImplementation(libs.androidx.junit)
    androidTestImplementation(libs.androidx.espresso.core)

    implementation("com.tencent:mmkv:2.2.4")
    implementation("io.github.cymchad:BaseRecyclerViewAdapterHelper4:4.1.7")
    implementation("com.jakewharton.rxbinding4:rxbinding:4.0.0")
    //屏幕适配
    implementation("com.github.JessYanCoding:AndroidAutoSize:v1.2.1")
    //用于坐标重投影的Proj.4库的Java端口
//    implementation("org.locationtech.proj4j:proj4j:1.4.1")
//    // https://mvnrepository.com/artifact/org.locationtech.proj4j/proj4j-epsg
//    implementation("org.locationtech.proj4j:proj4j-epsg:1.3.0")// 包含EPSG定义
    //sm4 加密
    implementation("org.bouncycastle:bcprov-jdk15on:1.70")
    //公共工具类库
    implementation(project(":mycomutils"))

    implementation("com.google.protobuf:protobuf-java:4.31.1")
//    implementation("com.google.protobuf:protobuf-javalite:4.31.1")CRSFactory
//    implementation("com.google.protobuf:protoc:3.0.0")
//    implementation("com.google.protobuf:protobuf-kotlin-lite:4.31.1")

    //播放器
    implementation("androidx.media3:media3-exoplayer:1.8.0")
    implementation("androidx.media3:media3-exoplayer-dash:1.8.0")
    implementation("androidx.media3:media3-ui:1.8.0")
    implementation("androidx.media3:media3-ui-compose:1.8.0")

    //java web socket
    implementation("org.java-websocket:Java-WebSocket:1.6.0")
    //proto
    // Hilt dependencies
    val hilt_version = "2.56.1"
    implementation("com.google.dagger:hilt-android:$hilt_version")
    kapt("com.google.dagger:hilt-android-compiler:${hilt_version}")
    // ViewModel
    implementation("androidx.lifecycle:lifecycle-viewmodel-ktx:2.6.2")
    //fragment-ktx
    implementation("androidx.fragment:fragment-ktx:1.8.0")
    // 权限请求框架
    implementation("com.guolindev.permissionx:permissionx:1.8.1")
    //加密库
//    implementation("androidx.security:security-crypto:1.0.0")
//    implementation("com.gyf.immersionbar:immersionbar:2.3.3-beta15")

    //网络
//    implementation("io.reactivex.rxjava3:rxjava:3.0.8")
//    implementation("io.reactivex.rxjava3:rxandroid:3.0.0")

    implementation("com.squareup.retrofit2:retrofit:2.9.0"){
        exclude("com.squareup.okhttp3",  "okhttp")
    }
    // OkHttp 核心库（必须与 SSE 版本一致）
//    implementation("com.squareup.okhttp3:okhttp:5.3.0")
    // OkHttp-SSE 库（5.3.0 版本）
    implementation("com.squareup.okhttp3:okhttp-sse:4.9.0")
    implementation("com.squareup.retrofit2:converter-gson:2.9.0")
//    implementation("com.squareup.retrofit2:adapter-rxjava3:2.9.0")
    implementation("com.squareup.retrofit2:converter-scalars:2.9.0")
    implementation("com.squareup.okhttp3:logging-interceptor:4.9.0")

}