package com.sd.cavphmi.viewmodels

import android.content.Context
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.viewModelScope
import com.google.gson.Gson
import com.minedata.minenavi.map.MineMap
import com.minedata.minenavi.mapdal.LatLng
import com.sd.cavphmi.base.MyBaseViewModel
import com.sd.cavphmi.bean.AvpStatuBean
import com.sd.cavphmi.bean.BindCarItem
import com.sd.cavphmi.bean.CarVehicle
import com.sd.cavphmi.bean.PerceptionBean
import com.sd.cavphmi.bean.SpaceInfoBean
import com.sd.cavphmi.bean.V2xStartBean
import com.sd.cavphmi.bean.VToXImgBean
import com.sd.cavphmi.bean.VehDetailBean
import com.sd.cavphmi.bean.VehicleStats
import com.sd.cavphmi.bean.mock.MRoutes
import com.sd.cavphmi.bean.mock.MyCLoc
import com.sd.cavphmi.highmap.AllLine
import com.sd.cavphmi.highmap.HighMapApi
import com.sd.cavphmi.highmap.LockStatu
import com.sd.cavphmi.highmap.ParkStatu
import com.sd.cavphmi.highmap.Spinfo
import com.sd.cavphmi.highmap.WarnPtc
import com.sd.cavphmi.net.MyResult
import com.sd.cavphmi.repositorys.AvpDataRepo
import com.sd.cavphmi.utils.FileIoUtils
import com.sd.cavphmi.utils.MyContants
import com.sd.cavphmi.utils.MyMapUtils
import com.sd.cavphmi.utils.ToastHelper
import com.sd.cavphmi.websockets.FeelTargetWSClient
import com.sd.cavphmi.websockets.V2xWSClient
import com.sd.cavphmi.websockets.VecLocWSClient
import dagger.hilt.android.lifecycle.HiltViewModel
import dagger.hilt.android.qualifiers.ApplicationContext
import kotlinx.coroutines.Job
import kotlinx.coroutines.delay
import kotlinx.coroutines.isActive
import kotlinx.coroutines.launch
import java.net.URI
import javax.inject.Inject
import kotlin.coroutines.cancellation.CancellationException
import kotlin.math.absoluteValue


@HiltViewModel
class MainVm @Inject constructor(
    @ApplicationContext private var context: Context,
    private var avpDataRepo: AvpDataRepo
) : MyBaseViewModel() {

//    private var client: MyWebSocketClient? = null

    private val TAG = "MainVm"

    var mMineMap: MineMap? = null

    //网联车辆位姿socket
    private var vecLocWSClient = VecLocWSClient(URI(MyContants.WS_VEH_LOC))

    //感知物socket
    private var feelTargetWSClient = FeelTargetWSClient(URI(MyContants.WS_FEEL_TARGET))

    //v2x预警socket
    private var v2xWSClient = V2xWSClient(URI(MyContants.WS_V2X))

    //网联车辆状态
//    private var vehStatuWSClient = VehStatuWSClient(URI(MyContants.WS_VEH_STATU))

    //socket 管理
    private var sockets = listOf(vecLocWSClient, feelTargetWSClient, v2xWSClient)

    //交通信号灯
//    private var trafficLightWSClient: TrafficLightWSClient? = null

    private var gson = Gson()

    //模拟操作
    lateinit var mockVM: MockVM

    //是否需要模拟
    var isMock = true

    //车辆位姿数据
    var carVehicle = MutableLiveData<CarVehicle>()

    //车辆详情
    var vehDetail = MutableLiveData<VehDetailBean>()

    //感知目标物
    var targetPre = MutableLiveData<PerceptionBean>()

    //v2x 预警
    var v2xStartBean = MutableLiveData<V2xStartBean>()

    //联网车辆状态数据
    var vehicleStat = MutableLiveData<VehicleStats>()

    //avp状态数据
    var avpStatu = MutableLiveData<AvpStatuBean>()

    //车位占用情况
    var spaceInfo = MutableLiveData<SpaceInfoBean>()

    //获取已绑定车辆列表
    var bindCars = MutableLiveData<List<BindCarItem>>()

//    fun startWS() {
//        val httpHeaders = mutableMapOf<String, String>()
//        httpHeaders.put("Cookie", "username=nemo")
//        try {
//            client = MyWebSocketClient(URI(MyContants.WS_HOST))
//            client?.onSocketCb = onSocketCb
//            client?.onDataCb = onDataCb
//            client?.connect()
//        } catch (e: Exception) {
//
//        }
//    }

    /***清理资源***/
    fun cleanRes() {
        sockets.forEach {
            it.close()
        }
    }


    //获取车辆详情 传{}就行，正常应该是传场地ID，但是亦庄这个和太和桥车是一样的,用于拿到车内视频
    fun getVehDetail(id: String = ""): LiveData<VehDetailBean> {
        viewModelScope.launch {
            var result = avpDataRepo.getVehDetail(id)
            when (result) {
                is MyResult.Success<VehDetailBean> -> {
                    vehDetail.postValue(result.data)
                }

                else -> {
                }
            }
        }
        return vehDetail
    }


    /* HTTP获取车位占用情况
     通过车位号传给四维高精地图*/
    fun getSpaceInfo(): LiveData<SpaceInfoBean> {
        viewModelScope.launch {
            var result = avpDataRepo.getSpaceInfo()
            when (result) {
                is MyResult.Success<SpaceInfoBean> -> {
                    var str = gson.toJson(result)
                    FileIoUtils.writeToFile(str, "space_info.txt")
                    spaceInfo.postValue(result.data)
                }

                else -> {
                }
            }
        }
        return spaceInfo
    }

    private var avpStatuJob: Job? = null

    //HTTP获取AVP状态
    fun getAvpStatus(): LiveData<AvpStatuBean> {
        avpStatuJob = viewModelScope.launch {
            while (isActive) {
                var result = avpDataRepo.getAvpStatus()
                when (result) {
                    is MyResult.Success<AvpStatuBean> -> {
                        var str = gson.toJson(result)
                        FileIoUtils.writeToFile(str, "avp_status.txt")
                        avpStatu.postValue(result.data)
                    }

                    else -> {
                    }
                }
                delay(2000)
            }
        }
        avpStatuJob?.invokeOnCompletion {

        }
        return avpStatu
    }

    //HTTP获取已绑定车辆列表
    fun getBindCar(): LiveData<List<BindCarItem>> {
        viewModelScope.launch {
            var result = avpDataRepo.getBindCar()
            when (result) {
                is MyResult.Success<List<BindCarItem>> -> {
                    var str = gson.toJson(result)
                    FileIoUtils.writeToFile(str, "bind_car.txt")
                    bindCars.postValue(result.data)
                }

                else -> {
                }
            }
        }
        return bindCars
    }


    /**
     * 联网车辆位姿数据
     * 传入vehicleId 和url拼接代表某辆车的预警
     * 用来控制主车移动
     */
    fun subVehicle(): LiveData<CarVehicle> {
        if (isMock) {
            mockVM.onVehicleMock(carVehicle)
        } else {
            try {
                vecLocWSClient.onDataCb = object : VecLocWSClient.OnDataCb {
                    override fun onMsg(str: String) {
                        viewModelScope.launch {
                            //下载到sd卡下面的DownLoad文件夹下面
//                            FileIoUtils.writeToFile(str, "CarVehicle.txt")
                            var carBean = gson.fromJson(str, CarVehicle::class.java)
                            //更新主车位置
                            carVehicle.postValue(carBean)
                        }
                    }
                }
                if (!vecLocWSClient.isOpen) {
                    vecLocWSClient.connect()
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
        return carVehicle
    }


    /**感知目标物数据
     *传入intersectionCode=17 拼接 代表获取某区域的感知物，目前没有数据
     */
    fun subTarget(): LiveData<PerceptionBean> {
        if (isMock) {
            mockVM.onSubTargetMock(targetPre)
        } else {
            try {
                feelTargetWSClient.onDataCb = object : FeelTargetWSClient.OnDataCb {
                    override fun onMsg(str: String) {
                        viewModelScope.launch {
//                            FileIoUtils.writeToFile(str, "PerTarget.txt")
                            var bean = gson.fromJson(str, PerceptionBean::class.java)
                            targetPre.postValue(bean)
                        }
                    }
                }
                if (!feelTargetWSClient.isOpen) {
                    feelTargetWSClient.connect()
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
        return targetPre
    }

    /**
     * V2X预警开始
     * 传入vehicleId 和url拼接代表某辆车的预警
     * 某个预警id要和感知物的ptcid对上
     */
    fun subStartV2x(): LiveData<V2xStartBean> {
        if (isMock) {
            mockVM.onV2xMock(v2xStartBean)
        } else {
            try {
                v2xWSClient.onDataCb = object : V2xWSClient.OnDataCb {
                    override fun onMsg(str: String) {
                        viewModelScope.launch {
//                            FileIoUtils.writeToFile(str, "onStartV2x.txt")
                            var bean = gson.fromJson(str, V2xStartBean::class.java)
                            v2xStartBean.postValue(bean)
                        }
                    }
                }
                if (v2xWSClient.isOpen == false) {
                    v2xWSClient.connect()
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
        return v2xStartBean
    }

    //开启预警特效
    fun startWarning(ptcId: String) {
        viewModelScope.launch {
            var warnPtc = WarnPtc().apply {
                ptcid = ptcId
                isRed = true
            }
            var warns = listOf(warnPtc)
            HighMapApi.setWarnPtc(warns)
            delay(5000)
            warnPtc.isRed = false
            HighMapApi.setWarnPtc(warns)
        }
        toggleCircleRadar(2)
    }

    /**开启预警（光圈和雷达）
     * @param dirent  0=关闭  1=左前 2=正前 3=右前   4=右后  5=正后  6=左后
     * */
    fun toggleCircleRadar(dirent: Int) {
        HighMapApi.setCarBottomCircle(true)
        HighMapApi.setCarRadarDirection(dirent)
        viewModelScope.launch {
            delay(MyContants.WARNINGTIME)
            HighMapApi.setCarBottomCircle(false)
            HighMapApi.setCarRadarDirection(0)
        }
    }


// 模拟---------------
// 模拟---------------------------
// 模拟-----------

    //模拟在仿真路上跑
    fun mockFzLine() {
        viewModelScope.launch {
            try {
                var gson = Gson()
                var str =
                    FileIoUtils.getAsset(context, "mock/Car_fangzhen.txt")   //Qgis里取的点和四维取得点混合
                val carVehicle = gson.fromJson<MRoutes>(str, MRoutes::class.java)
                //画出全局路径
                var lines = carVehicle.rs.map {
                    AllLine(it[1], it[0])
                }
                HighMapApi.setCarNavPath(lines, showdistance = 200)
                //开启流光效果
                HighMapApi.parkRoundLight("B021")
                //2旁车辆占用
                var spinfos = listOf(Spinfo().apply {
                    code = "B020"
                    state = true
                }, Spinfo().apply {
                    code = "B022"
                    state = true
                })
                HighMapApi.setParkStatu(ParkStatu(spinfos))
                //模拟车辆移动
                var head = 0.0
                var oldHead = 0.0
                var bearing = 0f
                carVehicle.rs.forEachIndexed { index, it ->
                    if (index > 0 && index < carVehicle.rs.count()) {
                        var p1 = carVehicle.rs.get(index - 1)
                        var pc = carVehicle.rs.get(index)
                        head = MyMapUtils.calculateBearing(
                            LatLng(p1[1], p1[0]),
                            LatLng(pc[1], pc[0])
                        )
                    }
                    var myloc = MyCLoc.instance.apply {
                        lat = it[1]
                        lng = it[0]
                        if ((head - oldHead).absoluteValue < 45) {
                            this.bearing = head.toFloat()
                        }
                        //   println("-----bearing = ${bearing}")
                        //高程
                        altitude = 20.802828
                    }
                    oldHead = head
                    HighMapApi.setCarPosition(
                        myloc.bearing.toDouble(),
                        myloc.lat,
                        myloc.lng,
                        myloc.altitude,
                    )
                    delay(300)
                }
                //地锁绘制
                var lockStatu = LockStatu().apply {
                    code = "B021"
                    up = false
                }
                HighMapApi.setLockStatus(lockStatu)
                delay(5000)
                lockStatu.isHide = true
                HighMapApi.setLockStatus(lockStatu)
                //消除全局路径
                HighMapApi.setCarNavPath(listOf())
            } catch (e: CancellationException) {

            }
        }
    }

    //预警车
    fun mWarnCar() {
        //气泡消息
        v2xStartBean.value = V2xStartBean().apply { type = 1 }
        startWarning("f117fdfa-feff-0100-85dc-35850000acb0")
    }

    //预警人
    fun mWarnPeo() {
        //气泡消息
        v2xStartBean.value = V2xStartBean().apply { type = 12 }
        startWarning("50332456-3030-3030-3530-303334533955")
    }

    /**
     * 网联车辆状态
     **/
    /*   fun subVehicleStatus(): LiveData<VehicleStats> {
           if (isMock) {

           } else {
               try {
                   vehStatuWSClient.onDataCb = object : VehStatuWSClient.OnDataCb {
                       override fun onMsg(str: String) {
                           viewModelScope.launch {
                               FileIoUtils.writeToFile(str, "vehicleS.txt")
                               var bean = gson.fromJson(str, VehicleStats::class.java)
                               vehicleStat.postValue(bean)
                           }
                       }
                   }
                   if (vehStatuWSClient.isOpen == false) {
                       vehStatuWSClient.connect()
                   } else {
                       vehStatuWSClient.reconnect()
                   }
               } catch (e: Exception) {
                   e.printStackTrace()
               }
           }
           return vehicleStat
       }*/


//暂时用不到---------------------------------------------


    /*** 交通（感知）事件**//*
    fun subTrafficPre(): LiveData<TrafficPerBean> {
        try {
            if (trafficPreWSClient == null) {
                trafficPreWSClient = TrafficPreWSClient(URI(MyContants.WS_TRAFFIC_PER))
                trafficPreWSClient?.connect()

                trafficPreWSClient?.onDataCb = object : TrafficPreWSClient.OnDataCb {
                    override fun onMsg(str: String) {
                        viewModelScope.launch {
                            FileIoUtils.writeToFile(str, "pre_traff.txt")
                            var bean = gson.fromJson(str, TrafficPerBean::class.java)
                            trafficPerBean.postValue(bean)
                        }
                    }
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return trafficPerBean
    }


    */
    /*** 交通信号灯**//*
    fun subTrafficLight(): LiveData<TrafficLightBean> {
        try {
            if (trafficLightWSClient == null) {
                trafficLightWSClient = TrafficLightWSClient(URI(MyContants.WS_TRAFFIC_LIGHT))
                trafficLightWSClient?.connect()

                trafficLightWSClient?.onDataCb = object : TrafficLightWSClient.OnDataCb {
                    override fun onMsg(str: String) {
                        viewModelScope.launch {
                            FileIoUtils.writeToFile(str, "traff_light.txt")
                            var bean = gson.fromJson(str, TrafficLightBean::class.java)
                            trafficLightBean.postValue(bean)
                        }
                    }
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return trafficLightBean
    }*/


//显示气泡
    fun showVToTip() {
        var imgs = VToXImgBean.imgs
        ToastHelper.showCustViewShort(context, imgs.get("2")!!)
    }


}