package com.sd.cavphmi.viewmodels

import androidx.lifecycle.viewModelScope
import com.sd.cavphmi.base.MyBaseViewModel
import com.sd.cavphmi.bean.CarPanelBean
import com.sd.cavphmi.bean.CarVehicle
import com.sd.cavphmi.bean.GearStatus
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import javax.inject.Inject
import kotlin.random.Random

@HiltViewModel
class CarPanelVM @Inject constructor() : MyBaseViewModel() {

    //车辆仪表单例
    var carPanelBean = CarPanelBean.instance


    /**展示车辆仪表*****/
    fun setCarPanelBean(carVehicle: CarVehicle) {
//        val vehicleInfo = event.vehicleInfo
        if (carVehicle.count() == 0)
            return
//        val vehicleStatusInfo = event.vehicleStatusInfo
        var bean = carVehicle.first()
        //速度
        carPanelBean.speed.set(bean.speed.toInt())
//        //航向角
        carPanelBean.heading.set(bean.heading.toInt())
        //档位
//        carPanelBean.tapPos.set(vehicleInfo.tapPos.toInt())
        //驾驶模式
//        carPanelBean.driveMode.set(vehicleInfo.driveMode.toInt())
        //剩余电量
        carPanelBean.remainSoc.set(bean.soc.toInt())
        //车灯状态
//        carPanelBean.lights.set(vehicleStatusInfo?.lights)
//        var a = 0
    }

    /**设置档位类型*****/
    fun setGearType(gearType: String) {
        when (gearType) {
            "PARK" -> {
                carPanelBean.tapPos.set(GearStatus.P)
            }
            "REVERSE" -> {
                carPanelBean.tapPos.set(GearStatus.R)
            }
            "NEUTRAL" -> {
                carPanelBean.tapPos.set(GearStatus.N)
            }
            "DRIVE" -> {
                carPanelBean.tapPos.set(GearStatus.D)
            }
        }

    }



    fun mock() {
        changeMockHeading()
        changeMockDriveMode()
        changeMockLight()
        changeMockPro()
        changeMockGear()
        changeMockSpeed()
    }


    private fun changeMockHeading() {
        viewModelScope.launch {
            var list = mutableListOf<Float>()
            var ramdom = Random(360)
            for (i in 1..360) {
                list.add(ramdom.nextInt(360).toFloat())
            }
            list.forEach {
                withContext(Dispatchers.IO) {
                    delay(1100)
                }
//                carPanelBean.heading.set(it)
            }
        }
    }

    //模拟驾驶模式
    private fun changeMockDriveMode() {
        viewModelScope.launch {
            for (i in 1..100) {
                for (j in 1..9) {
                    withContext(Dispatchers.IO) {
                        delay(1500)
                    }
//                    carPanelBean.driveMode.set(j)
                }
            }
        }
    }

    //模拟车灯
    private fun changeMockLight() {
        var list = listOf(4, 8, 0)
        viewModelScope.launch {
            for (i in 1..100) {
                withContext(Dispatchers.IO) {
                    delay(2000)
                }
                var p = i % 3
//                carPanelBean.lights.set(list[p])
            }
        }
    }

    //模拟电量
    private fun changeMockPro() {
        viewModelScope.launch {
            for (i in 1..1000) {
                withContext(Dispatchers.IO) {
                    delay(300)
                }
                var p = i % 100
                carPanelBean.remainSoc.set(p)
            }
        }
    }

    //模拟档位
    private fun changeMockGear() {
        var list = listOf(31, 32, 33, 34)
        viewModelScope.launch {
            for (i in 1..100) {
                withContext(Dispatchers.IO) {
                    delay(1000)
                }
                var p = i % 4
                carPanelBean.tapPos.set(list.get(p))
            }
        }
    }

    //模拟速度和限速
    private fun changeMockSpeed() {
//        carPanelBean.spdExp.set(10)
        viewModelScope.launch {
            for (i in 1..100) {
                for (j in 1..100) {
                    withContext(Dispatchers.IO) {
                        delay(200)
                    }
                    carPanelBean.speed.set(j)
                }
            }
        }
    }
}