package com.sd.cavphmi.utils


import android.content.Context
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.widget.ImageView
import android.widget.Toast
import androidx.annotation.DrawableRes
import com.sd.cavphmi.R


/**
 *author：pc-20171125
 *data:2019/11/8 11:18
 */
object ToastHelper {

    /**
     * 短时间显示Toast
     */
    fun showShort(context: Context, message: String) {
        Toast.makeText(context, message, Toast.LENGTH_SHORT).run {
            show()
        }
    }

    fun showCustViewShort(context: Context, @DrawableRes resId: Int) {
        val customToastRoot =
            LayoutInflater.from(context).inflate(R.layout.toast_tip, null)
        // 获取布局中的视图元素
        val imageView = customToastRoot.findViewById<ImageView>(R.id.img_tip)
        imageView.setImageResource(resId)
        val toast = Toast(context)
        toast.view = customToastRoot
        toast.duration=Toast.LENGTH_SHORT
//        toast.setGravity(Gravity.TOP,0,0)
        toast.show()
    }
//    /**
//     * 短时间显示Toast
//     */
//    fun showShort(context: Context, message: String) {
//        Toast.makeText(context, message, Toast.LENGTH_SHORT).run {
//            setGravity(Gravity.CENTER, 0, 0)
//            show()
//        }
//    }


//    /**
//     * 短时间显示Toast
//     *
//     * @param message
//     */
//    fun showShort(message: Int) {
//        if (isShow)
//            Toast.makeText(BaseApp.context, message, Toast.LENGTH_SHORT).show()
//    }

//    /**
//     * 长时间显示Toast
//     *
//     * @param message
//     */
//    fun showLong(message: CharSequence) {
//        if (isShow)
//            Toast.makeText(BaseApp.context, message, Toast.LENGTH_LONG).show()
//    }


}
