package com.sd.cavphmi.ui

import android.content.Intent
import android.os.Bundle
import android.widget.Toast
import androidx.activity.viewModels
import androidx.appcompat.app.AppCompatActivity
import com.sd.cavphmi.databinding.ActivityLoginBinding
import com.sd.cavphmi.ui.view.CustomListDialog
import com.sd.cavphmi.utils.SM4CryptoHelper
import com.sd.cavphmi.viewmodels.LoginVm
import com.sd.cavphmi.viewmodels.MainVm
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class LoginActivity : AppCompatActivity() {

    private lateinit var binding: ActivityLoginBinding

    private val loginVm: LoginVm by viewModels()
    private val mainVm: MainVm by viewModels()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityLoginBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.btLogin.setOnClickListener {
            var user = binding.etAccount.text.toString()
            var pwd = binding.etPwd.text.toString()
//            "4CIHV37pDF8sx0ZXYmYah6HSgys7F7ULSMmm39uzppc"
            var key = "Cusc@itmp-sm4key".toByteArray()
            var pp = SM4CryptoHelper.encryptECB(key, pwd.toByteArray())

            loginVm.login(user, pp, 276135).observe(this) {
//                startActivity(Intent(this,MainActivity::class.java))
            }
        }

        //  HTTP获取车辆详情
        binding.btVehinfo.setOnClickListener {
            mainVm.getVehDetail()
        }
        //  HTTP获取车位占用情况
        binding.btSpaceinfo.setOnClickListener {
            mainVm.getSpaceInfo()
        }
        //  HTTP获取AVp状态信息 以后就用socket订阅了,获取找、泊车状态，拿到全局路径lines,和局部（避障）路径xxx
        binding.btAvpstatu.setOnClickListener {
            mainVm.getAvpStatus()
        }
        binding.btGetbindcar.setOnClickListener {
            getBinderCars()
        }
        //直接到首页
        binding.btMain.setOnClickListener {
            startActivity(Intent(this, MainActivity::class.java))
        }

    }

    private fun getBinderCars() {
        mainVm.getBindCar().observe(this) {

        }
        var list = listOf("skywell.1ggvlp16.car10", "skywell.1ggvlp16.car8")
        val dialog = CustomListDialog(this, "选择车辆", list)
        dialog.setOnItemClickListener(object : CustomListDialog.OnItemClickListener {
            override fun onItemClick(position: Int, selectedItem: String) {
                Toast.makeText(this@LoginActivity, "点击了第${position + 1}项: $selectedItem", Toast.LENGTH_SHORT).show()
            }
        })
        dialog.show()
    }


}