plugins {
    alias(libs.plugins.android.application)
    alias(libs.plugins.kotlin.android)
    id("dagger.hilt.android.plugin")
    id("kotlin-kapt")
//    id("com.google.protobuf")
//    alias(libs.plugins.proto.google)
}

android {
    namespace = "com.sd.cavphmi"
    compileSdk = 35

    defaultConfig {
        applicationId = "com.sd.cavphmi"
        minSdk = 29
        targetSdk = 35
        versionCode = 1
        versionName = "1.0"

        ndk {
//            abiFilters.addAll(listOf("x86_64", "arm64-v8a"))
            abiFilters.addAll(listOf("arm64-v8a"))
        }

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
    }

    buildTypes {
        release {
            isMinifyEnabled = false
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }
    kotlinOptions {
        jvmTarget = "11"
    }
    buildFeatures {
        dataBinding = true
        viewBinding = true
    }
    lint {
        abortOnError = false
        checkReleaseBuilds = false
    }
}


dependencies {
    implementation(fileTree(mapOf("dir" to "libs", "include" to listOf("*.jar", "*.aar"))))
    implementation(libs.androidx.core.ktx)
    implementation(libs.androidx.appcompat)
    implementation(libs.material)
    implementation(libs.androidx.activity)
    implementation(libs.androidx.constraintlayout)
    implementation(libs.androidx.navigation.fragment.ktx)
    implementation(libs.androidx.navigation.ui.ktx)
    testImplementation(libs.junit)
    androidTestImplementation(libs.androidx.junit)
    androidTestImplementation(libs.androidx.espresso.core)

    //sm4 加密
    implementation("org.bouncycastle:bcprov-jdk15on:1.70")

    implementation("com.google.protobuf:protobuf-java:4.31.1")
//    implementation("com.google.protobuf:protobuf-javalite:4.31.1")
//    implementation("com.google.protobuf:protoc:3.0.0")
//    implementation("com.google.protobuf:protobuf-kotlin-lite:4.31.1")

    //播放器
    implementation("androidx.media3:media3-exoplayer:1.8.0")
    implementation("androidx.media3:media3-exoplayer-dash:1.8.0")
    implementation("androidx.media3:media3-ui:1.8.0")
    implementation("androidx.media3:media3-ui-compose:1.8.0")

    //java web socket
    implementation("org.java-websocket:Java-WebSocket:1.6.0")
    //proto
    // Hilt dependencies
    val hilt_version = "2.56.1"
    implementation("com.google.dagger:hilt-android:$hilt_version")
    kapt("com.google.dagger:hilt-android-compiler:${hilt_version}")
    // ViewModel
    implementation("androidx.lifecycle:lifecycle-viewmodel-ktx:2.6.2")
    //fragment-ktx
    implementation("androidx.fragment:fragment-ktx:1.8.0")
    // 权限请求框架
    implementation("com.guolindev.permissionx:permissionx:1.8.1")
    //加密库
//    implementation("androidx.security:security-crypto:1.0.0")
//    implementation("com.gyf.immersionbar:immersionbar:2.3.3-beta15")

    //四维依赖
//    implementation("com.jakewharton.timber:timber:4.5.1")
//    implementation("com.mapzen.android:lost:2.1.2")

    //网络
//    implementation("io.reactivex.rxjava3:rxjava:3.0.8")
//    implementation("io.reactivex.rxjava3:rxandroid:3.0.0")

    implementation("com.squareup.retrofit2:retrofit:2.9.0")
    implementation("com.squareup.retrofit2:converter-gson:2.9.0")
//    implementation("com.squareup.retrofit2:adapter-rxjava3:2.9.0")
    implementation("com.squareup.retrofit2:converter-scalars:2.9.0")
    implementation("com.squareup.okhttp3:logging-interceptor:4.9.0")
}