package com.sd.cavphmi.viewmodels

import android.content.Context
import androidx.databinding.ObservableField
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.google.gson.Gson
import com.sd.cavphmi.bean.CarPanelBean
import com.sd.cavphmi.bean.CarVehicle
import com.sd.cavphmi.bean.CarVehicleItem
import com.sd.cavphmi.bean.PerTarget
import com.sd.cavphmi.bean.PerTargetTest
import com.sd.cavphmi.bean.V2xStartBean
import com.sd.cavphmi.utils.FileIoUtils
import dagger.hilt.android.lifecycle.HiltViewModel
import dagger.hilt.android.qualifiers.ApplicationContext
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import javax.inject.Inject

@HiltViewModel
class MockVM @Inject constructor(
    @ApplicationContext private var context: Context,
) : ViewModel() {

    private var gson = Gson()

    /**解析网络数据***/
    suspend fun <T> parseDataBean(str: String, clazz: Class<T>): T {
        return withContext(Dispatchers.Default) {
            gson.fromJson(str, clazz)
        }
    }

    /******
     * 模拟车辆位姿
     * @param binding 里的航向角
     * @param binding 里的速度
     * **/
    fun onVehicleMock(
        carVehicle: MutableLiveData<CarVehicle>
    ) {
        viewModelScope.launch {
            val dst = mutableListOf<String>()
            FileIoUtils.getAssetMock(context, "mock/CarVehicle.txt", dst)
            dst.forEach { str ->
                delay(1000)
                val bean = parseDataBean(str, CarVehicle::class.java)
                println("------模拟车辆位姿数据 = ${bean}")
                println("------车速 = ${bean.first().speed}")
                println("------电量 = ${bean.first().soc}")
                carVehicle.value = bean
            }
        }
    }


    //感知目标物
    fun onSubTargetMock(targetPre: MutableLiveData<PerTargetTest>) {
        viewModelScope.launch {
            val parts = mutableListOf<String>()
            FileIoUtils.getAssetMock(context, "mock/PerTarget.txt", parts)
            parts.forEach { str ->
                delay(1000)
                var bean = parseDataBean(str, PerTargetTest::class.java)
//                println("------模拟感知目标物数据 = ${bean}")
//                println("------模拟感知目标物typeName = ${bean.typeName}")
//                println("------模拟感知目标物type = ${bean.type}")
//                println("------模拟感知目标物level = ${bean.type}")
                targetPre.value = bean
            }
        }
    }

    //v2预警
    fun onV2xMock(targetPre: MutableLiveData<V2xStartBean>) {
        viewModelScope.launch {
            val parts = mutableListOf<String>()
            FileIoUtils.getAssetMock(context, "mock/onStartV2x.txt", parts)
            parts.forEach { str ->
                delay(1000)
                var bean = parseDataBean(str, V2xStartBean::class.java)
                println("------模拟感知目标物数据 = ${bean}")
                println("------模拟感知目标物typeName = ${bean.typeName}")
                println("------模拟感知目标物type = ${bean.type}")
                println("------模拟感知目标物level = ${bean.type}")
                targetPre.value = bean
            }
        }
    }

    //全局路径发生切换
    fun onSubLinePlaningMock() {
//        viewModelScope.launch {
//            val alls = mutableListOf<String>()
//            FileIoUtils.getAssetMock(context, "mock/all_line.txt", alls)
//            alls.forEach { str ->
//                delay(1000)
//                var bean = parseSocketRepo.parseDataBean(str, AllLinePlaningBean::class.java)
//                allLine.value = bean
//            }
//        }
    }

    //模拟Http获取全局路径
    /*  suspend fun getLinePlaningMock(vehiclePlate: String): MyResult<ParkLinePlan> {
          return withContext(Dispatchers.IO) {
              val str = FileIoUtils.getAssetContent(context, "find_line.txt")
              val bean =gson.fromJson(str,ParkLinePlan::class.java)
              return@withContext MyResult.Success(bean)
          }
      }*/

    //局部路径
    fun onSubPartLineMock() {
//        viewModelScope.launch {
//            val lines = mutableListOf<String>()
//            lines.forEach { str ->
//                delay(1000)
//                var bean = parseSocketRepo.parseDataBean(str, PartLineBean::class.java)
//                allLine.value = bean
//            }
//        }
    }

    //更新停车位
    fun onPointsMock() {
//        viewModelScope.launch {
//            val points = mutableListOf<String>()
//            FileIoUtils.getAssetMock(context, "mock/change_park.txt", points)
//            points.forEach { str ->
//                delay(1000)
//                var bean = parseSocketRepo.parseDataBean(str, ParkBean::class.java)
//                println("------模拟停车位变更 = ${bean}")
//                parkBean.value = bean
//            }
//        }
    }


}