package com.sd.cavphmi.ui.fragment

import android.graphics.Color
import android.os.Handler
import android.os.Looper
import android.util.Log
import androidx.activity.viewModels
import androidx.fragment.app.activityViewModels
import androidx.fragment.app.viewModels
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.lifecycleScope
import com.sd.cavphmi.BR
import com.sd.cavphmi.R
import com.sd.cavphmi.base.BaseFragment
import com.sd.cavphmi.base.MyBaseViewModel
import com.sd.cavphmi.bean.CarVehicle
import com.sd.cavphmi.bean.CarVehicleItem
import com.sd.cavphmi.bean.V2xStartBean
import com.sd.cavphmi.bean.WarningBean
import com.sd.cavphmi.databinding.FragmentCarPanelBinding
import com.sd.cavphmi.databinding.FragmentWarnBinding
import com.sd.cavphmi.viewmodels.MainVm
import com.sd.cavphmi.viewmodels.MockVM
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch


// the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
//private const val ARG_PARAM1 = "param1"
//private const val ARG_PARAM2 = "param2"

/**
 * 预警气泡
 */
@AndroidEntryPoint
class WarnFragment : BaseFragment<FragmentWarnBinding, MyBaseViewModel>() {
//
//    private var param1: String? = null
//    private var param2: String? = null
//
//    override fun onCreate(savedInstanceState: Bundle?) {
//        super.onCreate(savedInstanceState)
//        arguments?.let {
//            param1 = it.getString(ARG_PARAM1)
//            param2 = it.getString(ARG_PARAM2)
//        }
//    }

    private val mainVm: MainVm by activityViewModels()


    override fun getStatuBarColor(): Int {
        return -1
    }

    override fun isAutoStatusBarDarkModeEnable(): Boolean {
        return false
    }


    override fun initContentView(): Int {
        return R.layout.fragment_warn
    }

    override fun initViewModel(): MyBaseViewModel {
        return ViewModelProvider(this).get(MyBaseViewModel::class.java)
    }

    override fun initVariableId(): Int {
        return BR.vm
    }

    override fun initView() {

    }

    override fun initListener() {
        mainVm.v2xStartBean.observe(this) {
            Log.e("V2x", "-------------typeName--" + it.typeName)
            showEarlyDetail(it)
            binding.roadWarn.setWarnBean(WarningBean.instance)
        }
    }

    private fun showEarlyDetail(v2xStartBean: V2xStartBean) {
        var warningBean = WarningBean.instance
        warningBean.img = R.drawable.chao_su
        when (v2xStartBean.type) {
            1 -> {//前向碰撞
                warningBean.img = R.drawable.zhuyi_car
                warningBean.tipStr = "注意前方车辆"
            }

            4 -> {//盲区预警
                warningBean.tipStr = "左侧/右侧盲区有车辆，请注意！"
            }

            3 -> {//左转辅助
                warningBean.tipStr = "注意对向来车"
            }

            12 -> {//弱势交通参与者
                warningBean.img = R.drawable.zhuyi_xingren
                warningBean.tipStr = "注意行人"
            }

            6 -> {//紧急制动预警
                warningBean.tipStr = "前方车辆紧急制动，请减速！"
            }
        }
    }


    companion object {
        @JvmStatic
        fun newInstance() = WarnFragment()
    }
}