package com.sd.cavphmi.highmap

import com.google.gson.Gson
import com.unity3d.player.UnityPlayer


/**
 * 高精地图Api
 *
 * 在EarlyWarnVM.kt里setAssEvent函数里用到了
 */
object HighMapApi {

    private var gson = Gson()

    private const val MODELNAME = "MsgBridge"

    /**
     * 给unity读取3d tile json配置
     */
    fun setTileInit(tileJsonBean: TileJsonBean) {
        UnityPlayer.UnitySendMessage(MODELNAME, "SetTileInit", gson.toJson(tileJsonBean))
    }

    /**
     * 根据外界传入的坐标，航向角，速度使主车移动
     * @param heading 航向角
     * @param evel 高程
     */
    fun setCarPosition(
        heading: Double,
        lat: Double,
        lon: Double,
        evel: Double,
    ) {
        val carPos = CarPos().apply {
            this.heading = heading
            this.lat = lat
            this.lon = lon
            this.evel = evel
        }
        UnityPlayer.UnitySendMessage(MODELNAME, "SetCarPosition", gson.toJson(carPos))
    }

    /**
     * 开启（关闭）绘制主车底盘下的光圈
     */
    fun setCarBottomCircle(ison: Boolean) {
        var bottomCircle = BottomCircle(ison)
        UnityPlayer.UnitySendMessage(MODELNAME, "SetCarBottomCircle", gson.toJson(bottomCircle))
    }

    /**
     * 开启（关闭）主车前方的雷达6个方向
     */
    fun setCarRadarDirection(dirent: Int) {
        var radarDirection = RadarDirection(dirent)
        UnityPlayer.UnitySendMessage(MODELNAME, "SetCarRadarDirection", gson.toJson(radarDirection))
    }

    /**
     * 车辆行驶全局路径绘制  - 蓝色渐变引导线
     * @param lines 全局路径
     */
    fun setCarNavPath(lines: List<AllLine>) {
        var carNavPath = CarNavPath(lines)
        UnityPlayer.UnitySendMessage(MODELNAME, "SetCarNavPath", gson.toJson(carNavPath))
    }

    /**
     * 传入点的坐标数组绘制路面状况颜色2=(路径里的红色、施工区域红色、人行道红色) 3=绿色（绿波） 4=感知车前的红色）
     * @param alertLins 危险路径
     * @param alertType 危险类型
     */
    fun setAlertPath(alertLins: List<AlertLin>, alertType: Int) {
        var alertPath = AlertPath(alertLins, alertType)
        UnityPlayer.UnitySendMessage(MODELNAME, "SetAlertPath", gson.toJson(alertPath))
    }

    /**
     * 绘制感知物
     * @param ptcList
     */
    fun setPtcData(ptcList: List<UnityPtc>) {
        var ptcData = PtcData(ptcList)
        UnityPlayer.UnitySendMessage(MODELNAME, "SetPtcData", gson.toJson(ptcData))
    }


    /**
     * 设置相机角度
     */
    fun setSetCameraAngle(angle: Float = 30f) {
        UnityPlayer.UnitySendMessage(MODELNAME, "SetCameraAngle", "$angle")
    }


    /**
     * 清除所有感知物
     */
    fun clearPtcData() {
        UnityPlayer.UnitySendMessage(MODELNAME, "ClearAllPtcData", "{}")
    }

}