package com.sd.cavphmi.base

import android.os.Bundle
import android.view.MenuItem
import android.view.View
import androidx.annotation.DrawableRes
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.ContextCompat
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.sd.cavphmi.R

import com.sd.cavphmi.databinding.ActivityBaseBinding
import com.sd.cavphmi.net.NetLoadStatus
import com.sd.cavphmi.utils.ToastHelper

//import com.gyf.immersionbar.ImmersionBar

abstract class BaseActivity<Bind : ViewDataBinding, VM : MyBaseViewModel> : AppCompatActivity(),
    IBinding<VM> {

    protected lateinit var viewModel: VM

    protected lateinit var binding: Bind

    private lateinit var baseBind: ActivityBaseBinding

    //    private val loadDialogFragment by lazy { LoadDialogFragment.newInstance() }
//    private var loadDialogFragment: LoadDialogFragment? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        initDataBinding()

        baseBind =
            DataBindingUtil.setContentView(this, R.layout.activity_base)
        setContentView(baseBind.root)
        setSupportActionBar(baseBind.toolbar)
        baseBind.toolbar.visibility = View.GONE
        supportActionBar?.run {
            setDisplayShowTitleEnabled(false)
            setDisplayHomeAsUpEnabled(true)
//           setHomeAsUpIndicator()
        }
        baseBind.rootLayout.addView(binding.root)

        baseBind.toolbarTitle.text = title.toString()

//        viewModel.owner=this
        initView()
        initStatuBar()
        setListener()

//        requestedOrientation = ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE
        initListener()
        getToData()
    }

//    private lateinit var bar: ImmersionBar

    /**
     * 初始化状态栏
     */
    private fun initStatuBar() {
//        var color = getStatuBarColor()
//        if (color == -1) {
//
//        } else {
//            bar = ImmersionBar.with(this)
//                .fitsSystemWindows(true)
//                .statusBarColor(color)
//                .autoStatusBarDarkModeEnable(isAutoStatusBarDarkModeEnable())
//            bar.init()
//        }
    }

    abstract fun getStatuBarColor(): Int

    open fun isAutoStatusBarDarkModeEnable(): Boolean {
        return true
    }

    private fun initDataBinding() {
        binding = DataBindingUtil.setContentView(this, initContentView())

        viewModel = initViewModel()
        if (viewModel == null) {
            viewModel = ViewModelProvider(this).get(MyBaseViewModel::class.java) as VM
        }
        binding.setVariable(initVariableId(), viewModel)
    }

    private fun setListener() {
        viewModel.loadStatu.observe(this, Observer { t: NetLoadStatus ->
            when (t) {
                NetLoadStatus.LOADING -> loading()
                NetLoadStatus.SUCCESS -> success()
                NetLoadStatus.ERROR -> onError(t.getErrorMsg())
                NetLoadStatus.TOAST -> onToast(t.getToastMsg())
                NetLoadStatus.COMPLETE -> complete()
                NetLoadStatus.EMPTY -> empty()
                NetLoadStatus.NOMOREDATA -> noMoreData()
                NetLoadStatus.LOGINTIMEOUT -> loginTimeOut()
            }
        })
    }

    fun setTootBarTitle(title: String) {
        baseBind.toolbarTitle.text = title
    }

    fun setTootBarTitleColor(color: Int) {
        baseBind.toolbarTitle.setTextColor(ContextCompat.getColor(this, color))
    }

    /**
     * 设置头的颜色
     */
    fun setToorbarColor(toolbar: Int) {
        baseBind.toolbar.setBackgroundResource(toolbar)
    }

    /**
     *设置返回箭头
     */
    fun setBackImg(@DrawableRes resId: Int) {
        supportActionBar?.setHomeAsUpIndicator(resId)
    }

    abstract fun initView()

    open fun initListener() {

    }

    open fun getToData() {

    }

    open fun loading() {
//        loadDialogFragment = LoadDialogFragment.newInstance()
//        loadDialogFragment?.show(supportFragmentManager, "")
    }

    open fun success() {
//        loadDialogFragment?.dismiss()
    }

    open fun complete() {
//        loadDialogFragment?.dismiss()
    }

    open fun onError(msg: String) {
//        loadDialogFragment?.dismiss()
        ToastHelper.showShort(this, msg)
    }

    open fun onToast(msg: String) {
        ToastHelper.showShort(this, msg)
    }


    open fun empty() {
    }

    open fun noMoreData() {
    }

    open fun loginTimeOut() {
//        println("-------------BaseActivity.loginTimeOut")
        ToastHelper.showShort(this, "登录超时")
//        startActivity(Intent(this, LoginActivity::class.java).apply {
//            putExtra(MyContants.IS_LOGIN_TIMEOUT, true)
//        })
    }


    protected fun hideToolBar() {
        baseBind.toolbar.visibility = View.GONE
    }


    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
            android.R.id.home -> {
                finish()
                return true
            }

            else -> {
                return onClickOptions(item)
            }
        }
        return super.onOptionsItemSelected(item)
    }

    open fun onClickOptions(item: MenuItem): Boolean {
        return super.onOptionsItemSelected(item)
    }


//    fun jumpActivity(cls: Class<Activity>,parameMap:Map<String,String>) {
//        var intent = Intent(this, cls)
//        for ((k,v) in parameMap){
//            intent.putExtra(k,v)
//        }
//    }

}