package com.sd.cavphmi.websockets


import org.java_websocket.client.WebSocketClient
import org.java_websocket.drafts.Draft
import org.java_websocket.handshake.ServerHandshake
import java.net.URI
import java.nio.ByteBuffer

/*****网联车辆位姿**/
class VecLocWSClient : WebSocketClient {

    private val TAG = "-----VecLocWSClient"

    constructor(serverUri: URI) : super(serverUri)

    constructor(serverUri: URI?, protocolDraft: Draft?) : super(serverUri, protocolDraft)

    constructor(serverUri: URI?, httpHeaders: MutableMap<String, String>?) : super(
        serverUri,
        httpHeaders
    )

    override fun onOpen(handshakedata: ServerHandshake?) {
        send("Hello, it is me. Mario :)")
        System.out.println(TAG + "new connection opened")
    }

    override fun onMessage(message: String?) {
//        System.out.println(TAG + " : " + message)
        if (message.isNullOrEmpty())
            return
        onDataCb?.onMsg(message)
//        onSocketCb?.onMessage(message)

    }

    override fun onMessage(bytes: ByteBuffer?) {
//        System.out.println(TAG + "  received ByteBuffer")

    }

    override fun onClose(code: Int, reason: String?, remote: Boolean) {
//        System.out.println(TAG + "  closed with exit code " + code + " additional info: " + reason);

    }

    override fun onError(ex: Exception?) {
//        System.err.println(TAG + "an error occurred:" + ex)

    }

    var onDataCb: OnDataCb? = null

    interface OnDataCb {
        fun onMsg(str: String)
    }


}