package com.sd.cavphmi.ui.fragment

import androidx.fragment.app.activityViewModels
import androidx.lifecycle.ViewModelProvider
import com.sd.cavphmi.BR
import com.sd.cavphmi.R
import com.sd.cavphmi.base.BaseFragment
import com.sd.cavphmi.databinding.FragmentCarPanelBinding
import com.sd.cavphmi.viewmodels.CarPanelVM
import com.sd.cavphmi.viewmodels.MainVm
import dagger.hilt.android.AndroidEntryPoint


// the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
//private const val ARG_PARAM1 = "param1"
//private const val ARG_PARAM2 = "param2"

/**
 * 车仪表
 */
@AndroidEntryPoint
class CarPanelFragment : BaseFragment<FragmentCarPanelBinding, CarPanelVM>() {
//
//    private var param1: String? = null
//    private var param2: String? = null
//
//    override fun onCreate(savedInstanceState: Bundle?) {
//        super.onCreate(savedInstanceState)
//        arguments?.let {
//            param1 = it.getString(ARG_PARAM1)
//            param2 = it.getString(ARG_PARAM2)
//        }
//    }

    override fun getStatuBarColor(): Int {
        return -1
    }

    override fun isAutoStatusBarDarkModeEnable(): Boolean {
        return false
    }

    override fun initContentView(): Int {
        return R.layout.fragment_car_panel
    }

    override fun initViewModel(): CarPanelVM {
        return ViewModelProvider(this).get(CarPanelVM::class.java)
    }

    override fun initVariableId(): Int {
        return BR.vm
    }

    private val mainVm: MainVm by activityViewModels()

    private var currentNumber = 0 // 初始数字

    override fun initView() {
        binding.cpBean = viewModel.carPanelBean
//        //驾驶模式
//        if(viewModel.carPanelBean.driveMode=="1"){
//            binding.tvDrivemode.text="自动驾驶"
//        }else{
//            binding.tvDrivemode.text="人工驾驶"
//        }
        //车灯
        /* if (viewModel.carPanelBean.lights == 0) {
             binding.ivLeftLight.setImageResource(R.drawable.trun_left_grey)
             binding.ivRightLight.setImageResource(R.drawable.trun_left_grey)
         } else if (viewModel.carPanelBean.lights == 1) {
             binding.ivLeftLight.setImageResource(R.drawable.trun_left_blue)
             binding.ivRightLight.setImageResource(R.drawable.trun_left_grey)
         } else {
             binding.ivLeftLight.setImageResource(R.drawable.trun_left_grey)
             binding.ivRightLight.setImageResource(R.drawable.trun_right_blue)
         }
         //档位
         if (viewModel.carPanelBean.gear == 0) {
             binding.tvP.setTextColor(Color.BLUE)
             binding.tvR.setTextColor(resources.getColor(R.color.text_grey))
             binding.tvN.setTextColor(resources.getColor(R.color.text_grey))
             binding.tvD.setTextColor(resources.getColor(R.color.text_grey))
         } else if (viewModel.carPanelBean.gear == 1) {
             binding.tvP.setTextColor(resources.getColor(R.color.text_grey))
             binding.tvR.setTextColor(Color.BLUE)
             binding.tvN.setTextColor(resources.getColor(R.color.text_grey))
             binding.tvD.setTextColor(resources.getColor(R.color.text_grey))
         } else if (viewModel.carPanelBean.gear == 2) {
             binding.tvP.setTextColor(resources.getColor(R.color.text_grey))
             binding.tvR.setTextColor(resources.getColor(R.color.text_grey))
             binding.tvN.setTextColor(resources.getColor(R.color.text_grey))
             binding.tvD.setTextColor(Color.BLUE)
         } else if (viewModel.carPanelBean.gear == 3) {
             binding.tvP.setTextColor(resources.getColor(R.color.text_grey))
             binding.tvR.setTextColor(resources.getColor(R.color.text_grey))
             binding.tvN.setTextColor(Color.BLUE)
             binding.tvD.setTextColor(resources.getColor(R.color.text_grey))
         }

         // 启动协程定时切换
         lifecycleScope.launch {
             while (true) {
                 if (currentNumber > 100) {
                     return@launch
                 }
                 binding.tvSoc.text = "${currentNumber}%"
                 binding.proSoc.progress = currentNumber
                 delay(1000) // 等待10秒
                 currentNumber++
                 println("-----" + currentNumber)
             }
         }*/
    }

    override fun initListener() {
        mainVm.carVehicle.observe(this) {
            //更新车辆仪表，这里模拟只取第一个
            viewModel.setCarPanelBean(it)
        }
    }


    override fun getToData() {


    }


    companion object {
//        lateinit var cp: CarPanelFragment

        //        @JvmStatic
//        fun newInstance(param1: String, param2: String) =
//            CarPanel().apply {
//                arguments = Bundle().apply {
//                    putString(ARG_PARAM1, param1)
//                    putString(ARG_PARAM2, param2)
//                }
//            }
        @JvmStatic
        fun newInstance() = CarPanelFragment()
    }
}