package com.sd.cavphmi.ui

import android.content.Intent
import android.os.Bundle
import androidx.activity.viewModels
import com.google.android.material.snackbar.Snackbar
import androidx.appcompat.app.AppCompatActivity
import androidx.navigation.findNavController
import androidx.navigation.ui.AppBarConfiguration
import androidx.navigation.ui.navigateUp
import androidx.navigation.ui.setupActionBarWithNavController
import com.sd.cavphmi.R
import com.sd.cavphmi.databinding.ActivityLoginBinding
import com.sd.cavphmi.utils.SM4CryptoHelper
import com.sd.cavphmi.viewmodels.LoginVm
import com.sd.cavphmi.viewmodels.MainVm
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class LoginActivity : AppCompatActivity() {


    private lateinit var binding: ActivityLoginBinding

    private val loginVm: LoginVm by viewModels()
    private val mainVm: MainVm by viewModels()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityLoginBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.btLogin.setOnClickListener {
            var user = binding.etAccount.text.toString()
            var pwd = binding.etPwd.text.toString()
//            "4CIHV37pDF8sx0ZXYmYah6HSgys7F7ULSMmm39uzppc"
            var key = "Cusc@itmp-sm4key".toByteArray()
            var pp = SM4CryptoHelper.encryptECB(key, pwd.toByteArray())

            loginVm.login(user, pp, 276135).observe(this) {
//                startActivity(Intent(this,MainActivity::class.java))
            }
        }

        //  HTTP获取车辆详情
        binding.btVehinfo.setOnClickListener {
            mainVm.getVehDetail()
        }
        //  HTTP获取车位占用情况
        binding.btSpaceinfo.setOnClickListener {
            mainVm.getSpaceInfo()
        }
        //  HTTP获取AVp状态信息 以后就用socket订阅了
        binding.btAvpstatu.setOnClickListener {
            mainVm.getAvpStatus()
        }
        //直接到首页
        binding.btMain.setOnClickListener {
            startActivity(Intent(this, MainActivity::class.java))
        }


    }


}