package com.sd.cavphmi.repositorys

import com.sd.cavphmi.bean.AvpStatuBean
import com.sd.cavphmi.bean.SpaceInfoBean
import com.sd.cavphmi.bean.VehDetailBean
import com.sd.cavphmi.net.MyResult
import com.sd.cavphmi.net.RequestBodyUtil
import com.sd.cavphmi.net.httpmothod.ClientRetrofitMethod
import com.sd.cavphmi.utils.MyContants
import retrofit2.HttpException
import javax.inject.Inject

/**AVP 接口**/
class AvpDataRepo @Inject constructor(private var clientRetrofitMethod: ClientRetrofitMethod) {

    /**获取车辆详情
     * @param id 正常应该是传场地ID，但是亦庄这个和太和桥车是一样的
     */
    suspend fun getVehDetail(id: String = ""): MyResult<VehDetailBean> {
//        var map = mapOf("id" to id)
//        var map = mapOf()
        var body = RequestBodyUtil.toRequestBody(mapOf())
        try {
            var bean = clientRetrofitMethod.getVehDetail(body)
            return MyResult.Success(bean)
        } catch (e: HttpException) {
//                println("e.message = ${e.message}")
            return MyResult.Error(e.code(), e.message() ?: "error")
        } catch (e: Exception) {
            return MyResult.Error(MyContants.HTTP_ERROR, e.message ?: "error")
        }
    }

    /**
     * 获取车位占用情况
     */
    suspend fun getSpaceInfo(): MyResult<SpaceInfoBean> {
        try {
            var body = RequestBodyUtil.toRequestBody(mapOf())
            var bean = clientRetrofitMethod.getSpaceInfo(body)
            return MyResult.Success(bean)
        } catch (e: HttpException) {
//                println("e.message = ${e.message}")
            return MyResult.Error(e.code(), e.message() ?: "error")
        } catch (e: Exception) {
            return MyResult.Error(MyContants.HTTP_ERROR, e.message ?: "error")
        }
    }
    /**
     * 获取AVP状态信息
     */
    suspend fun getAvpStatus(): MyResult<AvpStatuBean> {
        try {
            var body = RequestBodyUtil.toRequestBody(mapOf())
            var bean = clientRetrofitMethod.getAvpStatus(body)
            return MyResult.Success(bean)
        } catch (e: HttpException) {
//                println("e.message = ${e.message}")
            return MyResult.Error(e.code(), e.message() ?: "error")
        } catch (e: Exception) {
            return MyResult.Error(MyContants.HTTP_ERROR, e.message ?: "error")
        }
    }


    suspend fun login(user: String, pwd: String, verifyCode: Int): MyResult<String> {
//        if (id.isNullOrEmpty()) {
//            return MyResult.Error(MyContants.HTTP_ERROR, "error")
//        }
        var map = mapOf("userAccount" to user, "password" to pwd, "verificationCode" to verifyCode)

        var body = RequestBodyUtil.toRequestBody(map)
        try {
            var bean = clientRetrofitMethod.login(body)
            return MyResult.Success(bean.token)
        } catch (e: HttpException) {
//                println("e.message = ${e.message}")
            return MyResult.Error(e.code(), e.message() ?: "error")
        } catch (e: Exception) {
            return MyResult.Error(MyContants.HTTP_ERROR, e.message ?: "error")
        }
    }

}