package commons.stand

import android.os.Environment
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import java.io.File
import java.io.IOException

object FileSdCardUtils {


    /**
     * 写文件到Download目录，需要配置FileProvider和申请权限
     * 追加模式
     */
    suspend fun writeFileToDownload(message: String, fileName: String) {
        withContext(Dispatchers.IO) {
            try {
                val file = File(
                    Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS),
                    fileName
                )
                // 核心：appendText 默认为追加模式，指定编码更安全
                file.appendText("$message\n", Charsets.UTF_8)
            } catch (e: IOException) {
                e.printStackTrace()
            }
        }
        /**
         * 写文件到Download目录，需要配置FileProvider和申请权限
         * 追加模式
         */
        suspend fun writeFileToDownload(message: String, file: File) {
            withContext(Dispatchers.IO) {
                try {
                    // 核心：appendText 默认为追加模式，指定编码更安全
                    file.appendText("$message\n", Charsets.UTF_8)
                } catch (e: IOException) {
                    e.printStackTrace()
                }
            }
        }
    }

}