package commons.gis

import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import org.locationtech.jts.geom.Coordinate
import org.locationtech.jts.geom.LineString
import org.locationtech.jts.geom.LinearRing
import org.locationtech.jts.geom.Polygon

/**线面交叉判断***/
object LineCrossPolygonChecker {

    /**
     * 计算、面与线相交
     * @param 路径点串
     * @param area 多边形的面
     * @return 线与面相交的点 起点和终点
     */
    suspend fun cauLineAreaCross(
        routes: List<List<Double>>, area: List<List<Double>>
    ): List<List<Double>> {
        return withContext(Dispatchers.Default) {
            // 方法1：直接使用坐标数组
            var lineString = MGeoTools.createLine(routes)

            //生成多边形
            // 创建 LinearRing
            val lRing: LinearRing = MGeoTools.createLinearRing(area)
            // 创建多边形（无孔洞）
            val polygon = MGeoTools.createPolygonFromLinearRing(lRing)

            var crossRet = lineCrossArea(polygon, lineString)
            // 计算相交部分
            return@withContext crossRet
        }
    }


    /***线和面相交部分**/
    fun lineCrossArea(polygon: Polygon?, lineString: LineString?): List<List<Double>> {
        if (polygon == null || lineString == null) {
            return emptyList()
        }
        // 计算相交部分
        val intersection = polygon.intersection(lineString)
        if (intersection.isEmpty) {
            return emptyList()
        }
//        val coordinates = mutableListOf<Coordinate>()
        var crossP = intersection.coordinates
        var list = crossP.map {
            listOf(it.x, it.y)
        }
        return list
    }

}