package commons.stand

import android.content.Context
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import java.io.BufferedReader
import java.io.IOException
import java.io.InputStream
import java.io.InputStreamReader

/**Assets 文件夹工具类***/
object AssetsFileUtils {
    /**
     * 逐行读取asset 文件内容，并加入列表中
     */
    suspend fun getAssetMock(context: Context, fileName: String, dst: MutableList<String>): Int {
        return withContext(Dispatchers.IO) {
            val assetManager = context.assets
            var bf: BufferedReader? = null
            try {
                val inputReader = InputStreamReader(assetManager.open(fileName))
                bf = BufferedReader(inputReader)
                var line = ""
                while (!bf.run {
                        line = readLine()
                        return@run line
                    }.isNullOrEmpty()) {
                    dst.add(line)
                }
                bf.close()
                return@withContext 1
            } catch (e: IOException) {
                e.printStackTrace()
            } finally {
                bf?.close()
            }
            return@withContext 0
        }

    }

    /**
     * 一次性读取asset 文件内容
     */
    suspend fun getAsset(context: Context, fileName: String): String {
        return withContext(Dispatchers.IO) {
            val assetManager = context.assets
            var inputStream: InputStream? = null
            var str = ""
            try {
                inputStream = assetManager.open(fileName)
                val size = inputStream.available()
                val bytes = ByteArray(size)
                inputStream.read(bytes)
                str = String(bytes)
            } catch (e: IOException) {
                e.printStackTrace()
            } finally {
                inputStream?.close()
            }
            return@withContext str
        }
    }

}