/*
 * Decompiled with CFR 0.152.
 */
package overlay;

import android.content.Context;
import com.amap.api.maps.AMap;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.PolylineOptions;
import com.amap.api.services.core.LatLonPoint;
import com.amap.api.services.route.WalkPath;
import com.amap.api.services.route.WalkStep;
import java.util.List;
import overlay.AMapServicesUtil;
import overlay.RouteOverlay;

public class WalkRouteOverlay
extends RouteOverlay {
    private PolylineOptions mPolylineOptions;
    private BitmapDescriptor walkStationDescriptor = null;
    private WalkPath walkPath;

    public WalkRouteOverlay(Context context, AMap amap, WalkPath path, LatLonPoint start, LatLonPoint end) {
        super(context);
        this.mAMap = amap;
        this.walkPath = path;
        this.startPoint = AMapServicesUtil.convertToLatLng(start);
        this.endPoint = AMapServicesUtil.convertToLatLng(end);
    }

    public void addToMap() {
        this.initPolylineOptions();
        try {
            List walkPaths = this.walkPath.getSteps();
            for (int i = 0; i < walkPaths.size(); ++i) {
                WalkStep walkStep = (WalkStep)walkPaths.get(i);
                LatLng latLng = AMapServicesUtil.convertToLatLng((LatLonPoint)walkStep.getPolyline().get(0));
                this.addWalkStationMarkers(walkStep, latLng);
                this.addWalkPolyLines(walkStep);
            }
            this.addStartAndEndMarker();
            this.showPolyline();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void checkDistanceToNextStep(WalkStep walkStep, WalkStep walkStep1) {
        LatLonPoint nextFirstPoint;
        LatLonPoint lastPoint = this.getLastWalkPoint(walkStep);
        if (!lastPoint.equals((Object)(nextFirstPoint = this.getFirstWalkPoint(walkStep1)))) {
            this.addWalkPolyLine(lastPoint, nextFirstPoint);
        }
    }

    private LatLonPoint getLastWalkPoint(WalkStep walkStep) {
        return (LatLonPoint)walkStep.getPolyline().get(walkStep.getPolyline().size() - 1);
    }

    private LatLonPoint getFirstWalkPoint(WalkStep walkStep) {
        return (LatLonPoint)walkStep.getPolyline().get(0);
    }

    private void addWalkPolyLine(LatLonPoint pointFrom, LatLonPoint pointTo) {
        this.addWalkPolyLine(AMapServicesUtil.convertToLatLng(pointFrom), AMapServicesUtil.convertToLatLng(pointTo));
    }

    private void addWalkPolyLine(LatLng latLngFrom, LatLng latLngTo) {
        this.mPolylineOptions.add(new LatLng[]{latLngFrom, latLngTo});
    }

    private void addWalkPolyLines(WalkStep walkStep) {
        this.mPolylineOptions.addAll(AMapServicesUtil.convertArrList(walkStep.getPolyline()));
    }

    private void addWalkStationMarkers(WalkStep walkStep, LatLng position) {
        this.addStationMarker(new MarkerOptions().position(position).title("\u65b9\u5411:" + walkStep.getAction() + "\n\u9053\u8def:" + walkStep.getRoad()).snippet(walkStep.getInstruction()).visible(this.nodeIconVisible).anchor(0.5f, 0.5f).icon(this.walkStationDescriptor));
    }

    private void initPolylineOptions() {
        if (this.walkStationDescriptor == null) {
            this.walkStationDescriptor = this.getWalkBitmapDescriptor();
        }
        this.mPolylineOptions = null;
        this.mPolylineOptions = new PolylineOptions();
        this.mPolylineOptions.color(this.getWalkColor()).width(this.getRouteWidth());
    }

    private void showPolyline() {
        this.addPolyLine(this.mPolylineOptions);
    }
}

