/*
 * Decompiled with CFR 0.152.
 */
package overlay;

import android.content.Context;
import android.graphics.Color;
import com.amap.api.maps.AMap;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.PolylineOptions;
import com.amap.api.services.core.LatLonPoint;
import com.amap.api.services.route.TMC;
import com.amap.api.services.route.TruckPath;
import com.amap.api.services.route.TruckStep;
import com.sd.api.R;
import com.sd.api.utils.amp.AMapUtil;
import java.util.ArrayList;
import java.util.List;
import overlay.RouteOverlay;

public class TruckRouteColorfulOverLay
extends RouteOverlay {
    private TruckPath truckPath;
    private List<LatLonPoint> throughPointList;
    private List<Marker> throughPointMarkerList = new ArrayList<Marker>();
    private boolean throughPointMarkerVisible = true;
    private List<TMC> tmcs;
    private PolylineOptions mPolylineOptions;
    private Context mContext;
    private boolean isColorfulline = true;
    private float mWidth = 17.0f;
    private List<LatLng> mLatLngsOfPath;

    public void setIsColorfulline(boolean iscolorfulline) {
        this.isColorfulline = iscolorfulline;
    }

    public TruckRouteColorfulOverLay(Context context, AMap amap, TruckPath path, LatLonPoint start, LatLonPoint end, List<LatLonPoint> throughPointList) {
        super(context);
        this.mContext = context;
        this.mAMap = amap;
        this.truckPath = path;
        this.startPoint = AMapUtil.convertToLatLng(start);
        this.endPoint = AMapUtil.convertToLatLng(end);
        this.throughPointList = throughPointList;
    }

    @Override
    public float getRouteWidth() {
        return this.mWidth;
    }

    public void setRouteWidth(float mWidth) {
        this.mWidth = mWidth;
    }

    public void addToMap() {
        this.initPolylineOptions();
        try {
            if (this.mAMap == null) {
                return;
            }
            if (this.mWidth == 0.0f || this.truckPath == null) {
                return;
            }
            this.mLatLngsOfPath = new ArrayList<LatLng>();
            this.tmcs = new ArrayList<TMC>();
            List steps = this.truckPath.getSteps();
            for (TruckStep step : steps) {
                List latlonPoints = step.getPolyline();
                List tmclist = step.getTMCs();
                this.tmcs.addAll(tmclist);
                for (LatLonPoint latlonpoint : latlonPoints) {
                    this.mPolylineOptions.add(this.convertToLatLng(latlonpoint));
                    this.mLatLngsOfPath.add(this.convertToLatLng(latlonpoint));
                }
            }
            if (this.startMarker != null) {
                this.startMarker.remove();
                this.startMarker = null;
            }
            if (this.endMarker != null) {
                this.endMarker.remove();
                this.endMarker = null;
            }
            this.addStartAndEndMarker();
            this.addThroughPointMarker();
            if (this.isColorfulline && this.tmcs.size() > 0) {
                this.colorWayUpdate(this.tmcs);
            } else {
                this.showPolyline();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void initPolylineOptions() {
        this.mPolylineOptions = null;
        this.mPolylineOptions = new PolylineOptions();
        this.mPolylineOptions.color(this.getDriveColor()).width(this.getRouteWidth());
    }

    private void showPolyline() {
        this.addPolyLine(this.mPolylineOptions);
    }

    private void colorWayUpdate(List<TMC> tmcSection) {
        if (this.mAMap == null) {
            return;
        }
        if (this.mLatLngsOfPath == null || this.mLatLngsOfPath.size() <= 0) {
            return;
        }
        if (tmcSection == null || tmcSection.size() <= 0) {
            return;
        }
        int j = 0;
        LatLng startLatLng = this.mLatLngsOfPath.get(0);
        LatLng endLatLng = null;
        double segmentTotalDistance = 0.0;
        ArrayList<LatLng> tempList = new ArrayList<LatLng>();
        this.addPolyLine(new PolylineOptions().add(new LatLng[]{this.startPoint, startLatLng}).setDottedLine(true));
        this.addPolyLine(new PolylineOptions().add(new LatLng[]{this.mLatLngsOfPath.get(this.mLatLngsOfPath.size() - 1), this.endPoint}).setDottedLine(true));
        for (int i = 0; i < this.mLatLngsOfPath.size() && j < tmcSection.size(); ++i) {
            TMC segmentTrafficStatus = tmcSection.get(j);
            endLatLng = this.mLatLngsOfPath.get(i);
            double distanceBetweenTwoPosition = TruckRouteColorfulOverLay.calculateDistance(startLatLng, endLatLng);
            if ((segmentTotalDistance += distanceBetweenTwoPosition) > (double)(segmentTrafficStatus.getDistance() + 1)) {
                double toSegDis = distanceBetweenTwoPosition - (segmentTotalDistance - (double)segmentTrafficStatus.getDistance());
                LatLng middleLatLng = TruckRouteColorfulOverLay.getPointForDis(startLatLng, endLatLng, toSegDis);
                tempList.add(middleLatLng);
                startLatLng = middleLatLng;
                --i;
            } else {
                tempList.add(endLatLng);
                startLatLng = endLatLng;
            }
            if (segmentTotalDistance >= (double)segmentTrafficStatus.getDistance() || i == this.mLatLngsOfPath.size() - 1) {
                if (j == tmcSection.size() - 1 && i < this.mLatLngsOfPath.size() - 1) {
                    ++i;
                    while (i < this.mLatLngsOfPath.size()) {
                        LatLng lastLatLng = this.mLatLngsOfPath.get(i);
                        tempList.add(lastLatLng);
                        ++i;
                    }
                }
                ++j;
                if (segmentTrafficStatus.getStatus().equals("\u7545\u901a")) {
                    this.addPolyLine(new PolylineOptions().addAll(tempList).width(this.mWidth).color(-16711936));
                } else if (segmentTrafficStatus.getStatus().equals("\u7f13\u884c")) {
                    this.addPolyLine(new PolylineOptions().addAll(tempList).width(this.mWidth).color(-256));
                } else if (segmentTrafficStatus.getStatus().equals("\u62e5\u5835")) {
                    this.addPolyLine(new PolylineOptions().addAll(tempList).width(this.mWidth).color(-65536));
                } else if (segmentTrafficStatus.getStatus().equals("\u4e25\u91cd\u62e5\u5835")) {
                    this.addPolyLine(new PolylineOptions().addAll(tempList).width(this.mWidth).color(Color.parseColor((String)"#990033")));
                } else {
                    this.addPolyLine(new PolylineOptions().addAll(tempList).width(this.mWidth).color(Color.parseColor((String)"#537edc")));
                }
                tempList.clear();
                tempList.add(startLatLng);
                segmentTotalDistance = 0.0;
            }
            if (i != this.mLatLngsOfPath.size() - 1) continue;
            this.addPolyLine(new PolylineOptions().add(new LatLng[]{endLatLng, this.endPoint}).setDottedLine(true));
        }
    }

    public LatLng convertToLatLng(LatLonPoint point) {
        return new LatLng(point.getLatitude(), point.getLongitude());
    }

    private void addLimitMarker(TruckStep step, LatLng latLng) {
    }

    @Override
    protected LatLngBounds getLatLngBounds() {
        LatLngBounds.Builder b = LatLngBounds.builder();
        b.include(new LatLng(this.startPoint.latitude, this.startPoint.longitude));
        b.include(new LatLng(this.endPoint.latitude, this.endPoint.longitude));
        if (this.throughPointList != null && this.throughPointList.size() > 0) {
            for (int i = 0; i < this.throughPointList.size(); ++i) {
                b.include(new LatLng(this.throughPointList.get(i).getLatitude(), this.throughPointList.get(i).getLongitude()));
            }
        }
        return b.build();
    }

    public void setThroughPointIconVisibility(boolean visible) {
        try {
            this.throughPointMarkerVisible = visible;
            if (this.throughPointMarkerList != null && this.throughPointMarkerList.size() > 0) {
                for (int i = 0; i < this.throughPointMarkerList.size(); ++i) {
                    this.throughPointMarkerList.get(i).setVisible(visible);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void addThroughPointMarker() {
        if (this.throughPointList != null && this.throughPointList.size() > 0) {
            LatLonPoint latLonPoint = null;
            for (int i = 0; i < this.throughPointList.size(); ++i) {
                latLonPoint = this.throughPointList.get(i);
                if (latLonPoint == null) continue;
                this.throughPointMarkerList.add(this.mAMap.addMarker(new MarkerOptions().position(new LatLng(latLonPoint.getLatitude(), latLonPoint.getLongitude())).visible(this.throughPointMarkerVisible).icon(this.getThroughPointBitDes()).title("\u9014\u7ecf\u70b9")));
            }
        }
    }

    private BitmapDescriptor getThroughPointBitDes() {
        return BitmapDescriptorFactory.fromResource((int)R.drawable.amap_through);
    }

    public static int calculateDistance(LatLng start, LatLng end) {
        double x1 = start.longitude;
        double y1 = start.latitude;
        double x2 = end.longitude;
        double y2 = end.latitude;
        return TruckRouteColorfulOverLay.calculateDistance(x1, y1, x2, y2);
    }

    public static int calculateDistance(double x1, double y1, double x2, double y2) {
        double NF_pi = 0.01745329251994329;
        x2 *= 0.01745329251994329;
        y2 *= 0.01745329251994329;
        double sinx1 = Math.sin(x1 *= 0.01745329251994329);
        double siny1 = Math.sin(y1 *= 0.01745329251994329);
        double cosx1 = Math.cos(x1);
        double cosy1 = Math.cos(y1);
        double sinx2 = Math.sin(x2);
        double siny2 = Math.sin(y2);
        double cosx2 = Math.cos(x2);
        double cosy2 = Math.cos(y2);
        double[] v1 = new double[]{cosy1 * cosx1 - cosy2 * cosx2, cosy1 * sinx1 - cosy2 * sinx2, siny1 - siny2};
        double dist = Math.sqrt(v1[0] * v1[0] + v1[1] * v1[1] + v1[2] * v1[2]);
        return (int)(Math.asin(dist / 2.0) * 1.27420015798544E7);
    }

    public static LatLng getPointForDis(LatLng sPt, LatLng ePt, double dis) {
        double lSegLength = TruckRouteColorfulOverLay.calculateDistance(sPt, ePt);
        double preResult = dis / lSegLength;
        return new LatLng((ePt.latitude - sPt.latitude) * preResult + sPt.latitude, (ePt.longitude - sPt.longitude) * preResult + sPt.longitude);
    }

    @Override
    public void removeFromMap() {
        try {
            super.removeFromMap();
            if (this.throughPointMarkerList != null && this.throughPointMarkerList.size() > 0) {
                for (int i = 0; i < this.throughPointMarkerList.size(); ++i) {
                    this.throughPointMarkerList.get(i).remove();
                }
                this.throughPointMarkerList.clear();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

