/*
 * Decompiled with CFR 0.152.
 */
package overlay;

import com.amap.api.maps.AMap;
import com.amap.api.maps.CameraUpdateFactory;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.amap.api.maps.model.Polyline;
import com.amap.api.maps.model.PolylineOptions;
import java.util.ArrayList;
import java.util.List;

public class TraceOverlay {
    private Polyline mPolyline;
    private PolylineOptions mOption;
    private AMap mAMap;
    private List<LatLng> mTracedList = new ArrayList<LatLng>();
    public static final int TRACE_STATUS_PROCESSING = 1;
    public static final int TRACE_STATUS_FINISH = 2;
    public static final int TRACE_STATUS_FAILURE = 3;
    public static final int TRACE_STATUS_PREPARE = 4;
    private int mTraceStatus = 4;
    private int mDistance;
    private int mWaitTime;

    public TraceOverlay(AMap amap, List<LatLng> lines) {
        this.mAMap = amap;
        this.options();
        this.mOption.addAll(lines);
        this.mPolyline = amap.addPolyline(this.mOption);
    }

    public TraceOverlay(AMap amap) {
        this.mAMap = amap;
        this.options();
    }

    public void add(List<LatLng> segments) {
        if (segments == null || segments.size() == 0) {
            return;
        }
        this.mTracedList.addAll(segments);
        this.options();
        if (this.mPolyline == null) {
            this.mPolyline = this.mAMap.addPolyline(this.mOption);
        }
        this.mPolyline.setPoints(this.mTracedList);
    }

    public void remove() {
        if (this.mPolyline != null) {
            this.mPolyline.remove();
        }
    }

    public void setProperCamera(List<LatLng> lists) {
        LatLngBounds.Builder builder = LatLngBounds.builder();
        if (lists == null || lists.size() == 0) {
            return;
        }
        for (LatLng latlng : lists) {
            builder.include(latlng);
        }
        try {
            LatLngBounds bounds = builder.build();
            this.mAMap.moveCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)bounds, (int)20));
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void zoopToSpan() {
        List lists = this.mOption.getPoints();
        this.setProperCamera(lists);
    }

    private PolylineOptions options() {
        if (this.mOption == null) {
            this.mOption = new PolylineOptions();
            this.mOption.setCustomTexture(BitmapDescriptorFactory.fromAsset((String)"tracelinetexture.png"));
            this.mOption.width(40.0f);
        }
        return this.mOption;
    }

    public int getTraceStatus() {
        return this.mTraceStatus;
    }

    public void setTraceStatus(int mTraceStatus) {
        this.mTraceStatus = mTraceStatus;
    }

    public int getDistance() {
        return this.mDistance;
    }

    public void setDistance(int mDistance) {
        this.mDistance = mDistance;
    }

    public int getWaitTime() {
        return this.mWaitTime;
    }

    public void setWaitTime(int mWaitTime) {
        this.mWaitTime = mWaitTime;
    }
}

