/*
 * Decompiled with CFR 0.152.
 */
package overlay;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;
import com.amap.api.maps.AMap;
import com.amap.api.maps.CameraUpdateFactory;
import com.amap.api.maps.MapView;
import com.amap.api.maps.model.Gradient;
import com.amap.api.maps.model.HeatMapItem;
import com.amap.api.maps.model.HeatMapLayer;
import com.amap.api.maps.model.HeatMapLayerOptions;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.WeightedLatLng;
import com.sd.api.R;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class HoneycombHeatMapActivity
extends Activity {
    private MapView mMapView;
    private AMap mMap;
    private TextView heatItemTv = null;
    private HeatMapLayer heatMapLayer = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_heatmap_overlay);
        this.mMapView = (MapView)this.findViewById(R.id.mapview);
        this.mMapView.onCreate(savedInstanceState);
        this.heatItemTv = (TextView)this.findViewById(R.id.heat_item_tv);
        this.mMap = this.mMapView.getMap();
        this.mMap.setOnMapLoadedListener(new AMap.OnMapLoadedListener(){

            public void onMapLoaded() {
                HoneycombHeatMapActivity.this.testHeatMapOverlay();
            }
        });
    }

    private void testHeatMapOverlay() {
        this.mMap.moveCamera(CameraUpdateFactory.newLatLngZoom((LatLng)new LatLng(36.673927, 119.996751), (float)8.5f));
        String heatMapStr = new String(HoneycombHeatMapActivity.readFileContentsFromAssets((Context)this, "heatmap/heatmap_honey.data"));
        String[] heatMapStrs = heatMapStr.split("\n");
        WeightedLatLng[] weightlatlngs = new WeightedLatLng[heatMapStrs.length];
        int index = 0;
        for (String str : heatMapStrs) {
            String[] dataItem = str.split(",");
            if (dataItem != null && dataItem.length == 3) {
                weightlatlngs[index] = new WeightedLatLng(new LatLng(Double.parseDouble(dataItem[1]), Double.parseDouble(dataItem[0])), Double.parseDouble(dataItem[2]));
            } else {
                Log.e((String)"mapcore", (String)"read file failed");
            }
            ++index;
        }
        int[] colors = new int[]{Color.parseColor((String)"#ecda9a"), Color.parseColor((String)"#efc47e"), Color.parseColor((String)"#f3ad6a"), Color.parseColor((String)"#f7945d"), Color.parseColor((String)"#f97b57"), Color.parseColor((String)"#f66356"), Color.parseColor((String)"#ee4d5a")};
        float[] startPoints = new float[colors.length];
        for (int i = 0; i < startPoints.length; ++i) {
            startPoints[i] = (float)i * 1.0f / (float)startPoints.length;
        }
        HeatMapLayerOptions heatMapLayerOptions = new HeatMapLayerOptions();
        heatMapLayerOptions.weightedData(Arrays.asList(weightlatlngs));
        Gradient gradient = new Gradient(colors, startPoints);
        heatMapLayerOptions.gradient(gradient);
        heatMapLayerOptions.size(6000.0f);
        heatMapLayerOptions.gap(300.0f);
        heatMapLayerOptions.minZoom(5.0f);
        heatMapLayerOptions.maxZoom(19.0f);
        heatMapLayerOptions.opacity(0.85f);
        heatMapLayerOptions.type(2);
        heatMapLayerOptions.zIndex(1.0f);
        this.heatMapLayer = this.mMap.addHeatMapLayer(heatMapLayerOptions);
        this.mMap.setOnMapClickListener(new AMap.OnMapClickListener(){

            public void onMapClick(LatLng latLng) {
                if (HoneycombHeatMapActivity.this.heatMapLayer != null && HoneycombHeatMapActivity.this.mMap != null && latLng != null) {
                    HeatMapItem item = HoneycombHeatMapActivity.this.heatMapLayer.getHeatMapItem(latLng);
                    if (item != null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u70ed\u529b\u4e2d\u5fc3\uff1a").append(item.getCenter()).append("\n");
                        stringBuffer.append("\u70ed\u529b\u503c\uff1a").append(item.getIntensity()).append("\n");
                        String indexes = "";
                        int[] nArray = item.getIndexes();
                        int n = nArray.length;
                        for (int i = 0; i < n; ++i) {
                            Integer integer = nArray[i];
                            indexes = indexes + integer + ",";
                        }
                        stringBuffer.append("\u70ed\u529b\u7d22\u5f15\uff1a").append(indexes).append("\n");
                        stringBuffer.append("\u6570\u636e\u6570\u91cf\uff1a").append(item.getIndexes().length);
                        HoneycombHeatMapActivity.this.updateHeatItemTv(stringBuffer.toString());
                    } else {
                        HoneycombHeatMapActivity.this.updateHeatItemTv("\u672a\u627e\u5230\u70ed\u529b\u4fe1\u606f");
                    }
                }
            }
        });
    }

    private void updateHeatItemTv(final String text) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (HoneycombHeatMapActivity.this.heatItemTv != null && text != null) {
                    HoneycombHeatMapActivity.this.heatItemTv.setText((CharSequence)text);
                }
            }
        });
    }

    public static byte[] readFileContentsFromAssets(Context context, String assetsPath) {
        AssetManager assetManager = context.getAssets();
        InputStream is = null;
        try {
            String path = assetsPath;
            is = assetManager.open(path);
            int count = is.available();
            if (count == 0) {
                return null;
            }
            byte[] bufferByte = new byte[count];
            for (int readCount = 0; readCount < count; readCount += is.read(bufferByte, readCount, count - readCount)) {
            }
            is.close();
            return bufferByte;
        }
        catch (IOException e) {
            return null;
        }
        catch (OutOfMemoryError e) {
            return null;
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.mMapView != null) {
            this.mMapView.onResume();
        }
    }

    protected void onPause() {
        if (this.mMapView != null) {
            this.mMapView.onPause();
        }
        super.onPause();
    }

    protected void onDestroy() {
        if (this.mMapView != null) {
            this.mMapView.onDestroy();
        }
        super.onDestroy();
    }
}

