/*
 * Decompiled with CFR 0.152.
 */
package overlay;

import android.content.Context;
import android.graphics.Color;
import com.amap.api.maps.AMap;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.PolylineOptions;
import com.amap.api.services.core.LatLonPoint;
import com.amap.api.services.route.DrivePlanPath;
import com.amap.api.services.route.DrivePlanStep;
import com.amap.api.services.route.DriveRoutePlanResult;
import com.amap.api.services.route.TMC;
import com.amap.api.services.route.TimeInfo;
import com.amap.api.services.route.TimeInfosElement;
import com.sd.api.utils.amp.AMapUtil;
import java.util.ArrayList;
import java.util.List;
import overlay.RouteOverlay;

public class DrivingRoutePlanOverlay
extends RouteOverlay {
    private Context mContext;
    DriveRoutePlanResult driveRoutePlanResult;
    private boolean isColorfulline = true;
    private float mWidth = 25.0f;
    private List<LatLng> mLatLngsOfPath;
    private int selectIndex = 0;
    private PolylineOptions mPolylineOptions;
    private PolylineOptions mPolylineOptionscolor;

    public DrivingRoutePlanOverlay(Context context, AMap amap, DriveRoutePlanResult result, int index) {
        super(context);
        this.mContext = context;
        this.mAMap = amap;
        this.driveRoutePlanResult = result;
        this.selectIndex = index;
        if (result != null) {
            this.startPoint = AMapUtil.convertToLatLng(result.getStartPos());
            this.endPoint = AMapUtil.convertToLatLng(result.getTargetPos());
        }
    }

    public void setIsColorfulline(boolean iscolorfulline) {
        this.isColorfulline = iscolorfulline;
    }

    public void addToMap() {
        this.initPolylineOptions();
        try {
            int pathIndex;
            if (this.mAMap == null) {
                return;
            }
            if (this.mWidth == 0.0f || this.driveRoutePlanResult == null) {
                return;
            }
            if (this.driveRoutePlanResult.getTimeInfos() == null || this.driveRoutePlanResult.getPaths() == null) {
                return;
            }
            this.mLatLngsOfPath = new ArrayList<LatLng>();
            List<TMC> tmcs = new ArrayList();
            List timeInfos = this.driveRoutePlanResult.getTimeInfos();
            if (this.selectIndex >= 0 && this.selectIndex < timeInfos.size()) {
                tmcs = ((TimeInfosElement)((TimeInfo)timeInfos.get(this.selectIndex)).getElements().get(0)).getTMCs();
            }
            if ((pathIndex = ((TimeInfosElement)((TimeInfo)timeInfos.get(this.selectIndex)).getElements().get(0)).getPathindex()) < 0 || pathIndex > this.driveRoutePlanResult.getPaths().size()) {
                return;
            }
            DrivePlanPath drivePlanPath = (DrivePlanPath)this.driveRoutePlanResult.getPaths().get(pathIndex);
            List drivePaths = drivePlanPath.getSteps();
            for (DrivePlanStep step : drivePaths) {
                List latlonPoints = step.getPolyline();
                for (LatLonPoint latlonpoint : latlonPoints) {
                    this.mPolylineOptions.add(this.convertToLatLng(latlonpoint));
                    this.mLatLngsOfPath.add(this.convertToLatLng(latlonpoint));
                }
            }
            if (this.startMarker != null) {
                this.startMarker.remove();
                this.startMarker = null;
            }
            if (this.endMarker != null) {
                this.endMarker.remove();
                this.endMarker = null;
            }
            this.addStartAndEndMarker();
            if (this.isColorfulline && tmcs.size() > 0) {
                this.colorWayUpdate(tmcs);
                this.showcolorPolyline();
            } else {
                this.showPolyline();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void initPolylineOptions() {
        this.mPolylineOptions = null;
        this.mPolylineOptions = new PolylineOptions();
        this.mPolylineOptions.color(this.getDriveColor()).width(this.getRouteWidth());
    }

    private void showPolyline() {
        this.addPolyLine(this.mPolylineOptions);
    }

    private void showcolorPolyline() {
        this.addPolyLine(this.mPolylineOptionscolor);
    }

    private void colorWayUpdate(List<TMC> tmcSection) {
        if (this.mAMap == null) {
            return;
        }
        if (tmcSection == null || tmcSection.size() <= 0) {
            return;
        }
        this.mPolylineOptionscolor = null;
        this.mPolylineOptionscolor = new PolylineOptions();
        this.mPolylineOptionscolor.width(this.getRouteWidth());
        ArrayList<Integer> colorList = new ArrayList<Integer>();
        this.mPolylineOptionscolor.add(AMapUtil.convertToLatLng((LatLonPoint)tmcSection.get(0).getPolyline().get(0)));
        colorList.add(this.getDriveColor());
        for (int i = 0; i < tmcSection.size(); ++i) {
            TMC segmentTrafficStatus = tmcSection.get(i);
            int color2 = this.getcolor(segmentTrafficStatus.getStatus());
            List mployline = segmentTrafficStatus.getPolyline();
            for (int j = 1; j < mployline.size(); ++j) {
                this.mPolylineOptionscolor.add(AMapUtil.convertToLatLng((LatLonPoint)mployline.get(j)));
                colorList.add(color2);
            }
        }
        colorList.add(this.getDriveColor());
        this.mPolylineOptionscolor.colorValues(colorList);
    }

    private int getcolor(String status) {
        if (status.equals("\u7545\u901a")) {
            return -16711936;
        }
        if (status.equals("\u7f13\u884c")) {
            return -256;
        }
        if (status.equals("\u62e5\u5835")) {
            return -65536;
        }
        if (status.equals("\u4e25\u91cd\u62e5\u5835")) {
            return Color.parseColor((String)"#990033");
        }
        return Color.parseColor((String)"#537edc");
    }

    public LatLng convertToLatLng(LatLonPoint point) {
        return new LatLng(point.getLatitude(), point.getLongitude());
    }
}

