/*
 * Decompiled with CFR 0.152.
 */
package overlay;

import android.content.Context;
import android.graphics.Color;
import com.amap.api.maps.AMap;
import com.amap.api.maps.CameraUpdateFactory;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.Polyline;
import com.amap.api.maps.model.PolylineOptions;
import com.amap.api.services.busline.BusLineItem;
import com.amap.api.services.busline.BusStationItem;
import com.amap.api.services.core.LatLonPoint;
import com.sd.api.R;
import java.util.ArrayList;
import java.util.List;
import overlay.AMapServicesUtil;

public class BusLineOverlay {
    private BusLineItem mBusLineItem;
    private AMap mAMap;
    private ArrayList<Marker> mBusStationMarks = new ArrayList();
    private Polyline mBusLinePolyline;
    private List<BusStationItem> mBusStations;
    private BitmapDescriptor startBit;
    private BitmapDescriptor endBit;
    private BitmapDescriptor busBit;
    private Context mContext;

    public BusLineOverlay(Context context, AMap amap, BusLineItem busLineItem) {
        this.mContext = context;
        this.mBusLineItem = busLineItem;
        this.mAMap = amap;
        this.mBusStations = this.mBusLineItem.getBusStations();
    }

    public void addToMap() {
        try {
            List pointList = this.mBusLineItem.getDirectionsCoordinates();
            ArrayList<LatLng> listPolyline = AMapServicesUtil.convertArrList(pointList);
            this.mBusLinePolyline = this.mAMap.addPolyline(new PolylineOptions().addAll(listPolyline).color(this.getBusColor()).width(this.getBuslineWidth()));
            if (this.mBusStations.size() < 1) {
                return;
            }
            for (int i = 1; i < this.mBusStations.size() - 1; ++i) {
                Marker marker = this.mAMap.addMarker(this.getMarkerOptions(i));
                this.mBusStationMarks.add(marker);
            }
            Marker markerStart = this.mAMap.addMarker(this.getMarkerOptions(0));
            this.mBusStationMarks.add(markerStart);
            Marker markerEnd = this.mAMap.addMarker(this.getMarkerOptions(this.mBusStations.size() - 1));
            this.mBusStationMarks.add(markerEnd);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void removeFromMap() {
        if (this.mBusLinePolyline != null) {
            this.mBusLinePolyline.remove();
        }
        try {
            for (Marker mark : this.mBusStationMarks) {
                mark.remove();
            }
            this.destroyBit();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void destroyBit() {
        if (this.startBit != null) {
            this.startBit.recycle();
            this.startBit = null;
        }
        if (this.endBit != null) {
            this.endBit.recycle();
            this.endBit = null;
        }
        if (this.busBit != null) {
            this.busBit.recycle();
            this.busBit = null;
        }
    }

    public void zoomToSpan() {
        if (this.mAMap == null) {
            return;
        }
        try {
            List coordin = this.mBusLineItem.getDirectionsCoordinates();
            if (coordin != null && coordin.size() > 0) {
                LatLngBounds bounds = this.getLatLngBounds(coordin);
                this.mAMap.moveCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)bounds, (int)5));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private LatLngBounds getLatLngBounds(List<LatLonPoint> coordin) {
        LatLngBounds.Builder b = LatLngBounds.builder();
        for (int i = 0; i < coordin.size(); ++i) {
            b.include(new LatLng(coordin.get(i).getLatitude(), coordin.get(i).getLongitude()));
        }
        return b.build();
    }

    private MarkerOptions getMarkerOptions(int index) {
        MarkerOptions options = new MarkerOptions().position(new LatLng(this.mBusStations.get(index).getLatLonPoint().getLatitude(), this.mBusStations.get(index).getLatLonPoint().getLongitude())).title(this.getTitle(index)).snippet(this.getSnippet(index));
        if (index == 0) {
            options.icon(this.getStartBitmapDescriptor());
        } else if (index == this.mBusStations.size() - 1) {
            options.icon(this.getEndBitmapDescriptor());
        } else {
            options.anchor(0.5f, 0.5f);
            options.icon(this.getBusBitmapDescriptor());
        }
        return options;
    }

    protected BitmapDescriptor getStartBitmapDescriptor() {
        this.startBit = BitmapDescriptorFactory.fromResource((int)R.drawable.amap_start);
        return this.startBit;
    }

    protected BitmapDescriptor getEndBitmapDescriptor() {
        this.endBit = BitmapDescriptorFactory.fromResource((int)R.drawable.amap_end);
        return this.endBit;
    }

    protected BitmapDescriptor getBusBitmapDescriptor() {
        this.busBit = BitmapDescriptorFactory.fromResource((int)R.drawable.amap_bus);
        return this.busBit;
    }

    protected String getTitle(int index) {
        return this.mBusStations.get(index).getBusStationName();
    }

    protected String getSnippet(int index) {
        return "";
    }

    public int getBusStationIndex(Marker marker) {
        for (int i = 0; i < this.mBusStationMarks.size(); ++i) {
            if (!this.mBusStationMarks.get(i).equals((Object)marker)) continue;
            return i;
        }
        return -1;
    }

    public BusStationItem getBusStationItem(int index) {
        if (index < 0 || index >= this.mBusStations.size()) {
            return null;
        }
        return this.mBusStations.get(index);
    }

    protected int getBusColor() {
        return Color.parseColor((String)"#537edc");
    }

    protected float getBuslineWidth() {
        return 18.0f;
    }
}

