/*
 * Decompiled with CFR 0.152.
 */
package com.sd.api.utils.amp;

import android.text.Html;
import android.text.Spanned;
import android.widget.EditText;
import com.amap.api.maps.model.LatLng;
import com.amap.api.services.core.LatLonPoint;
import com.amap.api.services.route.BusPath;
import com.amap.api.services.route.BusStep;
import com.amap.api.services.route.RouteBusLineItem;
import com.amap.api.services.route.RouteRailwayItem;
import com.sd.api.R;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AMapUtil {
    public static final String HtmlBlack = "#000000";
    public static final String HtmlGray = "#808080";

    public static String checkEditText(EditText editText) {
        if (editText != null && editText.getText() != null && !editText.getText().toString().trim().equals("")) {
            return editText.getText().toString().trim();
        }
        return "";
    }

    public static Spanned stringToSpan(String src) {
        return src == null ? null : Html.fromHtml((String)src.replace("\n", "<br />"));
    }

    public static String colorFont(String src, String color2) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<font color=").append(color2).append(">").append(src).append("</font>");
        return strBuf.toString();
    }

    public static String makeHtmlNewLine() {
        return "<br />";
    }

    public static String makeHtmlSpace(int number) {
        String space = "&nbsp;";
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < number; ++i) {
            result.append("&nbsp;");
        }
        return result.toString();
    }

    public static String getFriendlyLength(int lenMeter) {
        if (lenMeter > 10000) {
            int dis = lenMeter / 1000;
            return dis + "\u516c\u91cc";
        }
        if (lenMeter > 1000) {
            float dis = (float)lenMeter / 1000.0f;
            DecimalFormat fnum = new DecimalFormat("##0.0");
            String dstr = fnum.format(dis);
            return dstr + "\u516c\u91cc";
        }
        if (lenMeter > 100) {
            int dis = lenMeter / 50 * 50;
            return dis + "\u7c73";
        }
        int dis = lenMeter / 10 * 10;
        if (dis == 0) {
            dis = 10;
        }
        return dis + "\u7c73";
    }

    public static boolean IsEmptyOrNullString(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static LatLonPoint convertToLatLonPoint(LatLng latlon) {
        return new LatLonPoint(latlon.latitude, latlon.longitude);
    }

    public static LatLng convertToLatLng(LatLonPoint latLonPoint) {
        return new LatLng(latLonPoint.getLatitude(), latLonPoint.getLongitude());
    }

    public static ArrayList<LatLng> convertArrList(List<LatLonPoint> shapes) {
        ArrayList<LatLng> lineShapes = new ArrayList<LatLng>();
        for (LatLonPoint point : shapes) {
            LatLng latLngTemp = AMapUtil.convertToLatLng(point);
            lineShapes.add(latLngTemp);
        }
        return lineShapes;
    }

    public static String convertToTime(long time) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date(time);
        return df.format(date);
    }

    public static String getFriendlyTime(int second) {
        if (second > 3600) {
            int hour = second / 3600;
            int miniate = second % 3600 / 60;
            return hour + "\u5c0f\u65f6" + miniate + "\u5206\u949f";
        }
        if (second >= 60) {
            int miniate = second / 60;
            return miniate + "\u5206\u949f";
        }
        return second + "\u79d2";
    }

    public static int getDriveActionID(String actionName) {
        if (actionName == null || actionName.equals("")) {
            return R.drawable.dir3;
        }
        if ("\u5de6\u8f6c".equals(actionName)) {
            return R.drawable.dir2;
        }
        if ("\u53f3\u8f6c".equals(actionName)) {
            return R.drawable.dir1;
        }
        if ("\u5411\u5de6\u524d\u65b9\u884c\u9a76".equals(actionName) || "\u9760\u5de6".equals(actionName)) {
            return R.drawable.dir6;
        }
        if ("\u5411\u53f3\u524d\u65b9\u884c\u9a76".equals(actionName) || "\u9760\u53f3".equals(actionName)) {
            return R.drawable.dir5;
        }
        if ("\u5411\u5de6\u540e\u65b9\u884c\u9a76".equals(actionName) || "\u5de6\u8f6c\u8c03\u5934".equals(actionName)) {
            return R.drawable.dir7;
        }
        if ("\u5411\u53f3\u540e\u65b9\u884c\u9a76".equals(actionName)) {
            return R.drawable.dir8;
        }
        if ("\u76f4\u884c".equals(actionName)) {
            return R.drawable.dir3;
        }
        if ("\u51cf\u901f\u884c\u9a76".equals(actionName)) {
            return R.drawable.dir4;
        }
        return R.drawable.dir3;
    }

    public static int getWalkActionID(String actionName) {
        if (actionName == null || actionName.equals("")) {
            return R.drawable.dir13;
        }
        if ("\u5de6\u8f6c".equals(actionName)) {
            return R.drawable.dir2;
        }
        if ("\u53f3\u8f6c".equals(actionName)) {
            return R.drawable.dir1;
        }
        if ("\u5411\u5de6\u524d\u65b9".equals(actionName) || "\u9760\u5de6".equals(actionName) || actionName.contains("\u5411\u5de6\u524d\u65b9")) {
            return R.drawable.dir6;
        }
        if ("\u5411\u53f3\u524d\u65b9".equals(actionName) || "\u9760\u53f3".equals(actionName) || actionName.contains("\u5411\u53f3\u524d\u65b9")) {
            return R.drawable.dir5;
        }
        if ("\u5411\u5de6\u540e\u65b9".equals(actionName) || actionName.contains("\u5411\u5de6\u540e\u65b9")) {
            return R.drawable.dir7;
        }
        if ("\u5411\u53f3\u540e\u65b9".equals(actionName) || actionName.contains("\u5411\u53f3\u540e\u65b9")) {
            return R.drawable.dir8;
        }
        if ("\u76f4\u884c".equals(actionName)) {
            return R.drawable.dir3;
        }
        if ("\u901a\u8fc7\u4eba\u884c\u6a2a\u9053".equals(actionName)) {
            return R.drawable.dir9;
        }
        if ("\u901a\u8fc7\u8fc7\u8857\u5929\u6865".equals(actionName)) {
            return R.drawable.dir11;
        }
        if ("\u901a\u8fc7\u5730\u4e0b\u901a\u9053".equals(actionName)) {
            return R.drawable.dir10;
        }
        return R.drawable.dir13;
    }

    public static String getBusPathTitle(BusPath busPath) {
        if (busPath == null) {
            return String.valueOf("");
        }
        List busSetps = busPath.getSteps();
        if (busSetps == null) {
            return String.valueOf("");
        }
        StringBuffer sb = new StringBuffer();
        for (BusStep busStep : busSetps) {
            StringBuffer title = new StringBuffer();
            if (busStep.getBusLines().size() > 0) {
                for (RouteBusLineItem busline : busStep.getBusLines()) {
                    if (busline == null) continue;
                    String buslineName = AMapUtil.getSimpleBusLineName(busline.getBusLineName());
                    title.append(buslineName);
                    title.append(" / ");
                }
                sb.append(title.substring(0, title.length() - 3));
                sb.append(" > ");
            }
            if (busStep.getRailway() == null) continue;
            RouteRailwayItem railway = busStep.getRailway();
            sb.append(railway.getTrip() + "(" + railway.getDeparturestop().getName() + " - " + railway.getArrivalstop().getName() + ")");
            sb.append(" > ");
        }
        return sb.substring(0, sb.length() - 3);
    }

    public static String getBusPathDes(BusPath busPath) {
        if (busPath == null) {
            return String.valueOf("");
        }
        long second = busPath.getDuration();
        String time = AMapUtil.getFriendlyTime((int)second);
        float subDistance = busPath.getDistance();
        String subDis = AMapUtil.getFriendlyLength((int)subDistance);
        float walkDistance = busPath.getWalkDistance();
        String walkDis = AMapUtil.getFriendlyLength((int)walkDistance);
        return String.valueOf(time + " | " + subDis + " | \u6b65\u884c" + walkDis);
    }

    public static String getSimpleBusLineName(String busLineName) {
        if (busLineName == null) {
            return String.valueOf("");
        }
        return busLineName.replaceAll("\\(.*?\\)", "");
    }
}

