/*
 * Decompiled with CFR 0.152.
 */
package com.sd.api.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.media.AudioManager;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.StatFs;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.util.Base64;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.Toast;
import com.minedata.minenavi.addons.DistanceBean;
import com.minedata.minenavi.addons.TimeBean;
import com.minedata.minenavi.map.MineMap;
import com.minedata.minenavi.mapdal.DistanceStringInfo;
import com.minedata.minenavi.mapdal.NativeEnv;
import com.minedata.minenavi.util.MineNaviUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

public class Utils {
    private Context mContext;
    private AudioManager mAudioManager;
    private PackageManager mPackageManager;
    private float mDpiFactor = 2.0f;
    private boolean mIsInited = false;
    private Timer mTimer;
    private Context mApplicationContext;
    private CountDownTimer mCountDownTimer;
    private TranslateAnimation mTranslateAnimation;
    private Handler delayedViewOperateHandler = new Handler();
    private SimpleDateFormat mSimpleDateFormat;

    public static Utils getInstance() {
        return SingletonHolder.instance;
    }

    public void init(Context context) {
        if (this.mIsInited) {
            return;
        }
        this.mContext = context;
        this.mApplicationContext = context.getApplicationContext();
        this.mTimer = new Timer();
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.mPackageManager = this.mContext.getPackageManager();
        this.mDpiFactor = context.getResources().getDisplayMetrics().density;
        this.mIsInited = true;
    }

    public int getCurrentVolume() {
        return this.mAudioManager.getStreamVolume(3);
    }

    public int getMaxVolume() {
        return this.mAudioManager.getStreamMaxVolume(3);
    }

    public void setVolume(int volumeValue) {
        this.mAudioManager.setStreamVolume(3, volumeValue, 4);
    }

    public boolean isAppOnForeground() {
        ActivityManager activityManager = (ActivityManager)this.mContext.getApplicationContext().getSystemService("activity");
        String packageName = this.mContext.getApplicationContext().getPackageName();
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (!appProcess.processName.equals(packageName) || appProcess.importance != 100) continue;
            return true;
        }
        return false;
    }

    public boolean isCharging() {
        IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = this.mContext.registerReceiver(null, ifilter);
        int status = batteryStatus.getIntExtra("status", -1);
        boolean isCharging = status == 2 || status == 5;
        return isCharging;
    }

    @TargetApi(value=17)
    public int getWindowHeight(Activity activity) {
        Point realSize = new Point();
        activity.getWindowManager().getDefaultDisplay().getRealSize(realSize);
        return realSize.y;
    }

    @TargetApi(value=17)
    public int getWindowWidth(Activity activity) {
        Point realSize = new Point();
        activity.getWindowManager().getDefaultDisplay().getRealSize(realSize);
        return realSize.x;
    }

    public void translateAnimation(View view, float fromX, float toX, float fromY, float toY, long duration, Animation.AnimationListener animationListener, boolean isFillAfter) {
        this.mTranslateAnimation = new TranslateAnimation(1, fromX, 1, toX, 1, fromY, 1, toY);
        this.mTranslateAnimation.setDuration(duration);
        this.mTranslateAnimation.setFillAfter(isFillAfter);
        if (animationListener != null) {
            this.mTranslateAnimation.setAnimationListener(animationListener);
        }
        view.startAnimation((Animation)this.mTranslateAnimation);
    }

    public void translateAnimationWithAbsolute(View view, float fromAlpha, float toAlpha, long alaphDuration, long startTime, float fromX, float toX, float fromY, float toY, long translateDuration, long animationSetDuration, Animation.AnimationListener animationListener, boolean isFillAfter) {
        AnimationSet animationSet = new AnimationSet(true);
        AlphaAnimation animationa = new AlphaAnimation(fromAlpha, toAlpha);
        animationa.setDuration(alaphDuration);
        animationa.setStartTime(startTime);
        animationSet.addAnimation((Animation)animationa);
        TranslateAnimation translateAnimation = new TranslateAnimation(0, fromX, 0, toX, 0, fromY, 0, toY);
        translateAnimation.setDuration(translateDuration);
        animationSet.addAnimation((Animation)translateAnimation);
        animationSet.setDuration(animationSetDuration);
        animationSet.setAnimationListener(animationListener);
        animationSet.setFillAfter(isFillAfter);
        view.startAnimation((Animation)animationSet);
    }

    public boolean isTranslateAnimationHasEnded() {
        if (this.mTranslateAnimation == null) {
            return true;
        }
        return this.mTranslateAnimation.hasEnded();
    }

    public final boolean isMap2dStyle(MineMap mineMap) {
        return mineMap.getElevation() == 90.0f;
    }

    public final boolean isMap3dStyle(MineMap mineMap) {
        return mineMap.getElevation() != 90.0f;
    }

    public void doDelayedViewOperate(Runnable runnable, long delayed) {
        this.delayedViewOperateHandler.postDelayed(runnable, delayed);
    }

    public Handler getDelayedViewOperateHandler() {
        return this.delayedViewOperateHandler;
    }

    public void cleanup() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    public final int second2Minute(int secondTime) {
        return (secondTime + 59) / 60;
    }

    public String formatTime(int secondTime) {
        String sTotalTime;
        int minutes = this.second2Minute(secondTime);
        if (minutes < 60) {
            sTotalTime = minutes + "\u5206\u949f";
        } else {
            int remainMin = minutes % 60;
            sTotalTime = minutes / 60 + "\u5c0f\u65f6" + (remainMin == 0 ? "" : remainMin + "\u5206");
        }
        return sTotalTime;
    }

    public String formatDistanceToKm(int distance) {
        String distanceValue = distance >= 100000 || distance % 1000 == 0 ? String.valueOf(distance / 1000) : String.format(Locale.getDefault(), "%.1f", (double)(distance / 100) / 10.0);
        return distanceValue;
    }

    public DistanceBean formatDistance(int distance, boolean isEnglishDistanceUnit) {
        DistanceStringInfo distanceStringInfo = MineNaviUtil.distance2String((int)distance, (int)(isEnglishDistanceUnit ? 3 : 1), (boolean)false);
        String distanceValue = "";
        String distanceUnit = "";
        switch (distanceStringInfo.unit) {
            case 1: {
                distanceUnit = isEnglishDistanceUnit ? "m" : "\u7c73";
                break;
            }
            case 2: {
                distanceUnit = isEnglishDistanceUnit ? "km" : "\u516c\u91cc";
                break;
            }
            case 3: {
                distanceUnit = isEnglishDistanceUnit ? "mile" : "\u82f1\u91cc";
                break;
            }
            case 4: {
                distanceUnit = isEnglishDistanceUnit ? "ft" : "\u82f1\u5c3a";
            }
        }
        distanceValue = distanceStringInfo.distanceString.split(distanceUnit)[0];
        return new DistanceBean(distanceValue, distanceUnit);
    }

    public TimeBean calcTimeBean(int time) {
        int totalMinute = (time + 59) / 60;
        int timeHour = totalMinute / 60;
        int timeMinute = totalMinute % 60;
        return new TimeBean(timeHour, timeMinute);
    }

    public void enableInputMethod(boolean enable, EditText editText) {
        InputMethodManager inputManager = (InputMethodManager)this.mContext.getSystemService("input_method");
        if (enable) {
            inputManager.toggleSoftInput(0, 2);
        } else {
            inputManager.hideSoftInputFromWindow(editText.getWindowToken(), 0);
        }
    }

    public void enableInputMethodWithFocus(boolean enable, EditText editText) {
        InputMethodManager inputManager = (InputMethodManager)this.mContext.getSystemService("input_method");
        editText.setFocusable(enable);
        editText.setFocusableInTouchMode(enable);
        editText.requestFocus();
        if (enable) {
            editText.requestFocus();
            inputManager.showSoftInput((View)editText, 0);
        } else {
            inputManager.hideSoftInputFromWindow(editText.getWindowToken(), 0);
        }
    }

    public void setSelectionEnd(EditText editText) {
        if (editText != null) {
            String b = editText.getText().toString();
            editText.setSelection(b.length());
        }
    }

    public void hideKeyboard(Context context) {
        Activity activity = (Activity)context;
        InputMethodManager imm = (InputMethodManager)this.mContext.getSystemService("input_method");
        View v = activity.getWindow().peekDecorView();
        if (null != v) {
            imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
        }
    }

    public String getStrDistance(Point point1, Point point2) {
        int distance = MineNaviUtil.distance((Point)point1, (Point)point2);
        return MineNaviUtil.distance2String((int)distance, (int)1, (boolean)false).distanceString;
    }

    public int dp2Px(float dp) {
        return (int)(dp * this.mDpiFactor + 0.5f);
    }

    public int px2Dp(int px) {
        return (int)((float)px / this.mDpiFactor + 0.5f);
    }

    public boolean is24Hour() {
        return DateFormat.is24HourFormat((Context)this.mContext);
    }

    public String formatTrafficDataSize(long size) {
        if (size < 1024L) {
            return size + "B";
        }
        if (size < 0x100000L) {
            return size / 1024L + "KB";
        }
        if (size < 0xA00000L) {
            return String.format("%.1fM", (double)size / 1048576.0);
        }
        if (size < 0x40000000L) {
            return size / 0x100000L + "MB";
        }
        return String.format("%.1fGB", (double)size / 1.073741824E9);
    }

    public String getVerName() {
        String verName = "";
        try {
            verName = this.mPackageManager.getPackageInfo((String)this.mApplicationContext.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return verName;
    }

    public int getVersionCode() {
        int versionCode = 0;
        try {
            versionCode = this.mPackageManager.getPackageInfo((String)this.mApplicationContext.getPackageName(), (int)0).versionCode;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return versionCode;
    }

    public String getAppName() {
        String appName = "";
        try {
            PackageInfo packageInfo = this.mPackageManager.getPackageInfo(this.mApplicationContext.getPackageName(), 0);
            appName = packageInfo.applicationInfo.loadLabel(this.mPackageManager).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return appName;
    }

    public String toDBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public void showToast(Context context, String msg) {
        Toast toast = Toast.makeText((Context)context, (CharSequence)msg, (int)0);
        toast.setText((CharSequence)msg);
        toast.show();
    }

    public void scheduleTimerTask(TimerTask timerTask, long time) {
        if (this.mTimer != null && timerTask != null) {
            this.mTimer.schedule(timerTask, time);
        }
    }

    public String getCurrentStoragePathSuffix() {
        String suffix = "";
        if (this.isTestVersion()) {
            suffix = "/mapbar/NaviZero";
        } else if (this.isReleaseVersion()) {
            suffix = "/mapbar/NaviZeroRelease";
        }
        return suffix;
    }

    public boolean isTestVersion() {
        String packageName = this.mContext.getPackageName();
        return TextUtils.equals((CharSequence)"com.mapbar.navigation.zero", (CharSequence)packageName);
    }

    public boolean isReleaseVersion() {
        String packageName = this.mContext.getPackageName();
        return TextUtils.equals((CharSequence)"com.mapbar.navigation.zero.release", (CharSequence)packageName);
    }

    public String getLoginAppName() {
        return this.isTestVersion() ? "naviZeroBeta" : "naviZeroRelease";
    }

    public long getSdcardAvailableSize(String sdcardPath) {
        long size = 0L;
        StatFs statFs = new StatFs(sdcardPath);
        int blockSize = statFs.getBlockSize();
        int totalBlocks = statFs.getBlockCount();
        size = (long)totalBlocks * (long)blockSize;
        return size;
    }

    public float getTotalRam(Context context) {
        String path = "/proc/meminfo";
        String firstLine = null;
        float totalRam = 0.0f;
        try {
            FileReader fileReader = new FileReader(path);
            BufferedReader br = new BufferedReader(fileReader, 8192);
            firstLine = br.readLine().split("\\s+")[1];
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (firstLine != null) {
            totalRam = Float.valueOf(firstLine).floatValue() / 1048576.0f;
        }
        return totalRam;
    }

    public Bitmap createCircleBitmap(Bitmap resource) {
        int width = resource.getWidth();
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        Bitmap circleBitmap = Bitmap.createBitmap((int)width, (int)width, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(circleBitmap);
        canvas.drawCircle((float)(width / 2), (float)(width / 2), (float)(width / 2), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(resource, 0.0f, 0.0f, paint);
        return circleBitmap;
    }

    public String formatLocalDate(String date) {
        if (this.mSimpleDateFormat == null) {
            this.mSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        Date localDate = null;
        try {
            localDate = this.mSimpleDateFormat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        long localTimeInMillis = localDate.getTime() + 28800000L;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(localTimeInMillis);
        return this.mSimpleDateFormat.format(calendar.getTime());
    }

    public static String sha1Digest(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("SHA1");
            mdTemp.update(str.getBytes("UTF-8"));
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] buf = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                buf[k++] = hexDigits[byte0 >>> 4 & 0xF];
                buf[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(buf);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String randomString() {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 10; ++i) {
            int number = random.nextInt(str.length());
            char charAt = str.charAt(number);
            sb.append(charAt);
        }
        return sb.toString();
    }

    public void enableHorizontalAndVerticalScreenMode(Activity activity, boolean isOpen) {
        activity.setRequestedOrientation(isOpen ? -1 : 1);
    }

    public void enableHorizontalAndVerticalScreenMode(boolean isOpen) {
        this.enableHorizontalAndVerticalScreenMode((Activity)this.mContext, isOpen);
    }

    public boolean isHaveNetwork() {
        int netWorkState = NativeEnv.getNetworkStatus((Context)this.mContext);
        return netWorkState != 1;
    }

    public boolean isNumber(String str) {
        int i = str.length();
        while (--i >= 0) {
            char chr = str.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    public static String string2MD5(String inStr) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return "";
        }
        byte[] md5Bytes = md5.digest(inStr.getBytes());
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; ++i) {
            int val = md5Bytes[i] & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString().toUpperCase();
    }

    public static String base64(String str) {
        return Base64.encodeToString((byte[])str.getBytes(), (int)0);
    }

    public static String location2String(Point pt) {
        return String.format("%.5f,%.5f", (double)pt.x / 100000.0, (double)pt.y / 100000.0);
    }

    public static Point string2Location(String str) {
        try {
            String[] parts = str.split(",");
            return new Point((int)(Float.valueOf(parts[0]).floatValue() * 100000.0f), (int)(Float.valueOf(parts[1]).floatValue() * 100000.0f));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class SingletonHolder {
        public static final Utils instance = new Utils();

        private SingletonHolder() {
        }
    }
}

