/*
 * Decompiled with CFR 0.152.
 */
package com.sd.api.utils;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.animation.LinearInterpolator;
import com.minedata.minenavi.mapdal.LatLng;

public class SmoothMoveUtils {
    public static void startSmoothMove(LatLng from, LatLng to, long durationMillis, final OnPositionUpdateListener listener) {
        if (from == null || to == null || listener == null || durationMillis <= 0L) {
            return;
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.setDuration(durationMillis);
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        float bearing = SmoothMoveUtils.calculateBearing(from, to);
        animator.addUpdateListener(animation -> {
            float fraction = ((Float)animation.getAnimatedValue()).floatValue();
            double lat = from.latitude + (to.latitude - from.latitude) * (double)fraction;
            double lng = from.longitude + (to.longitude - from.longitude) * (double)fraction;
            LatLng interpolated = new LatLng(lat, lng);
            listener.onUpdate(interpolated, bearing);
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                listener.onFinish();
            }
        });
        animator.start();
    }

    private static float calculateBearing(LatLng from, LatLng to) {
        double lat1 = Math.toRadians(from.latitude);
        double lon1 = Math.toRadians(from.longitude);
        double lat2 = Math.toRadians(to.latitude);
        double lon2 = Math.toRadians(to.longitude);
        double dLon = lon2 - lon1;
        double y = Math.sin(dLon) * Math.cos(lat2);
        double x = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(dLon);
        double bearingRad = Math.atan2(y, x);
        return (float)((Math.toDegrees(bearingRad) + 360.0) % 360.0);
    }

    public static interface OnPositionUpdateListener {
        public void onUpdate(LatLng var1, float var2);

        public void onFinish();
    }
}

