/*
 * Decompiled with CFR 0.152.
 */
package com.sd.api.utils;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.res.AssetManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010\u000bJ,\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0086@\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007J*\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0016J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\u001f\u001a\u00020\u001e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0016H\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'\u00a8\u0006("}, d2={"Lcom/sd/api/utils/FileIoUtils;", "", "<init>", "()V", "getAssetContent", "", "context", "Landroid/content/Context;", "fileName", "assetFilePath", "assetName", "(Landroid/content/Context;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAssetMock", "", "dst", "", "(Landroid/content/Context;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAsset", "getAbsoluteImagePath", "contentUri", "Landroid/net/Uri;", "copyHeImgFileToPath", "Ljava/io/File;", "source", "isRemove", "", "readFileToByte", "", "file", "getTotalCacheSize", "", "getFolderSize", "deleteTotalCacheSize", "", "getFormatSize", "size", "", "saveBitmapToGalley", "bitmap", "Landroid/graphics/Bitmap;", "mapapi_debug"})
@SourceDebugExtension(value={"SMAP\nFileIoUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileIoUtils.kt\ncom/sd/api/utils/FileIoUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,370:1\n1#2:371\n*E\n"})
public final class FileIoUtils {
    @NotNull
    public static final FileIoUtils INSTANCE = new FileIoUtils();

    private FileIoUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getAssetContent(@NotNull Context context, @NotNull String fileName) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        AssetManager assetManager = context.getAssets();
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bf = null;
        try {
            InputStreamReader inputReader = new InputStreamReader(assetManager.open(fileName));
            bf = new BufferedReader(inputReader);
            Ref.ObjectRef line = new Ref.ObjectRef();
            line.element = "";
            while (true) {
                BufferedReader $this$getAssetContent_u24lambda_u240 = bf;
                boolean bl = false;
                line.element = $this$getAssetContent_u24lambda_u240.readLine();
                charSequence = (String)line.element;
                if (charSequence == null || charSequence.length() == 0) break;
                stringBuilder.append((String)line.element);
            }
            bf.close();
            assetManager.close();
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            charSequence = string;
            bf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            BufferedReader bufferedReader = bf;
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            assetManager.close();
        }
        assetManager.close();
        return charSequence;
    }

    @Nullable
    public final Object assetFilePath(@NotNull Context context, @NotNull String assetName, @NotNull Continuation<? super String> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(context, assetName, null){
            int label;
            final /* synthetic */ Context $context;
            final /* synthetic */ String $assetName;
            {
                this.$context = $context;
                this.$assetName = $assetName;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        File file = new File(this.$context.getFilesDir(), this.$assetName);
                        if (file.exists() && file.length() > 0L) {
                            String string = file.getAbsolutePath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                            return string;
                        }
                        try {
                            InputStream inputStream = this.$context.getAssets().open(this.$assetName);
                            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"open(...)");
                            InputStream inputs = inputStream;
                            OutputStream os = new FileOutputStream(file);
                            byte[] buffer = new byte[4096];
                            int read = 0;
                            while (true) {
                                int n;
                                int it = n = inputs.read(buffer);
                                boolean bl = false;
                                read = it;
                                if (n == -1) break;
                                os.write(buffer, 0, read);
                            }
                            os.flush();
                            String string = file.getAbsolutePath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                            return string;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return "";
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object getAssetMock(@NotNull Context context, @NotNull String fileName, @NotNull List<String> dst, @NotNull Continuation<? super Integer> $completion) {
        AssetManager assetManager = context.getAssets();
        BufferedReader bf = null;
        try {
            Object object;
            InputStreamReader inputReader = new InputStreamReader(assetManager.open(fileName));
            bf = new BufferedReader(inputReader);
            Ref.ObjectRef line = new Ref.ObjectRef();
            line.element = "";
            while (true) {
                BufferedReader $this$getAssetMock_u24lambda_u241 = bf;
                boolean bl = false;
                line.element = $this$getAssetMock_u24lambda_u241.readLine();
                object = (String)line.element;
                if (object == null || object.length() == 0) break;
                dst.add((String)line.element);
            }
            bf.close();
            object = Boxing.boxInt((int)1);
            bf.close();
            return object;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            BufferedReader bufferedReader = bf;
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return Boxing.boxInt((int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getAsset(@NotNull Context context, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        AssetManager assetManager = context.getAssets();
        InputStream inputStream = null;
        String str = "";
        try {
            inputStream = assetManager.open(fileName);
            int size = inputStream.available();
            byte[] bytes = new byte[size];
            inputStream.read(bytes);
            str = new String(bytes, Charsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            InputStream inputStream2 = inputStream;
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
        return str;
    }

    @NotNull
    public final String getAbsoluteImagePath(@NotNull Uri contentUri, @NotNull Context context) {
        Cursor cursor;
        Intrinsics.checkNotNullParameter((Object)contentUri, (String)"contentUri");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String res = "";
        String[] stringArray = new String[]{"_data"};
        String[] proj = stringArray;
        Cursor cursor2 = cursor = context.getContentResolver().query(contentUri, proj, null, null, null);
        Intrinsics.checkNotNull((Object)cursor2);
        if (cursor2.moveToFirst()) {
            int column_index = cursor.getColumnIndexOrThrow("_data");
            res = cursor.getString(column_index);
        }
        cursor.close();
        return res;
    }

    @Nullable
    public final File copyHeImgFileToPath(@NotNull Context context, @NotNull String fileName, @NotNull File source, boolean isRemove) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            File dir = new File(context.getExternalCacheDir(), "xunhepic");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File imgFile = new File(dir, fileName);
            if (!dir.exists()) {
                imgFile.createNewFile();
            }
            FileInputStream fosfrom = new FileInputStream(source);
            FileOutputStream fosto = new FileOutputStream(imgFile);
            byte[] bt = null;
            bt = new byte[1024];
            int c = 0;
            while (true) {
                FileInputStream $this$copyHeImgFileToPath_u24lambda_u242 = fosfrom;
                boolean bl = false;
                c = $this$copyHeImgFileToPath_u24lambda_u242.read(bt);
                if (c <= 0) break;
                fosto.write(bt, 0, c);
            }
            if (isRemove) {
                // empty if block
            }
            fosfrom.close();
            fosto.close();
            return imgFile;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static /* synthetic */ File copyHeImgFileToPath$default(FileIoUtils fileIoUtils, Context context, String string, File file, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return fileIoUtils.copyHeImgFileToPath(context, string, file, bl);
    }

    @Nullable
    public final byte[] readFileToByte(@Nullable File file) {
        int byte_size = 1024;
        byte[] b = new byte[byte_size];
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(byte_size);
            int length = 0;
            while (true) {
                int n;
                int it = n = fileInputStream.read(b);
                boolean bl = false;
                length = it;
                if (n == -1) break;
                outputStream.write(b, 0, length);
            }
            fileInputStream.close();
            outputStream.close();
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public final long getTotalCacheSize(@NotNull Context context) {
        long l;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        long size = 0L;
        try {
            size = this.getFolderSize(context.getCacheDir());
            l = size += this.getFolderSize(context.getFilesDir());
        }
        catch (Exception e) {
            e.printStackTrace();
            l = 0L;
        }
        return l;
    }

    private final long getFolderSize(File file) {
        if (file == null) {
            return 0L;
        }
        long size = 0L;
        try {
            File[] fileList = file.listFiles();
            int n = fileList.length;
            for (int i = 0; i < n; ++i) {
                size = fileList[i].isDirectory() ? size + this.getFolderSize(fileList[i]) : size + fileList[i].length();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public final void deleteTotalCacheSize(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(context, null){
            int label;
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.$context, null){
                            int label;
                            final /* synthetic */ Context $context;
                            {
                                this.$context = $context;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.$context, null){
                                            int label;
                                            final /* synthetic */ Context $context;
                                            {
                                                this.$context = $context;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        File file = this.$context.getCacheDir();
                                                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getCacheDir(...)");
                                                        FilesKt.deleteRecursively((File)file);
                                                        File file2 = this.$context.getFilesDir();
                                                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getFilesDir(...)");
                                                        return Boxing.boxBoolean((boolean)FilesKt.deleteRecursively((File)file2));
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Nullable
    public final String getFormatSize(double size) {
        double kiloByte = size / (double)1024;
        if (kiloByte < 1.0) {
            return size + "Byte";
        }
        double megaByte = kiloByte / (double)1024;
        if (megaByte < 1.0) {
            BigDecimal result1 = new BigDecimal(String.valueOf(kiloByte));
            return result1.setScale(2, 4).toPlainString() + "KB";
        }
        double gigaByte = megaByte / (double)1024;
        if (gigaByte < 1.0) {
            BigDecimal result2 = new BigDecimal(String.valueOf(megaByte));
            return result2.setScale(1, 4).toPlainString() + "MB";
        }
        double teraBytes = gigaByte / (double)1024;
        if (teraBytes < 1.0) {
            BigDecimal result3 = new BigDecimal(String.valueOf(gigaByte));
            return result3.setScale(2, 4).toPlainString() + "GB";
        }
        BigDecimal result4 = new BigDecimal(teraBytes);
        return result4.setScale(2, 4).toPlainString() + "TB";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void saveBitmapToGalley(@NotNull Context context, @NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        try {
            File parentDir = null;
            if (Build.VERSION.SDK_INT >= 29) {
                if (!Environment.getExternalStorageState().equals("mounted")) return;
                File file = context.getExternalFilesDir(Environment.DIRECTORY_DCIM);
                Intrinsics.checkNotNull((Object)file);
                parentDir = file;
            } else {
                parentDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
            }
            String fileName = "firend.jpg";
            File file = new File(parentDir, fileName);
            ContentValues contentValues = new ContentValues();
            contentValues.put("_display_name", fileName);
            contentValues.put("mime_type", "image/JPEG");
            if (Build.VERSION.SDK_INT >= 29) {
                OutputStream outputStream;
                contentValues.put("relative_path", Environment.DIRECTORY_DCIM);
                Uri uri = context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
                if (uri == null || (outputStream = context.getContentResolver().openOutputStream(uri)) == null) return;
                bitmap.compress(Bitmap.CompressFormat.JPEG, 90, outputStream);
                outputStream.flush();
                outputStream.close();
                return;
            } else {
                contentValues.put("_data", Environment.DIRECTORY_DCIM);
                MediaStore.Images.Media.insertImage((ContentResolver)context.getContentResolver(), (Bitmap)bitmap, (String)fileName, null);
                FileOutputStream outputStream = new FileOutputStream(file);
                boolean bl = file.exists() ? file.delete() : file.createNewFile();
                bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)outputStream);
                outputStream.flush();
                outputStream.close();
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

