/*
 * Decompiled with CFR 0.152.
 */
package com.sd.api.utils;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u000e\u001a\u00020\u0005J\u0006\u0010\u000f\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/sd/api/utils/DisplayUtil;", "", "<init>", "()V", "getDpi", "", "px2dp", "pxValue", "", "dp2px", "dipValue", "px2sp", "sp2px", "spValue", "getScreenWidthDp", "getScreenWidthPx", "getScreenHeightDp", "getScreenHeightPx", "forceMeasure", "", "view", "Landroid/view/View;", "mTmpValue", "Landroid/util/TypedValue;", "getXmlDef", "context", "Landroid/content/Context;", "id", "getNavigationBarHeight", "hasNavBar", "", "activity", "Landroid/app/Activity;", "getInternalDimensionSize", "key", "", "mapapi_debug"})
public final class DisplayUtil {
    @NotNull
    public static final DisplayUtil INSTANCE = new DisplayUtil();
    @NotNull
    private static final TypedValue mTmpValue = new TypedValue();

    private DisplayUtil() {
    }

    public final int getDpi() {
        return Resources.getSystem().getDisplayMetrics().densityDpi;
    }

    public final int px2dp(float pxValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public final int dp2px(float dipValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public final int px2sp(float pxValue) {
        float fontScale = Resources.getSystem().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public final int sp2px(float spValue) {
        float fontScale = Resources.getSystem().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public final int getScreenWidthDp() {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        int widthPixels = displayMetrics.widthPixels;
        float density = displayMetrics.density;
        return Math.round((float)widthPixels / density);
    }

    public final int getScreenWidthPx() {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        return displayMetrics.widthPixels;
    }

    public final int getScreenHeightDp() {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        int heightPixels = displayMetrics.heightPixels;
        float density = displayMetrics.density;
        return Math.round((float)heightPixels / density);
    }

    public final int getScreenHeightPx() {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        return displayMetrics.heightPixels;
    }

    public final void forceMeasure(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(widthMeasureSpec, heightMeasureSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getXmlDef(@NotNull Context context, int id2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TypedValue typedValue = mTmpValue;
        synchronized (typedValue) {
            boolean bl = false;
            TypedValue value = mTmpValue;
            context.getResources().getValue(id2, value, true);
            int n = (int)TypedValue.complexToFloat((int)value.data);
            return n;
        }
    }

    public final int getNavigationBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean mInPortrait = context.getResources().getConfiguration().orientation == 1;
        int result = 0;
        if (Build.VERSION.SDK_INT >= 14 && this.hasNavBar((Activity)context)) {
            String key = null;
            key = mInPortrait ? "navigation_bar_height" : "navigation_bar_height_landscape";
            return this.getInternalDimensionSize(context, key);
        }
        return result;
    }

    private final boolean hasNavBar(Activity activity) {
        if (Build.VERSION.SDK_INT >= 17 && Settings.Global.getInt((ContentResolver)activity.getContentResolver(), (String)"force_fsg_nav_bar", (int)0) != 0) {
            return false;
        }
        WindowManager windowManager = activity.getWindowManager();
        Display d = windowManager.getDefaultDisplay();
        DisplayMetrics realDisplayMetrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            d.getRealMetrics(realDisplayMetrics);
        }
        int realHeight = realDisplayMetrics.heightPixels;
        int realWidth = realDisplayMetrics.widthPixels;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        d.getMetrics(displayMetrics);
        int displayHeight = displayMetrics.heightPixels;
        int displayWidth = displayMetrics.widthPixels;
        return realWidth - displayWidth > 0 || realHeight - displayHeight > 0;
    }

    private final int getInternalDimensionSize(Context context, String key) {
        int result = 0;
        try {
            int resourceId = context.getResources().getIdentifier(key, "dimen", "android");
            if (resourceId > 0) {
                result = Math.round((float)context.getResources().getDimensionPixelSize(resourceId) * Resources.getSystem().getDisplayMetrics().density / context.getResources().getDisplayMetrics().density);
            }
        }
        catch (Resources.NotFoundException ignored) {
            return 0;
        }
        return result;
    }
}

