/*
 * Decompiled with CFR 0.152.
 */
package com.sd.api.ui.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.minedata.minenavi.navi.TmcSections;
import com.sd.api.R;
import com.sd.api.ui.widget.TmcBarSegment;
import com.sd.api.utils.DisplayUtil;
import java.util.ArrayList;

public class TmcBar
extends RelativeLayout {
    private final String TAG = "[TmcBar]";
    private Paint mDrawContentPaint;
    private Paint mPublicPaint;
    TmcSections mTmcSections;
    ArrayList<TmcBarSegment> mTmcBarSegments = new ArrayList();
    private Bitmap mCarIcon = null;
    private int mDrawPadding = 3;
    private float mBigCircleRadius = 0.0f;
    private float mSmallCircleRadius = 0.0f;
    Path mClipPath = null;
    private float mRatio = 0.0f;
    private Bitmap mSavedTmcMap = null;
    private boolean mIsTmcUpdated = true;
    private int mWidth = -1;
    private int mHeight = -1;
    private boolean mIsCarIconWidthInited;
    private int mCarIconHeight = 0;
    private int mCarIconWidth = 0;
    private float mHalfCarIconHeight = 0.0f;
    private float mHalfCarIconWidget = 0.0f;
    private float mTopBottomArcAngle;

    public TmcBar(Context context) {
        this(context, null);
    }

    public TmcBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TmcBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mDrawPadding = this.getPaddingLeft();
        this.mCarIcon = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.my_small_car);
        this.initPaint();
    }

    private void initPaint() {
        this.mPublicPaint = new Paint();
        this.mDrawContentPaint = new Paint();
    }

    public void setTmcSections(TmcSections tmcSections) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (height < width) {
            this.mTmcSections = tmcSections;
            int[] tempPixels = this.mTmcSections.pixels;
            int[] pixels = new int[tempPixels.length];
            for (int i = 0; i < tempPixels.length; ++i) {
                pixels[i] = width * tempPixels[i] / 100;
            }
            int[] states = this.mTmcSections.states;
            this.mTmcBarSegments.clear();
            for (int i = 0; i < this.mTmcSections.length; ++i) {
                RectF rect;
                TmcBarSegment tmcBarSegment = new TmcBarSegment();
                tmcBarSegment.colorStates = states[i];
                int left = i > 0 ? pixels[i - 1] : 0;
                boolean top = false;
                int right = pixels[i];
                int bottom = height;
                tmcBarSegment.rect = rect = new RectF((float)left, (float)top, (float)right, (float)bottom);
                this.mTmcBarSegments.add(tmcBarSegment);
            }
        } else {
            this.mIsTmcUpdated = true;
            if (this.getWidth() != this.mWidth || this.getHeight() != this.mHeight) {
                this.reMeasure();
            }
            if (tmcSections.pixels.length == 0) {
                this.mTmcSections = new TmcSections(new int[]{this.mHeight}, new int[]{0});
            }
            this.mTmcSections = tmcSections;
            int[] tempPixels = new int[this.mTmcSections.pixels.length];
            for (int i = 0; i < tmcSections.length; ++i) {
                tempPixels[i] = tmcSections.pixels[i] * this.getHeight() / 100;
            }
            float[] pixels = new float[tempPixels.length];
            float totalPixels = tempPixels[tempPixels.length - 1];
            for (int i = 0; i < tempPixels.length; ++i) {
                pixels[i] = (float)tempPixels[i] / totalPixels * 1.0f;
            }
            int[] states = this.mTmcSections.states;
            this.mTmcBarSegments.clear();
            float totalHeight = height - this.mCarIconHeight;
            for (int i = 0; i < this.mTmcSections.length; ++i) {
                RectF rect;
                TmcBarSegment tmcBarSegment = new TmcBarSegment();
                tmcBarSegment.colorStates = states[i];
                float from = i == 0 ? 0.0f : totalHeight * pixels[i - 1];
                float lengthRate = i == 0 ? pixels[0] : pixels[i] - pixels[i - 1];
                float left = this.mDrawPadding;
                float top = (float)height - lengthRate * totalHeight - this.mHalfCarIconHeight - from;
                float right = width - this.mDrawPadding;
                float bottom = top + lengthRate * totalHeight;
                tmcBarSegment.rect = rect = new RectF(left, top, right, bottom);
                this.mTmcBarSegments.add(tmcBarSegment);
            }
        }
        this.invalidate();
    }

    public void setTmcBarArcAngle(int arcAngle) {
        this.mTopBottomArcAngle = DisplayUtil.INSTANCE.dp2px(arcAngle);
        this.reMeasure();
        this.invalidate();
    }

    public void setDrawPadding(int drawPadding) {
        this.mDrawPadding = drawPadding;
        this.reMeasure();
        this.invalidate();
    }

    private void drawTmcMap2Bitmap(Canvas canvas) {
        this.mPublicPaint.reset();
        this.mPublicPaint.setColor(-1);
        float centerX = 0.5f * (float)this.mWidth;
        float topBottomArcAngle = this.mTopBottomArcAngle == 0.0f || this.mTopBottomArcAngle > (float)this.mWidth ? centerX : this.mTopBottomArcAngle;
        float topCircleX = centerX;
        float topCircleY = this.mHalfCarIconHeight + this.mSmallCircleRadius;
        float bottomCircleX = centerX;
        float bottomCircleY = (float)this.mHeight - (this.mHalfCarIconHeight + this.mSmallCircleRadius);
        RectF topRectF = new RectF(topCircleX - this.mBigCircleRadius, topCircleY - this.mBigCircleRadius, centerX + this.mBigCircleRadius, topCircleY + this.mBigCircleRadius);
        canvas.drawRoundRect(topRectF, topBottomArcAngle, topBottomArcAngle, this.mPublicPaint);
        RectF bottomRectF = new RectF(bottomCircleX - this.mBigCircleRadius, bottomCircleY - this.mSmallCircleRadius, bottomCircleX + this.mBigCircleRadius, bottomCircleY + this.mSmallCircleRadius + (float)this.mDrawPadding);
        canvas.drawRoundRect(bottomRectF, topBottomArcAngle, topBottomArcAngle, this.mPublicPaint);
        RectF rectF = new RectF(0.0f, this.mHalfCarIconHeight + this.mSmallCircleRadius, (float)this.mWidth, (float)this.mHeight - (this.mHalfCarIconHeight + this.mSmallCircleRadius));
        canvas.drawRect(rectF, this.mPublicPaint);
        canvas.save();
        canvas.clipPath(this.mClipPath, Region.Op.DIFFERENCE);
        for (int i = 0; i < this.mTmcBarSegments.size(); ++i) {
            TmcBarSegment tmcBarSegment = this.mTmcBarSegments.get(i);
            canvas.drawRect(tmcBarSegment.rect, this.getPaint(tmcBarSegment.colorStates));
        }
        canvas.restore();
    }

    private void reMeasure() {
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        this.mBigCircleRadius = 0.5f * (float)this.mWidth;
        this.mSmallCircleRadius = this.mBigCircleRadius - (float)this.mDrawPadding;
        float center = 0.5f * (float)this.mWidth;
        float topBottomArcAngle = this.mTopBottomArcAngle == 0.0f || this.mTopBottomArcAngle > (float)this.mWidth ? center : this.mTopBottomArcAngle;
        this.mClipPath = new Path();
        Path temPath = new Path();
        RectF rectTop = new RectF(0.0f, 0.0f, (float)this.mWidth, this.mHalfCarIconHeight + this.mSmallCircleRadius);
        RectF rectBottom = new RectF(0.0f, (float)this.mHeight - (this.mHalfCarIconHeight + this.mSmallCircleRadius), (float)this.mWidth, (float)this.mHeight);
        this.mClipPath.addRect(rectTop, Path.Direction.CW);
        this.mClipPath.addRect(rectBottom, Path.Direction.CW);
        float topCircleX = center;
        float topCircleY = this.mHalfCarIconHeight + this.mSmallCircleRadius;
        float bottomCircleX = center;
        float bottomCircleY = (float)this.mHeight - (this.mHalfCarIconHeight + this.mSmallCircleRadius);
        RectF topRectF = new RectF(topCircleX - this.mSmallCircleRadius, topCircleY - this.mSmallCircleRadius, topCircleX + this.mSmallCircleRadius, topCircleY + this.mSmallCircleRadius);
        RectF bottomRectF = new RectF(bottomCircleX - this.mSmallCircleRadius, bottomCircleY - this.mSmallCircleRadius, bottomCircleX + this.mSmallCircleRadius, bottomCircleY + this.mSmallCircleRadius);
        temPath.addRoundRect(topRectF, topBottomArcAngle, topBottomArcAngle, Path.Direction.CW);
        temPath.addRoundRect(bottomRectF, topBottomArcAngle, topBottomArcAngle, Path.Direction.CW);
        if (Build.VERSION.SDK_INT >= 19) {
            this.mClipPath.op(temPath, Path.Op.DIFFERENCE);
        }
    }

    private void reMeasure_copy() {
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        this.mBigCircleRadius = 0.5f * (float)this.mWidth;
        this.mSmallCircleRadius = this.mBigCircleRadius - (float)this.mDrawPadding;
        float center = 0.5f * (float)this.mWidth;
        float topBottomArcAngle = this.mTopBottomArcAngle == 0.0f || this.mTopBottomArcAngle > (float)this.mWidth ? center : this.mTopBottomArcAngle;
        this.mClipPath = new Path();
        Path temPath = new Path();
        RectF rectTop = new RectF(0.0f, 0.0f, (float)this.mWidth, this.mHalfCarIconHeight + this.mSmallCircleRadius);
        RectF rectBottom = new RectF(0.0f, (float)this.mHeight - (this.mHalfCarIconHeight + this.mSmallCircleRadius), (float)this.mWidth, (float)this.mHeight);
        this.mClipPath.addRect(rectTop, Path.Direction.CW);
        this.mClipPath.addRect(rectBottom, Path.Direction.CW);
        float topCircleX = center;
        float topCircleY = this.mHalfCarIconHeight + this.mSmallCircleRadius;
        float bottomCircleX = center;
        float bottomCircleY = (float)this.mHeight - (this.mHalfCarIconHeight + this.mSmallCircleRadius);
        RectF topRectF = new RectF(topCircleX - this.mSmallCircleRadius, topCircleY - this.mSmallCircleRadius, topCircleX + this.mSmallCircleRadius, topCircleY + this.mSmallCircleRadius);
        RectF bottomRectF = new RectF(bottomCircleX - this.mSmallCircleRadius, bottomCircleY - this.mSmallCircleRadius, bottomCircleX + this.mSmallCircleRadius, bottomCircleY + this.mSmallCircleRadius);
        temPath.addRoundRect(topRectF, topBottomArcAngle, topBottomArcAngle, Path.Direction.CW);
        temPath.addRoundRect(bottomRectF, topBottomArcAngle, topBottomArcAngle, Path.Direction.CW);
        if (Build.VERSION.SDK_INT >= 19) {
            this.mClipPath.op(temPath, Path.Op.DIFFERENCE);
        }
    }

    public void updateRatio(float ratio) {
        if ((int)(this.mRatio * 1000.0f) == (int)(ratio * 1000.0f) && ratio != 0.0f) {
            return;
        }
        this.mRatio = ratio;
        this.invalidate();
    }

    public void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        if (this.mTmcBarSegments.size() == 0) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        if (height < width) {
            for (int i = 0; i < this.mTmcBarSegments.size(); ++i) {
                TmcBarSegment tmcBarSegment = this.mTmcBarSegments.get(i);
                canvas.drawRect(tmcBarSegment.rect, this.getPaint(tmcBarSegment.colorStates));
            }
            if (this.mTmcBarSegments.size() == 0) {
                return;
            }
        } else {
            if (this.mTmcBarSegments.size() == 0) {
                return;
            }
            this.drawCar(canvas, height, width);
        }
    }

    private void drawCar(Canvas canvas, int height, int width) {
        if (height < width) {
            float scaleHeight;
            int originalCarIconWidth = this.mCarIcon.getWidth();
            int originalCarIconHeight = this.mCarIcon.getHeight();
            float scaleWidth = scaleHeight = (float)Math.round(height * 10 / originalCarIconHeight) / 10.0f;
            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            this.mCarIcon = Bitmap.createBitmap((Bitmap)this.mCarIcon, (int)0, (int)0, (int)originalCarIconWidth, (int)originalCarIconHeight, (Matrix)matrix, (boolean)true);
            this.mHalfCarIconWidget = (float)this.mCarIcon.getWidth() * 0.5f;
            this.mHalfCarIconHeight = (float)this.mCarIcon.getHeight() * 0.5f;
            canvas.save();
            canvas.translate(this.mHalfCarIconWidget, this.mHalfCarIconHeight);
            float offsetWidth = this.mRatio * (float)width;
            int left = -this.mCarIcon.getWidth();
            canvas.drawBitmap(this.mCarIcon, (float)left + offsetWidth, -this.mHalfCarIconHeight, null);
            this.mPublicPaint.reset();
            this.mPublicPaint.setColor(-7829368);
            RectF grayRectF = new RectF((float)left, -this.mHalfCarIconHeight, (float)left + offsetWidth + (float)this.mCarIcon.getWidth(), -this.mHalfCarIconHeight);
            canvas.drawRect(grayRectF, this.mPublicPaint);
            canvas.restore();
        } else {
            if (!this.mIsCarIconWidthInited) {
                float scaleWidth;
                int originalCarIconWidth = this.mCarIcon.getWidth();
                int originalCarIconHeight = this.mCarIcon.getHeight();
                float scaleHeight = scaleWidth = (float)Math.round(width * 10 / originalCarIconWidth) / 10.0f;
                Matrix matrix = new Matrix();
                matrix.postScale(scaleWidth, scaleHeight);
                this.mCarIcon = Bitmap.createBitmap((Bitmap)this.mCarIcon, (int)0, (int)0, (int)originalCarIconWidth, (int)originalCarIconHeight, (Matrix)matrix, (boolean)true);
                this.mCarIconHeight = this.mCarIcon.getHeight();
                this.mCarIconWidth = this.mCarIcon.getWidth();
                this.mHalfCarIconHeight = 0.5f * (float)this.mCarIconHeight;
                this.reMeasure();
                this.mIsCarIconWidthInited = true;
            }
            if (this.getWidth() != this.mWidth || this.getHeight() != this.mHeight) {
                this.reMeasure();
            }
            if (this.mIsTmcUpdated) {
                this.mSavedTmcMap = Bitmap.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas temCanvas = new Canvas(this.mSavedTmcMap);
                this.drawTmcMap2Bitmap(temCanvas);
                this.mIsTmcUpdated = false;
            }
            this.mPublicPaint.reset();
            Rect src = new Rect(0, 0, this.mWidth, this.mHeight);
            canvas.drawBitmap(this.mSavedTmcMap, src, src, this.mPublicPaint);
            this.drawGray(canvas);
            Rect srcIcon = new Rect(0, 0, this.mCarIconWidth, this.mCarIconHeight);
            float totalHeight = this.mHeight - this.mCarIconHeight;
            float from = (float)this.mHeight - this.mHalfCarIconHeight - this.mRatio * totalHeight;
            canvas.drawBitmap(this.mCarIcon, srcIcon, this.getLocRect(from), this.mPublicPaint);
        }
    }

    private void drawGray(Canvas canvas) {
        canvas.save();
        this.mPublicPaint.reset();
        this.mPublicPaint.setColor(-7829368);
        float totalHeight = this.mHeight - this.mCarIconHeight;
        float from = (float)this.mHeight - this.mHalfCarIconHeight - totalHeight * this.mRatio;
        float to = (float)this.mHeight - this.mHalfCarIconHeight - totalHeight * 0.0f;
        float left = this.mDrawPadding;
        float right = (float)this.mWidth - left;
        RectF grayRectF = new RectF(left, from, right, to);
        canvas.clipPath(this.mClipPath, Region.Op.DIFFERENCE);
        canvas.drawRect(grayRectF, this.mPublicPaint);
        canvas.restore();
    }

    private RectF getLocRect(float dot) {
        float left = 0.0f + (float)(this.mWidth - this.mCarIconWidth) / 2.0f;
        float right = (float)this.mWidth - (float)(this.mWidth - this.mCarIconWidth) / 2.0f;
        float top = dot - (float)this.mCarIconHeight / 2.0f;
        float bottom = dot + (float)this.mCarIconHeight / 2.0f;
        return new RectF(left, top, right, bottom);
    }

    public Paint getPaint(int state) {
        this.mDrawContentPaint.reset();
        switch (state) {
            case 1: {
                this.mDrawContentPaint.setColor(Color.parseColor((String)"#43CA63"));
                break;
            }
            case 2: {
                this.mDrawContentPaint.setColor(Color.parseColor((String)"#F9B000"));
                break;
            }
            case 3: {
                this.mDrawContentPaint.setColor(Color.parseColor((String)"#F45956"));
                break;
            }
            case 4: {
                this.mDrawContentPaint.setColor(Color.parseColor((String)"#701200"));
                break;
            }
            case 0: 
            case 5: {
                this.mDrawContentPaint.setColor(Color.parseColor((String)"#3385FE"));
                break;
            }
            default: {
                this.mDrawContentPaint.setColor(Color.parseColor((String)"#C3C0C0"));
            }
        }
        return this.mDrawContentPaint;
    }
}

