/*
 * Decompiled with CFR 0.152.
 */
package overlay;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import com.amap.api.maps.AMap;
import com.amap.api.maps.CameraUpdateFactory;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.Polyline;
import com.amap.api.maps.model.PolylineOptions;
import com.sd.api.R;
import java.util.ArrayList;
import java.util.List;

public class RouteOverlay {
    protected List<Marker> stationMarkers = new ArrayList<Marker>();
    protected List<Polyline> allPolyLines = new ArrayList<Polyline>();
    protected Marker startMarker;
    protected Marker endMarker;
    protected LatLng startPoint;
    protected LatLng endPoint;
    protected AMap mAMap;
    private Context mContext;
    private Bitmap startBit;
    private Bitmap endBit;
    private Bitmap busBit;
    private Bitmap walkBit;
    private Bitmap driveBit;
    protected boolean nodeIconVisible = true;

    public RouteOverlay(Context context) {
        this.mContext = context;
    }

    public void removeFromMap() {
        if (this.startMarker != null) {
            this.startMarker.remove();
        }
        if (this.endMarker != null) {
            this.endMarker.remove();
        }
        for (Marker marker : this.stationMarkers) {
            marker.remove();
        }
        for (Polyline line : this.allPolyLines) {
            line.remove();
        }
        this.destroyBit();
    }

    private void destroyBit() {
        if (this.startBit != null) {
            this.startBit.recycle();
            this.startBit = null;
        }
        if (this.endBit != null) {
            this.endBit.recycle();
            this.endBit = null;
        }
        if (this.busBit != null) {
            this.busBit.recycle();
            this.busBit = null;
        }
        if (this.walkBit != null) {
            this.walkBit.recycle();
            this.walkBit = null;
        }
        if (this.driveBit != null) {
            this.driveBit.recycle();
            this.driveBit = null;
        }
    }

    protected BitmapDescriptor getStartBitmapDescriptor() {
        return BitmapDescriptorFactory.fromResource((int)R.drawable.amap_start);
    }

    protected BitmapDescriptor getEndBitmapDescriptor() {
        return BitmapDescriptorFactory.fromResource((int)R.drawable.amap_end);
    }

    protected BitmapDescriptor getBusBitmapDescriptor() {
        return BitmapDescriptorFactory.fromResource((int)R.drawable.amap_bus);
    }

    protected BitmapDescriptor getWalkBitmapDescriptor() {
        return BitmapDescriptorFactory.fromResource((int)R.drawable.amap_man);
    }

    protected BitmapDescriptor getDriveBitmapDescriptor() {
        return BitmapDescriptorFactory.fromResource((int)R.drawable.amap_car);
    }

    protected void addStartAndEndMarker() {
        this.startMarker = this.mAMap.addMarker(new MarkerOptions().position(this.startPoint).icon(this.getStartBitmapDescriptor()).title("\u8d77\u70b9"));
        this.endMarker = this.mAMap.addMarker(new MarkerOptions().position(this.endPoint).icon(this.getEndBitmapDescriptor()).title("\u7ec8\u70b9"));
    }

    public void zoomToSpan() {
        if (this.startPoint != null) {
            if (this.mAMap == null) {
                return;
            }
            try {
                LatLngBounds bounds = this.getLatLngBounds();
                this.mAMap.animateCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)bounds, (int)100));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    protected LatLngBounds getLatLngBounds() {
        LatLngBounds.Builder b = LatLngBounds.builder();
        b.include(new LatLng(this.startPoint.latitude, this.startPoint.longitude));
        b.include(new LatLng(this.endPoint.latitude, this.endPoint.longitude));
        return b.build();
    }

    public void setNodeIconVisibility(boolean visible) {
        try {
            this.nodeIconVisible = visible;
            if (this.stationMarkers != null && this.stationMarkers.size() > 0) {
                for (int i = 0; i < this.stationMarkers.size(); ++i) {
                    this.stationMarkers.get(i).setVisible(visible);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void addStationMarker(MarkerOptions options) {
        if (options == null) {
            return;
        }
        Marker marker = this.mAMap.addMarker(options);
        if (marker != null) {
            this.stationMarkers.add(marker);
        }
    }

    protected void addPolyLine(PolylineOptions options) {
        if (options == null) {
            return;
        }
        Polyline polyline = this.mAMap.addPolyline(options);
        if (polyline != null) {
            this.allPolyLines.add(polyline);
        }
    }

    protected float getRouteWidth() {
        return 18.0f;
    }

    protected int getWalkColor() {
        return Color.parseColor((String)"#6db74d");
    }

    protected int getBusColor() {
        return Color.parseColor((String)"#537edc");
    }

    protected int getDriveColor() {
        return Color.parseColor((String)"#537edc");
    }
}

