/*
 * Decompiled with CFR 0.152.
 */
package overlay;

import android.content.Context;
import com.amap.api.maps.AMap;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.PolylineOptions;
import com.amap.api.services.core.LatLonPoint;
import com.amap.api.services.route.RidePath;
import com.amap.api.services.route.RideStep;
import com.sd.api.R;
import com.sd.api.utils.amp.AMapUtil;
import java.util.List;
import overlay.RouteOverlay;

public class RideRouteOverlay
extends RouteOverlay {
    private PolylineOptions mPolylineOptions;
    private BitmapDescriptor walkStationDescriptor = null;
    private RidePath ridePath;

    public RideRouteOverlay(Context context, AMap amap, RidePath path, LatLonPoint start, LatLonPoint end) {
        super(context);
        this.mAMap = amap;
        this.ridePath = path;
        this.startPoint = AMapUtil.convertToLatLng(start);
        this.endPoint = AMapUtil.convertToLatLng(end);
    }

    public void addToMap() {
        this.initPolylineOptions();
        try {
            List ridePaths = this.ridePath.getSteps();
            for (int i = 0; i < ridePaths.size(); ++i) {
                RideStep rideStep = (RideStep)ridePaths.get(i);
                LatLng latLng = AMapUtil.convertToLatLng((LatLonPoint)rideStep.getPolyline().get(0));
                this.addRideStationMarkers(rideStep, latLng);
                this.addRidePolyLines(rideStep);
            }
            this.addStartAndEndMarker();
            this.showPolyline();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void addRidePolyLines(RideStep rideStep) {
        this.mPolylineOptions.addAll(AMapUtil.convertArrList(rideStep.getPolyline()));
    }

    private void addRideStationMarkers(RideStep rideStep, LatLng position) {
        this.addStationMarker(new MarkerOptions().position(position).title("\u65b9\u5411:" + rideStep.getAction() + "\n\u9053\u8def:" + rideStep.getRoad()).snippet(rideStep.getInstruction()).visible(this.nodeIconVisible).anchor(0.5f, 0.5f).icon(this.walkStationDescriptor));
    }

    private void initPolylineOptions() {
        if (this.walkStationDescriptor == null) {
            this.walkStationDescriptor = BitmapDescriptorFactory.fromResource((int)R.drawable.amap_ride);
        }
        this.mPolylineOptions = null;
        this.mPolylineOptions = new PolylineOptions();
        this.mPolylineOptions.color(this.getDriveColor()).width(this.getRouteWidth());
    }

    private void showPolyline() {
        this.addPolyLine(this.mPolylineOptions);
    }
}

