/*
 * Decompiled with CFR 0.152.
 */
package overlay;

import com.amap.api.maps.AMap;
import com.amap.api.maps.CameraUpdateFactory;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.services.core.PoiItem;
import java.util.ArrayList;
import java.util.List;

public class PoiOverlay {
    private List<PoiItem> mPois;
    private AMap mAMap;
    private ArrayList<Marker> mPoiMarks = new ArrayList();

    public PoiOverlay(AMap amap, List<PoiItem> pois) {
        this.mAMap = amap;
        this.mPois = pois;
    }

    public void addToMap() {
        try {
            for (int i = 0; i < this.mPois.size(); ++i) {
                Marker marker = this.mAMap.addMarker(this.getMarkerOptions(i));
                marker.setObject((Object)i);
                this.mPoiMarks.add(marker);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void removeFromMap() {
        for (Marker mark : this.mPoiMarks) {
            mark.remove();
        }
    }

    public void zoomToSpan() {
        try {
            if (this.mPois != null && this.mPois.size() > 0) {
                if (this.mAMap == null) {
                    return;
                }
                if (this.mPois.size() == 1) {
                    this.mAMap.moveCamera(CameraUpdateFactory.newLatLngZoom((LatLng)new LatLng(this.mPois.get(0).getLatLonPoint().getLatitude(), this.mPois.get(0).getLatLonPoint().getLongitude()), (float)18.0f));
                } else {
                    LatLngBounds bounds = this.getLatLngBounds();
                    this.mAMap.moveCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)bounds, (int)5));
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private LatLngBounds getLatLngBounds() {
        LatLngBounds.Builder b = LatLngBounds.builder();
        for (int i = 0; i < this.mPois.size(); ++i) {
            b.include(new LatLng(this.mPois.get(i).getLatLonPoint().getLatitude(), this.mPois.get(i).getLatLonPoint().getLongitude()));
        }
        return b.build();
    }

    private MarkerOptions getMarkerOptions(int index) {
        return new MarkerOptions().position(new LatLng(this.mPois.get(index).getLatLonPoint().getLatitude(), this.mPois.get(index).getLatLonPoint().getLongitude())).title(this.getTitle(index)).snippet(this.getSnippet(index)).icon(this.getBitmapDescriptor(index));
    }

    protected BitmapDescriptor getBitmapDescriptor(int index) {
        return null;
    }

    protected String getTitle(int index) {
        return this.mPois.get(index).getTitle();
    }

    protected String getSnippet(int index) {
        return this.mPois.get(index).getSnippet();
    }

    public int getPoiIndex(Marker marker) {
        for (int i = 0; i < this.mPoiMarks.size(); ++i) {
            if (!this.mPoiMarks.get(i).equals((Object)marker)) continue;
            return i;
        }
        return -1;
    }

    public PoiItem getPoiItem(int index) {
        if (index < 0 || index >= this.mPois.size()) {
            return null;
        }
        return this.mPois.get(index);
    }
}

