/*
 * Decompiled with CFR 0.152.
 */
package overlay;

import android.content.Context;
import android.graphics.Color;
import com.amap.api.maps.AMap;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.PolylineOptions;
import com.amap.api.services.core.LatLonPoint;
import com.amap.api.services.route.DrivePath;
import com.amap.api.services.route.DriveStep;
import com.amap.api.services.route.TMC;
import com.sd.api.R;
import com.sd.api.utils.amp.AMapUtil;
import java.util.ArrayList;
import java.util.List;
import overlay.RouteOverlay;

public class DrivingRouteOverlay
extends RouteOverlay {
    private DrivePath drivePath;
    private List<LatLonPoint> throughPointList;
    private List<Marker> throughPointMarkerList = new ArrayList<Marker>();
    private boolean throughPointMarkerVisible = true;
    private List<TMC> tmcs;
    private PolylineOptions mPolylineOptions;
    private PolylineOptions mPolylineOptionscolor;
    private Context mContext;
    private boolean isColorfulline = true;
    private float mWidth = 25.0f;
    private List<LatLng> mLatLngsOfPath;

    public void setIsColorfulline(boolean iscolorfulline) {
        this.isColorfulline = iscolorfulline;
    }

    public DrivingRouteOverlay(Context context, AMap amap, DrivePath path, LatLonPoint start, LatLonPoint end, List<LatLonPoint> throughPointList) {
        super(context);
        this.mContext = context;
        this.mAMap = amap;
        this.drivePath = path;
        this.startPoint = AMapUtil.convertToLatLng(start);
        this.endPoint = AMapUtil.convertToLatLng(end);
        this.throughPointList = throughPointList;
    }

    @Override
    public float getRouteWidth() {
        return this.mWidth;
    }

    public void setRouteWidth(float mWidth) {
        this.mWidth = mWidth;
    }

    public void addToMap() {
        this.initPolylineOptions();
        try {
            if (this.mAMap == null) {
                return;
            }
            if (this.mWidth == 0.0f || this.drivePath == null) {
                return;
            }
            this.mLatLngsOfPath = new ArrayList<LatLng>();
            this.tmcs = new ArrayList<TMC>();
            List drivePaths = this.drivePath.getSteps();
            for (DriveStep step : drivePaths) {
                List latlonPoints = step.getPolyline();
                List tmclist = step.getTMCs();
                this.tmcs.addAll(tmclist);
                this.addDrivingStationMarkers(step, this.convertToLatLng((LatLonPoint)latlonPoints.get(0)));
                for (LatLonPoint latlonpoint : latlonPoints) {
                    this.mPolylineOptions.add(this.convertToLatLng(latlonpoint));
                    this.mLatLngsOfPath.add(this.convertToLatLng(latlonpoint));
                }
            }
            if (this.startMarker != null) {
                this.startMarker.remove();
                this.startMarker = null;
            }
            if (this.endMarker != null) {
                this.endMarker.remove();
                this.endMarker = null;
            }
            this.addStartAndEndMarker();
            this.addThroughPointMarker();
            if (this.isColorfulline && this.tmcs.size() > 0) {
                this.colorWayUpdate(this.tmcs);
                this.showcolorPolyline();
            } else {
                this.showPolyline();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void initPolylineOptions() {
        this.mPolylineOptions = null;
        this.mPolylineOptions = new PolylineOptions();
        this.mPolylineOptions.color(this.getDriveColor()).setCustomTexture(BitmapDescriptorFactory.fromResource((int)R.drawable.custtexture)).width(this.getRouteWidth());
    }

    private void showPolyline() {
        this.addPolyLine(this.mPolylineOptions);
    }

    private void showcolorPolyline() {
        this.addPolyLine(this.mPolylineOptionscolor);
    }

    private void colorWayUpdate(List<TMC> tmcSection) {
        if (this.mAMap == null) {
            return;
        }
        if (tmcSection == null || tmcSection.size() <= 0) {
            return;
        }
        this.mPolylineOptionscolor = null;
        this.mPolylineOptionscolor = new PolylineOptions();
        this.mPolylineOptionscolor.width(this.getRouteWidth());
        ArrayList<Integer> colorList = new ArrayList<Integer>();
        this.mPolylineOptionscolor.add(AMapUtil.convertToLatLng((LatLonPoint)tmcSection.get(0).getPolyline().get(0)));
        colorList.add(this.getDriveColor());
        for (int i = 0; i < tmcSection.size(); ++i) {
            TMC segmentTrafficStatus = tmcSection.get(i);
            int color2 = this.getcolor(segmentTrafficStatus.getStatus());
            List mployline = segmentTrafficStatus.getPolyline();
            for (int j = 1; j < mployline.size(); ++j) {
                this.mPolylineOptionscolor.add(AMapUtil.convertToLatLng((LatLonPoint)mployline.get(j)));
                colorList.add(color2);
            }
        }
        colorList.add(this.getDriveColor());
        this.mPolylineOptionscolor.colorValues(colorList);
    }

    private int getcolor(String status) {
        if (status.equals("\u7545\u901a")) {
            return -16711936;
        }
        if (status.equals("\u7f13\u884c")) {
            return -256;
        }
        if (status.equals("\u62e5\u5835")) {
            return -65536;
        }
        if (status.equals("\u4e25\u91cd\u62e5\u5835")) {
            return Color.parseColor((String)"#990033");
        }
        return Color.parseColor((String)"#537edc");
    }

    public LatLng convertToLatLng(LatLonPoint point) {
        return new LatLng(point.getLatitude(), point.getLongitude());
    }

    private void addDrivingStationMarkers(DriveStep driveStep, LatLng latLng) {
        this.addStationMarker(new MarkerOptions().position(latLng).title("\u65b9\u5411:" + driveStep.getAction() + "\n\u9053\u8def:" + driveStep.getRoad()).snippet(driveStep.getInstruction()).visible(this.nodeIconVisible).anchor(0.5f, 0.5f).icon(this.getDriveBitmapDescriptor()));
    }

    @Override
    protected LatLngBounds getLatLngBounds() {
        LatLngBounds.Builder b = LatLngBounds.builder();
        b.include(new LatLng(this.startPoint.latitude, this.startPoint.longitude));
        b.include(new LatLng(this.endPoint.latitude, this.endPoint.longitude));
        if (this.throughPointList != null && this.throughPointList.size() > 0) {
            for (int i = 0; i < this.throughPointList.size(); ++i) {
                b.include(new LatLng(this.throughPointList.get(i).getLatitude(), this.throughPointList.get(i).getLongitude()));
            }
        }
        return b.build();
    }

    public void setThroughPointIconVisibility(boolean visible) {
        try {
            this.throughPointMarkerVisible = visible;
            if (this.throughPointMarkerList != null && this.throughPointMarkerList.size() > 0) {
                for (int i = 0; i < this.throughPointMarkerList.size(); ++i) {
                    this.throughPointMarkerList.get(i).setVisible(visible);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void addThroughPointMarker() {
        if (this.throughPointList != null && this.throughPointList.size() > 0) {
            LatLonPoint latLonPoint = null;
            for (int i = 0; i < this.throughPointList.size(); ++i) {
                latLonPoint = this.throughPointList.get(i);
                if (latLonPoint == null) continue;
                this.throughPointMarkerList.add(this.mAMap.addMarker(new MarkerOptions().position(new LatLng(latLonPoint.getLatitude(), latLonPoint.getLongitude())).visible(this.throughPointMarkerVisible).icon(this.getThroughPointBitDes()).title("\u9014\u7ecf\u70b9")));
            }
        }
    }

    private BitmapDescriptor getThroughPointBitDes() {
        return BitmapDescriptorFactory.fromResource((int)R.drawable.amap_through);
    }

    public static int calculateDistance(LatLng start, LatLng end) {
        double x1 = start.longitude;
        double y1 = start.latitude;
        double x2 = end.longitude;
        double y2 = end.latitude;
        return DrivingRouteOverlay.calculateDistance(x1, y1, x2, y2);
    }

    public static int calculateDistance(double x1, double y1, double x2, double y2) {
        double NF_pi = 0.01745329251994329;
        x2 *= 0.01745329251994329;
        y2 *= 0.01745329251994329;
        double sinx1 = Math.sin(x1 *= 0.01745329251994329);
        double siny1 = Math.sin(y1 *= 0.01745329251994329);
        double cosx1 = Math.cos(x1);
        double cosy1 = Math.cos(y1);
        double sinx2 = Math.sin(x2);
        double siny2 = Math.sin(y2);
        double cosx2 = Math.cos(x2);
        double cosy2 = Math.cos(y2);
        double[] v1 = new double[]{cosy1 * cosx1 - cosy2 * cosx2, cosy1 * sinx1 - cosy2 * sinx2, siny1 - siny2};
        double dist = Math.sqrt(v1[0] * v1[0] + v1[1] * v1[1] + v1[2] * v1[2]);
        return (int)(Math.asin(dist / 2.0) * 1.27420015798544E7);
    }

    public static LatLng getPointForDis(LatLng sPt, LatLng ePt, double dis) {
        double lSegLength = DrivingRouteOverlay.calculateDistance(sPt, ePt);
        double preResult = dis / lSegLength;
        return new LatLng((ePt.latitude - sPt.latitude) * preResult + sPt.latitude, (ePt.longitude - sPt.longitude) * preResult + sPt.longitude);
    }

    @Override
    public void removeFromMap() {
        try {
            super.removeFromMap();
            if (this.throughPointMarkerList != null && this.throughPointMarkerList.size() > 0) {
                for (int i = 0; i < this.throughPointMarkerList.size(); ++i) {
                    this.throughPointMarkerList.get(i).remove();
                }
                this.throughPointMarkerList.clear();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

