/*
 * Decompiled with CFR 0.152.
 */
package overlay;

import android.content.Context;
import com.amap.api.maps.AMap;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.PolylineOptions;
import com.amap.api.services.busline.BusStationItem;
import com.amap.api.services.core.LatLonPoint;
import com.amap.api.services.route.BusPath;
import com.amap.api.services.route.BusStep;
import com.amap.api.services.route.Doorway;
import com.amap.api.services.route.RailwayStationItem;
import com.amap.api.services.route.RouteBusLineItem;
import com.amap.api.services.route.RouteBusWalkItem;
import com.amap.api.services.route.RouteRailwayItem;
import com.amap.api.services.route.TaxiItem;
import com.amap.api.services.route.WalkStep;
import com.sd.api.utils.amp.AMapUtil;
import java.util.ArrayList;
import java.util.List;
import overlay.RouteOverlay;

public class BusRouteOverlay
extends RouteOverlay {
    private BusPath busPath;
    private LatLng latLng;

    public BusRouteOverlay(Context context, AMap amap, BusPath path, LatLonPoint start, LatLonPoint end) {
        super(context);
        this.busPath = path;
        this.startPoint = AMapUtil.convertToLatLng(start);
        this.endPoint = AMapUtil.convertToLatLng(end);
        this.mAMap = amap;
    }

    public void addToMap() {
        try {
            List busSteps = this.busPath.getSteps();
            for (int i = 0; i < busSteps.size(); ++i) {
                BusStep busStep = (BusStep)busSteps.get(i);
                if (i < busSteps.size() - 1) {
                    BusStep busStep1 = (BusStep)busSteps.get(i + 1);
                    if (busStep.getWalk() != null && busStep.getBusLine() != null) {
                        this.checkWalkToBusline(busStep);
                    }
                    if (busStep.getBusLine() != null && busStep1.getWalk() != null && busStep1.getWalk().getSteps().size() > 0) {
                        this.checkBusLineToNextWalk(busStep, busStep1);
                    }
                    if (busStep.getBusLine() != null && busStep1.getWalk() == null && busStep1.getBusLine() != null) {
                        this.checkBusEndToNextBusStart(busStep, busStep1);
                    }
                    if (busStep.getBusLine() != null && busStep1.getWalk() == null && busStep1.getBusLine() != null) {
                        this.checkBusToNextBusNoWalk(busStep, busStep1);
                    }
                    if (busStep.getBusLine() != null && busStep1.getRailway() != null) {
                        this.checkBusLineToNextRailway(busStep, busStep1);
                    }
                    if (busStep1.getWalk() != null && busStep1.getWalk().getSteps().size() > 0 && busStep.getRailway() != null) {
                        this.checkRailwayToNextWalk(busStep, busStep1);
                    }
                    if (busStep1.getRailway() != null && busStep.getRailway() != null) {
                        this.checkRailwayToNextRailway(busStep, busStep1);
                    }
                    if (busStep.getRailway() != null && busStep1.getTaxi() != null) {
                        this.checkRailwayToNextTaxi(busStep, busStep1);
                    }
                }
                if (busStep.getWalk() != null && busStep.getWalk().getSteps().size() > 0) {
                    this.addWalkSteps(busStep);
                } else if (busStep.getBusLine() == null && busStep.getRailway() == null && busStep.getTaxi() == null) {
                    this.addWalkPolyline(this.latLng, this.endPoint);
                }
                if (busStep.getBusLine() != null) {
                    RouteBusLineItem routeBusLineItem = busStep.getBusLine();
                    this.addBusLineSteps(routeBusLineItem);
                    this.addBusStationMarkers(routeBusLineItem);
                    if (i == busSteps.size() - 1) {
                        this.addWalkPolyline(AMapUtil.convertToLatLng(this.getLastBuslinePoint(busStep)), this.endPoint);
                    }
                }
                if (busStep.getRailway() != null) {
                    this.addRailwayStep(busStep.getRailway());
                    this.addRailwayMarkers(busStep.getRailway());
                    if (i == busSteps.size() - 1) {
                        this.addWalkPolyline(AMapUtil.convertToLatLng(busStep.getRailway().getArrivalstop().getLocation()), this.endPoint);
                    }
                }
                if (busStep.getTaxi() == null) continue;
                this.addTaxiStep(busStep.getTaxi());
                this.addTaxiMarkers(busStep.getTaxi());
            }
            this.addStartAndEndMarker();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void checkRailwayToNextTaxi(BusStep busStep, BusStep busStep1) {
        LatLonPoint taxiFirstPoint;
        LatLonPoint railwayLastPoint = busStep.getRailway().getArrivalstop().getLocation();
        if (!railwayLastPoint.equals((Object)(taxiFirstPoint = busStep1.getTaxi().getOrigin()))) {
            this.addWalkPolyLineByLatLonPoints(railwayLastPoint, taxiFirstPoint);
        }
    }

    private void checkRailwayToNextRailway(BusStep busStep, BusStep busStep1) {
        LatLonPoint railwayFirstPoint;
        LatLonPoint railwayLastPoint = busStep.getRailway().getArrivalstop().getLocation();
        if (!railwayLastPoint.equals((Object)(railwayFirstPoint = busStep1.getRailway().getDeparturestop().getLocation()))) {
            this.addWalkPolyLineByLatLonPoints(railwayLastPoint, railwayFirstPoint);
        }
    }

    private void checkBusLineToNextRailway(BusStep busStep, BusStep busStep1) {
        LatLonPoint railwayFirstPoint;
        LatLonPoint busLastPoint = this.getLastBuslinePoint(busStep);
        if (!busLastPoint.equals((Object)(railwayFirstPoint = busStep1.getRailway().getDeparturestop().getLocation()))) {
            this.addWalkPolyLineByLatLonPoints(busLastPoint, railwayFirstPoint);
        }
    }

    private void checkRailwayToNextWalk(BusStep busStep, BusStep busStep1) {
        LatLonPoint walkFirstPoint;
        LatLonPoint railwayLastPoint = busStep.getRailway().getArrivalstop().getLocation();
        if (!railwayLastPoint.equals((Object)(walkFirstPoint = this.getFirstWalkPoint(busStep1)))) {
            this.addWalkPolyLineByLatLonPoints(railwayLastPoint, walkFirstPoint);
        }
    }

    private void addRailwayStep(RouteRailwayItem railway) {
        ArrayList<LatLng> railwaylistpoint = new ArrayList<LatLng>();
        ArrayList<RailwayStationItem> railwayStationItems = new ArrayList<RailwayStationItem>();
        railwayStationItems.add(railway.getDeparturestop());
        railwayStationItems.addAll(railway.getViastops());
        railwayStationItems.add(railway.getArrivalstop());
        for (int i = 0; i < railwayStationItems.size(); ++i) {
            railwaylistpoint.add(AMapUtil.convertToLatLng(((RailwayStationItem)railwayStationItems.get(i)).getLocation()));
        }
        this.addRailwayPolyline(railwaylistpoint);
    }

    private void addTaxiStep(TaxiItem taxi) {
        this.addPolyLine(new PolylineOptions().width(this.getRouteWidth()).color(this.getBusColor()).add(AMapUtil.convertToLatLng(taxi.getOrigin())).add(AMapUtil.convertToLatLng(taxi.getDestination())));
    }

    private void addWalkSteps(BusStep busStep) {
        RouteBusWalkItem routeBusWalkItem = busStep.getWalk();
        List walkSteps = routeBusWalkItem.getSteps();
        for (int j = 0; j < walkSteps.size(); ++j) {
            LatLng firstlatLatLng;
            LatLng lastLatLng;
            WalkStep walkStep = (WalkStep)walkSteps.get(j);
            if (j == 0) {
                LatLng latLng = AMapUtil.convertToLatLng((LatLonPoint)walkStep.getPolyline().get(0));
                String road = walkStep.getRoad();
                String instruction = this.getWalkSnippet(walkSteps);
                this.addWalkStationMarkers(latLng, road, instruction);
            }
            ArrayList<LatLng> listWalkPolyline = AMapUtil.convertArrList(walkStep.getPolyline());
            this.latLng = (LatLng)listWalkPolyline.get(listWalkPolyline.size() - 1);
            this.addWalkPolyline(listWalkPolyline);
            if (j >= walkSteps.size() - 1 || (lastLatLng = (LatLng)listWalkPolyline.get(listWalkPolyline.size() - 1)).equals((Object)(firstlatLatLng = AMapUtil.convertToLatLng((LatLonPoint)((WalkStep)walkSteps.get(j + 1)).getPolyline().get(0))))) continue;
            this.addWalkPolyline(lastLatLng, firstlatLatLng);
        }
    }

    private void addBusLineSteps(RouteBusLineItem routeBusLineItem) {
        this.addBusLineSteps(routeBusLineItem.getPolyline());
    }

    private void addBusLineSteps(List<LatLonPoint> listPoints) {
        if (listPoints.size() < 1) {
            return;
        }
        this.addPolyLine(new PolylineOptions().width(this.getRouteWidth()).color(this.getBusColor()).addAll(AMapUtil.convertArrList(listPoints)));
    }

    private void addWalkStationMarkers(LatLng latLng, String title, String snippet) {
        this.addStationMarker(new MarkerOptions().position(latLng).title(title).snippet(snippet).anchor(0.5f, 0.5f).visible(this.nodeIconVisible).icon(this.getWalkBitmapDescriptor()));
    }

    private void addBusStationMarkers(RouteBusLineItem routeBusLineItem) {
        BusStationItem startBusStation = routeBusLineItem.getDepartureBusStation();
        LatLng position = AMapUtil.convertToLatLng(startBusStation.getLatLonPoint());
        String title = routeBusLineItem.getBusLineName();
        String snippet = this.getBusSnippet(routeBusLineItem);
        this.addStationMarker(new MarkerOptions().position(position).title(title).snippet(snippet).anchor(0.5f, 0.5f).visible(this.nodeIconVisible).icon(this.getBusBitmapDescriptor()));
    }

    private void addTaxiMarkers(TaxiItem taxiItem) {
        LatLng position = AMapUtil.convertToLatLng(taxiItem.getOrigin());
        String title = taxiItem.getmSname() + "\u6253\u8f66";
        String snippet = "\u5230\u7ec8\u70b9";
        this.addStationMarker(new MarkerOptions().position(position).title(title).snippet(snippet).anchor(0.5f, 0.5f).visible(this.nodeIconVisible).icon(this.getDriveBitmapDescriptor()));
    }

    private void addRailwayMarkers(RouteRailwayItem railway) {
        LatLng Departureposition = AMapUtil.convertToLatLng(railway.getDeparturestop().getLocation());
        String Departuretitle = railway.getDeparturestop().getName() + "\u4e0a\u8f66";
        String Departuresnippet = railway.getName();
        this.addStationMarker(new MarkerOptions().position(Departureposition).title(Departuretitle).snippet(Departuresnippet).anchor(0.5f, 0.5f).visible(this.nodeIconVisible).icon(this.getBusBitmapDescriptor()));
        LatLng Arrivalposition = AMapUtil.convertToLatLng(railway.getArrivalstop().getLocation());
        String Arrivaltitle = railway.getArrivalstop().getName() + "\u4e0b\u8f66";
        String Arrivalsnippet = railway.getName();
        this.addStationMarker(new MarkerOptions().position(Arrivalposition).title(Arrivaltitle).snippet(Arrivalsnippet).anchor(0.5f, 0.5f).visible(this.nodeIconVisible).icon(this.getBusBitmapDescriptor()));
    }

    private void checkBusToNextBusNoWalk(BusStep busStep, BusStep busStep1) {
        LatLng endbusLatLng = AMapUtil.convertToLatLng(this.getLastBuslinePoint(busStep));
        LatLng startbusLatLng = AMapUtil.convertToLatLng(this.getFirstBuslinePoint(busStep1));
        if (startbusLatLng.latitude - endbusLatLng.latitude > 1.0E-4 || startbusLatLng.longitude - endbusLatLng.longitude > 1.0E-4) {
            this.drawLineArrow(endbusLatLng, startbusLatLng);
        }
    }

    private void checkBusEndToNextBusStart(BusStep busStep, BusStep busStep1) {
        LatLonPoint busFirstPoint;
        LatLng startbusLatLng;
        LatLonPoint busLastPoint = this.getLastBuslinePoint(busStep);
        LatLng endbusLatLng = AMapUtil.convertToLatLng(busLastPoint);
        if (!endbusLatLng.equals((Object)(startbusLatLng = AMapUtil.convertToLatLng(busFirstPoint = this.getFirstBuslinePoint(busStep1))))) {
            this.drawLineArrow(endbusLatLng, startbusLatLng);
        }
    }

    private void checkBusLineToNextWalk(BusStep busStep, BusStep busStep1) {
        LatLonPoint walkFirstPoint;
        LatLonPoint busLastPoint = this.getLastBuslinePoint(busStep);
        if (!busLastPoint.equals((Object)(walkFirstPoint = this.getFirstWalkPoint(busStep1)))) {
            this.addWalkPolyLineByLatLonPoints(busLastPoint, walkFirstPoint);
        }
    }

    private void checkWalkToBusline(BusStep busStep) {
        LatLonPoint buslineFirstPoint;
        LatLonPoint walkLastPoint = this.getLastWalkPoint(busStep);
        if (!walkLastPoint.equals((Object)(buslineFirstPoint = this.getFirstBuslinePoint(busStep)))) {
            this.addWalkPolyLineByLatLonPoints(walkLastPoint, buslineFirstPoint);
        }
    }

    private LatLonPoint getFirstWalkPoint(BusStep busStep1) {
        return (LatLonPoint)((WalkStep)busStep1.getWalk().getSteps().get(0)).getPolyline().get(0);
    }

    private void addWalkPolyLineByLatLonPoints(LatLonPoint pointFrom, LatLonPoint pointTo) {
        LatLng latLngFrom = AMapUtil.convertToLatLng(pointFrom);
        LatLng latLngTo = AMapUtil.convertToLatLng(pointTo);
        this.addWalkPolyline(latLngFrom, latLngTo);
    }

    private void addWalkPolyline(LatLng latLngFrom, LatLng latLngTo) {
        this.addPolyLine(new PolylineOptions().add(new LatLng[]{latLngFrom, latLngTo}).width(this.getRouteWidth()).color(this.getWalkColor()).setDottedLine(true));
    }

    private void addWalkPolyline(List<LatLng> listWalkPolyline) {
        this.addPolyLine(new PolylineOptions().addAll(listWalkPolyline).color(this.getWalkColor()).width(this.getRouteWidth()).setDottedLine(true));
    }

    private void addRailwayPolyline(List<LatLng> listPolyline) {
        this.addPolyLine(new PolylineOptions().addAll(listPolyline).color(this.getDriveColor()).width(this.getRouteWidth()));
    }

    private String getWalkSnippet(List<WalkStep> walkSteps) {
        float disNum = 0.0f;
        for (WalkStep step : walkSteps) {
            disNum += step.getDistance();
        }
        return "\u6b65\u884c" + disNum + "\u7c73";
    }

    public void drawLineArrow(LatLng latLngFrom, LatLng latLngTo) {
        this.addPolyLine(new PolylineOptions().add(new LatLng[]{latLngFrom, latLngTo}).width(3.0f).color(this.getBusColor()).width(this.getRouteWidth()));
    }

    private String getBusSnippet(RouteBusLineItem routeBusLineItem) {
        return "(" + routeBusLineItem.getDepartureBusStation().getBusStationName() + "-->" + routeBusLineItem.getArrivalBusStation().getBusStationName() + ") \u7ecf\u8fc7" + (routeBusLineItem.getPassStationNum() + 1) + "\u7ad9";
    }

    private LatLonPoint getLastWalkPoint(BusStep busStep) {
        List walkSteps = busStep.getWalk().getSteps();
        WalkStep walkStep = (WalkStep)walkSteps.get(walkSteps.size() - 1);
        List lonPoints = walkStep.getPolyline();
        return (LatLonPoint)lonPoints.get(lonPoints.size() - 1);
    }

    private LatLonPoint getExitPoint(BusStep busStep) {
        Doorway doorway = busStep.getExit();
        if (doorway == null) {
            return null;
        }
        return doorway.getLatLonPoint();
    }

    private LatLonPoint getLastBuslinePoint(BusStep busStep) {
        List lonPoints = busStep.getBusLine().getPolyline();
        return (LatLonPoint)lonPoints.get(lonPoints.size() - 1);
    }

    private LatLonPoint getEntrancePoint(BusStep busStep) {
        Doorway doorway = busStep.getEntrance();
        if (doorway == null) {
            return null;
        }
        return doorway.getLatLonPoint();
    }

    private LatLonPoint getFirstBuslinePoint(BusStep busStep) {
        return (LatLonPoint)busStep.getBusLine().getPolyline().get(0);
    }
}

