/*
 * Decompiled with CFR 0.152.
 */
package com.sd.api.ui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.core.content.ContextCompat;
import com.minedata.minenavi.mapdal.NativeEnv;
import com.minedata.minenavi.navi.LaneDetector;
import com.sd.api.R;
import java.io.InputStream;
import java.util.ArrayList;

@SuppressLint(value={"NewApi"})
public class MyLaneView
extends LinearLayout
implements LaneDetector.OnLaneDetectorListener {
    private static final String ASSET_PREFIX = "land/";
    private LaneDetector mLaneDetector = null;
    private int mHeight = 0;
    private LaneDetector.LaneIconId[] mLaneIconIds = null;
    private Drawable mNormDraw = null;
    private int mIconMargin = 0;
    private ArrayList<LaneDetector.OnLaneDetectorListener> mListeners = new ArrayList();
    private Context context;
    private AssetManager assetManager;

    public MyLaneView(Context context) {
        super(context);
        this.init();
    }

    public MyLaneView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public void addListener(LaneDetector.OnLaneDetectorListener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(LaneDetector.OnLaneDetectorListener listener) {
        this.mListeners.remove(listener);
    }

    public void onLaneDetectorEvent(int event, Object data) {
        switch (event) {
            case 1: {
                this.mLaneIconIds = (LaneDetector.LaneIconId[])data;
                this.layoutLanes();
            }
        }
        for (LaneDetector.OnLaneDetectorListener onLaneDetectorListener : this.mListeners) {
            onLaneDetectorListener.onLaneDetectorEvent(event, data);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mHeight = this.getMeasuredHeight();
    }

    private void init() {
        this.setOrientation(0);
        this.context = this.getContext();
        this.assetManager = this.context.getAssets();
        this.mLaneDetector = new LaneDetector();
        this.mLaneDetector.addListener((LaneDetector.OnLaneDetectorListener)this);
        this.mNormDraw = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.l2_1);
        this.mIconMargin = NativeEnv.dp2px((float)2.0f);
        this.setGravity(16);
    }

    private void layoutLanes() {
        if (this.mLaneIconIds.length == 0) {
            return;
        }
        this.removeAllViews();
        this.layout();
    }

    private void layout() {
        if (this.mHeight == 0) {
            this.mHeight = NativeEnv.dp2px((float)50.0f);
        }
        int iconHeight = this.mHeight - this.getPaddingTop() - this.getPaddingBottom();
        int iconWidth = iconHeight * this.mNormDraw.getIntrinsicWidth() / this.mNormDraw.getIntrinsicHeight();
        for (int i = 0; i < this.mLaneIconIds.length; ++i) {
            ImageView view = this.createLaneItemView(this.mLaneIconIds[i], iconWidth, iconHeight);
            if (view == null) continue;
            this.addView((View)view);
            if (i == this.mLaneIconIds.length - 1) continue;
            this.addView((View)this.createSepView(iconHeight));
        }
    }

    private ImageView createLaneItemView(LaneDetector.LaneIconId iconId, int width, int height) {
        ImageView view = new ImageView(this.context);
        view.setAdjustViewBounds(true);
        try {
            InputStream istr = this.assetManager.open(ASSET_PREFIX + iconId.lowerX + "-" + iconId.lowerY + ".png");
            Drawable d = Drawable.createFromStream((InputStream)istr, null);
            if (d != null) {
                view.setAdjustViewBounds(true);
                view.setScaleType(ImageView.ScaleType.CENTER_CROP);
                view.setImageDrawable(d);
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, height);
                view.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
        catch (Exception e) {
            return null;
        }
        return view;
    }

    private void layoutTest() {
        if (this.mHeight == 0) {
            this.mHeight = NativeEnv.dp2px((float)50.0f);
        }
        int len = 5;
        int iconHeight = this.mHeight - this.getPaddingTop() - this.getPaddingBottom();
        int iconWidth = iconHeight * this.mNormDraw.getIntrinsicWidth() / this.mNormDraw.getIntrinsicHeight();
        for (int i = 0; i < len; ++i) {
            ImageView view = this.createLaneItemViewTest(iconWidth, iconHeight);
            if (view == null) continue;
            this.addView((View)view);
            if (i == len - 1) continue;
            this.addView((View)this.createSepView(iconHeight));
        }
    }

    private ImageView createLaneItemViewTest(int width, int height) {
        ImageView view = new ImageView(this.context);
        view.setAdjustViewBounds(true);
        try {
            InputStream istr = this.assetManager.open("land/2-1.png");
            Drawable d = Drawable.createFromStream((InputStream)istr, null);
            if (d != null) {
                view.setImageDrawable(d);
            }
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, height);
            view.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return view;
    }

    private ImageView createSepView(int height) {
        ImageView view = new ImageView(this.context);
        ColorDrawable colorDrawable = new ColorDrawable(Color.parseColor((String)"#99FFFFFF"));
        view.setBackground((Drawable)colorDrawable);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -1);
        params.width = NativeEnv.dp2px((float)1.0f);
        params.height = height - NativeEnv.dp2px((float)2.0f);
        params.setMargins(this.mIconMargin, 0, this.mIconMargin, 0);
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        return view;
    }
}

