/*
 * Decompiled with CFR 0.152.
 */
package com.sd.api.ui.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import com.minedata.minenavi.navi.TmcSections;
import com.sd.api.R;
import com.sd.api.ui.widget.TmcBarSegment;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001d\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB%\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0002J\u000e\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020\u0013J\u000e\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020!J\u0010\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020-H\u0014J \u0010.\u001a\u00020%2\u0006\u0010,\u001a\u00020-2\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\nH\u0002R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R*\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u0019j\b\u0012\u0004\u0012\u00020\u001a`\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/sd/api/ui/widget/HorCarTmc;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mDrawPadding", "mCarIcon", "Landroid/graphics/Bitmap;", "mPublicPaint", "Landroid/graphics/Paint;", "mDrawContentPaint", "mTmcSections", "Lcom/minedata/minenavi/navi/TmcSections;", "getMTmcSections", "()Lcom/minedata/minenavi/navi/TmcSections;", "setMTmcSections", "(Lcom/minedata/minenavi/navi/TmcSections;)V", "mTmcBarSegments", "Ljava/util/ArrayList;", "Lcom/sd/api/ui/widget/TmcBarSegment;", "Lkotlin/collections/ArrayList;", "getMTmcBarSegments", "()Ljava/util/ArrayList;", "setMTmcBarSegments", "(Ljava/util/ArrayList;)V", "mHalfCarIconHeight", "", "mHalfCarIconWidget", "mRatio", "init", "", "initPaint", "setTmcSections", "tmcSections", "updateRatio", "ratio", "onDraw", "canvas", "Landroid/graphics/Canvas;", "drawCar", "height", "width", "mapapi_debug"})
public final class HorCarTmc
extends LinearLayout {
    private int mDrawPadding = 3;
    private Bitmap mCarIcon;
    private Paint mPublicPaint;
    private Paint mDrawContentPaint;
    @Nullable
    private TmcSections mTmcSections;
    @NotNull
    private ArrayList<TmcBarSegment> mTmcBarSegments = new ArrayList();
    private float mHalfCarIconHeight;
    private float mHalfCarIconWidget;
    private float mRatio;

    public HorCarTmc(@Nullable Context context) {
        super(context);
    }

    public HorCarTmc(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs, 0);
        this.init();
    }

    public HorCarTmc(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @Nullable
    public final TmcSections getMTmcSections() {
        return this.mTmcSections;
    }

    public final void setMTmcSections(@Nullable TmcSections tmcSections) {
        this.mTmcSections = tmcSections;
    }

    @NotNull
    public final ArrayList<TmcBarSegment> getMTmcBarSegments() {
        return this.mTmcBarSegments;
    }

    public final void setMTmcBarSegments(@NotNull ArrayList<TmcBarSegment> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.mTmcBarSegments = arrayList;
    }

    private final void init() {
        this.mDrawPadding = this.getPaddingLeft();
        this.mCarIcon = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.my_small_car);
        this.initPaint();
    }

    private final void initPaint() {
        this.mPublicPaint = new Paint();
        this.mDrawContentPaint = new Paint();
    }

    public final void setTmcSections(@NotNull TmcSections tmcSections) {
        Intrinsics.checkNotNullParameter((Object)tmcSections, (String)"tmcSections");
        int width = this.getWidth();
        int height = this.getHeight();
        if (height < width) {
            TmcSections tmcSections2 = this.mTmcSections = tmcSections;
            Intrinsics.checkNotNull((Object)tmcSections2);
            int[] tempPixels = tmcSections2.pixels;
            int[] pixels = new int[tempPixels.length];
            int n = tempPixels.length;
            for (int i = 0; i < n; ++i) {
                pixels[i] = width * tempPixels[i] / 100;
            }
            TmcSections tmcSections3 = this.mTmcSections;
            Intrinsics.checkNotNull((Object)tmcSections3);
            int[] states = tmcSections3.states;
            this.mTmcBarSegments.clear();
            TmcSections tmcSections4 = this.mTmcSections;
            Intrinsics.checkNotNull((Object)tmcSections4);
            int n2 = tmcSections4.length;
            for (int i = 0; i < n2; ++i) {
                RectF rect;
                TmcBarSegment tmcBarSegment = new TmcBarSegment();
                tmcBarSegment.colorStates = states[i];
                int left = i > 0 ? pixels[i - 1] : 0;
                boolean top = false;
                int right = pixels[i];
                int bottom = height;
                tmcBarSegment.rect = rect = new RectF((float)left, (float)top, (float)right, (float)bottom);
                this.mTmcBarSegments.add(tmcBarSegment);
            }
        }
        this.invalidate();
    }

    public final void updateRatio(float ratio) {
        if ((int)(this.mRatio * (float)1000) == (int)(ratio * (float)1000) && !(ratio == 0.0f)) {
            return;
        }
        this.mRatio = ratio;
        this.invalidate();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        if (height < width) {
            this.drawCar(canvas, height, width);
        }
    }

    private final void drawCar(Canvas canvas, int height, int width) {
        if (height < width) {
            Bitmap bitmap;
            float scaleHeight;
            Bitmap bitmap2 = this.mCarIcon;
            if (bitmap2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCarIcon");
                bitmap2 = null;
            }
            int originalCarIconWidth = bitmap2.getWidth();
            Bitmap bitmap3 = this.mCarIcon;
            if (bitmap3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCarIcon");
                bitmap3 = null;
            }
            int originalCarIconHeight = bitmap3.getHeight();
            float scaleWidth = scaleHeight = (float)Math.round(height * 10 / originalCarIconHeight) / (float)10;
            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            Bitmap bitmap4 = this.mCarIcon;
            if (bitmap4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCarIcon");
                bitmap4 = null;
            }
            if ((bitmap = (this.mCarIcon = Bitmap.createBitmap((Bitmap)bitmap4, (int)0, (int)0, (int)originalCarIconWidth, (int)originalCarIconHeight, (Matrix)matrix, (boolean)true))) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCarIcon");
                bitmap = null;
            }
            this.mHalfCarIconWidget = (float)bitmap.getWidth() * 0.5f;
            Bitmap bitmap5 = this.mCarIcon;
            if (bitmap5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCarIcon");
                bitmap5 = null;
            }
            this.mHalfCarIconHeight = (float)bitmap5.getHeight() * 0.5f;
            canvas.save();
            canvas.translate(this.mHalfCarIconWidget, this.mHalfCarIconHeight);
            float offsetWidth = this.mRatio * (float)width * 0.99f;
            Bitmap bitmap6 = this.mCarIcon;
            if (bitmap6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCarIcon");
                bitmap6 = null;
            }
            int left = -bitmap6.getWidth();
            Bitmap bitmap7 = this.mCarIcon;
            if (bitmap7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCarIcon");
                bitmap7 = null;
            }
            canvas.drawBitmap(bitmap7, (float)left + offsetWidth, -this.mHalfCarIconWidget, null);
        }
    }
}

