/*
 * Decompiled with CFR 0.152.
 */
package com.sd.api.maps;

import android.location.Location;
import com.amap.api.maps.AMapUtils;
import com.amap.api.maps.model.LatLng;
import com.sd.api.MAP_TYPE;
import com.sd.api.MSDKInitializer;
import com.sd.api.maps.cdata.MSLatLng;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lcom/sd/api/maps/MSCalcuMapUtil;", "", "<init>", "()V", "calculateLineDistance", "", "latLng1", "Lcom/sd/api/maps/cdata/MSLatLng;", "latLng2", "calculateArea", "mapapi_debug"})
public final class MSCalcuMapUtil {
    @NotNull
    public static final MSCalcuMapUtil INSTANCE = new MSCalcuMapUtil();

    private MSCalcuMapUtil() {
    }

    public final float calculateLineDistance(@NotNull MSLatLng latLng1, @NotNull MSLatLng latLng2) {
        Intrinsics.checkNotNullParameter((Object)latLng1, (String)"latLng1");
        Intrinsics.checkNotNullParameter((Object)latLng2, (String)"latLng2");
        switch (WhenMappings.$EnumSwitchMapping$0[MSDKInitializer.INSTANCE.getMapType().ordinal()]) {
            case 1: {
                float[] results = new float[1];
                Location.distanceBetween((double)latLng1.getLat(), (double)latLng1.getLng(), (double)latLng2.getLat(), (double)latLng2.getLng(), (float[])results);
                return results[0];
            }
            case 2: {
                LatLng latlngA = new LatLng(latLng1.getLat(), latLng1.getLng());
                LatLng latlngB = new LatLng(latLng2.getLat(), latLng2.getLng());
                float distance = AMapUtils.calculateLineDistance((LatLng)latlngA, (LatLng)latlngB);
                return distance;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public final float calculateArea(@NotNull MSLatLng latLng1, @NotNull MSLatLng latLng2) {
        Intrinsics.checkNotNullParameter((Object)latLng1, (String)"latLng1");
        Intrinsics.checkNotNullParameter((Object)latLng2, (String)"latLng2");
        switch (WhenMappings.$EnumSwitchMapping$0[MSDKInitializer.INSTANCE.getMapType().ordinal()]) {
            case 1: {
                return 0.0f;
            }
            case 2: {
                LatLng leftTopLatlng = new LatLng(latLng1.getLat(), latLng1.getLng());
                LatLng rightBottomLatlng = new LatLng(latLng2.getLat(), latLng2.getLng());
                float area = AMapUtils.calculateArea((LatLng)leftTopLatlng, (LatLng)rightBottomLatlng);
                return area;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MAP_TYPE.values().length];
            try {
                nArray[MAP_TYPE.MINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MAP_TYPE.AMAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

