package com.cusc.map.ui.widget

import android.content.Context
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.graphics.Canvas
import android.graphics.Matrix
import android.graphics.Paint
import android.graphics.RectF
import android.util.AttributeSet
import android.widget.LinearLayout
import com.minedata.minenavi.navi.TmcSections
import com.cusc.map.R

/***横向的汽车**/
class HorCarTmc : LinearLayout {

    constructor(context: Context?) : super(context)
    constructor(context: Context?, attrs: AttributeSet?) : super(context, attrs, 0){
        init()
    }


    constructor(context: Context?, attrs: AttributeSet?, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        init()
    }


//    private lateinit var mUtils: Utils

    //绘制内边距
    private var mDrawPadding = 3

    //车标
    private lateinit var mCarIcon: Bitmap
    private lateinit var mPublicPaint: Paint
    private lateinit var mDrawContentPaint: Paint

    var mTmcSections: TmcSections? = null
    var mTmcBarSegments: ArrayList<TmcBarSegment> = ArrayList()

    private var mHalfCarIconHeight = 0f
    private var mHalfCarIconWidget = 0f

    //行程百分比
    private var mRatio = 0.0f


    private fun init() {
//        mUtils = Utils.getInstance()
        mDrawPadding = paddingLeft
        //        mCarIcon = BitmapFactory.decodeResource(getResources(), R.drawable.small_car_icon);
        mCarIcon = BitmapFactory.decodeResource(resources, R.drawable.my_small_car)
        initPaint()
    }

    private fun initPaint() {
        mPublicPaint = Paint()
        mDrawContentPaint = Paint()
    }

    fun setTmcSections(tmcSections: TmcSections) {
        val width = width
        val height = height
        if (height < width) {
            mTmcSections = tmcSections
            val tempPixels = mTmcSections!!.pixels
            val pixels = IntArray(tempPixels.size)
            for (i in tempPixels.indices) {
                pixels[i] = width * tempPixels[i] / 100
            }
            val states = mTmcSections!!.states
            mTmcBarSegments.clear()

            for (i in 0..<mTmcSections!!.length) {
                val tmcBarSegment = TmcBarSegment()
                tmcBarSegment.colorStates = states[i]
                val left = if (i > 0) pixels[i - 1] else 0
                val top = 0
                val right = pixels[i]
                val bottom = height
                val rect = RectF(left.toFloat(), top.toFloat(), right.toFloat(), bottom.toFloat())
                tmcBarSegment.rect = rect
                mTmcBarSegments.add(tmcBarSegment)
            }
        }
        invalidate()
    }

    fun updateRatio(ratio: Float) {
        if ((this.mRatio * 1000).toInt() == (ratio * 1000).toInt() && ratio != 0f) {
            return
        }
        this.mRatio = ratio
        invalidate()
    }


    override fun onDraw(canvas: Canvas) {
        super.onDraw(canvas)
//        if (mTmcBarSegments.size == 0) {
//            return
//        }
        val width = width
        val height = height
        if (height < width) {
            drawCar(canvas, height, width)
        }
    }

    private fun drawCar(canvas: Canvas, height: Int, width: Int) {
        if (height < width) {
            val originalCarIconWidth = mCarIcon.width
            val originalCarIconHeight = mCarIcon.height
//             计算缩放比例
            val scaleHeight =
                Math.round((height * 10 / originalCarIconHeight).toFloat()).toFloat() / 10
            val scaleWidth = scaleHeight
            val matrix = Matrix()
            matrix.postScale(scaleWidth, scaleHeight)
            // 得到新的图片
            mCarIcon = Bitmap.createBitmap(
                mCarIcon,
                0,
                0,
                originalCarIconWidth,
                originalCarIconHeight,
                matrix,
                true
            )
            mHalfCarIconWidget = mCarIcon.width * 0.5f
            mHalfCarIconHeight = mCarIcon.height * 0.5f

            canvas.save()
            canvas.translate(mHalfCarIconWidget, mHalfCarIconHeight) // 将旋转中心移动
            val offsetWidth = mRatio * width * 0.99f
            //            int left = -mCarIcon.getWidth() - Math.round(mHalfCarIconWidget);
            val left = -mCarIcon.width
            canvas.drawBitmap(mCarIcon, left + offsetWidth, -mHalfCarIconWidget, null)
//            mPublicPaint.reset()
//            mPublicPaint.color = Color.GRAY
//            val grayRectF = RectF(
//                left.toFloat(),
//                -mHalfCarIconHeight,
//                left + offsetWidth + mCarIcon.width,
//                -mHalfCarIconHeight
//            )
//            //            canvas.clipPath(mClipPath, Region.Op.DIFFERENCE);
//            canvas.drawRect(grayRectF, mPublicPaint)

//            canvas.restore()
        }
    }


}